#!/bin/bash
#
# xinetd-config, the configuration script for xinetd, derived from
# RedHat iu-config for cygwin
#
# This file is part of the Cygwin port of xinetd daemon.

# set -x

# Subdirectory where the new package is being installed
PREFIX=/usr

# Directory where the config files are stored
SYSCONFDIR=/etc

progname=$0
auto_answer=""
scriptname="xinetd-config"

request()
{
  if [ "${auto_answer}" = "yes" ]
  then
    return 0
  elif [ "${auto_answer}" = "no" ]
  then
    return 1
  fi

  answer=""
  while [ "X${answer}" != "Xyes" -a "X${answer}" != "Xno" ]
  do
    echo -n "$1 (yes/no) "
    read answer
  done
  if [ "X${answer}" = "Xyes" ]
  then
    return 0
  else
    return 1
  fi
}

# Check how the script has been started.  If it has been started by
# giving the full path and that path is /etc/postinstall, set
# auto_answer to "no".  This allows automatic creation of the
# config files in /etc w/o overwriting them if they already exist.
# Also copy the script to /usr/bin for later use.
progdir=`dirname $0`
if [ "$progdir" = "/etc/postinstall" ]
then
  auto_answer="no"
  echo "Creating ${PREFIX}/bin/${scriptname}"
  cp ${progname} ${PREFIX}/bin/${scriptname}
fi

# Check options

while :
do
  case $# in
  0)
    break
    ;;
  esac

  option=$1
  shift

  case "$option" in
  -d | --debug )
    set -x
    ;;

  -y | --yes )
    auto_answer=yes
    ;;

  -n | --no )
    auto_answer=no
    ;;
  *)
    echo "usage: ${progname} [OPTION]..."
    echo
    echo "This script creates an sysvinit host configuration."
    echo
    echo "Options:"
    echo "    --debug  -d     Enable shell's debug output."
    echo "    --yes    -y     Answer all questions with \"yes\" automatically."
    echo "    --no     -n     Answer all questions with \"no\" automatically."
    echo
    exit 1
    ;;

  esac
done

# Check for ${SYSCONFDIR} directory

if [ -e "${SYSCONFDIR}" -a ! -d "${SYSCONFDIR}" ]
then
  echo
  echo "${SYSCONFDIR} is existant but not a directory."
  echo "Cannot create global configuration files."
  echo
  exit 1
fi

# Create it if necessary

if [ ! -e "${SYSCONFDIR}" ]
then
  mkdir "${SYSCONFDIR}"
  if [ ! -e "${SYSCONFDIR}" ]
  then
    echo
    echo "Creating ${SYSCONFDIR} directory failed"
    echo
    exit 1
  fi
fi

# Check if xinetd.conf exists. If yes, ask for overwriting

if [ -f "${SYSCONFDIR}/xinetd.conf" ]
then
  if request "Overwrite existing xinetd configuration file(s)?"
  then
    rm -f "${SYSCONFDIR}/xinetd.conf"
    if [ -f "${SYSCONFDIR}/xinetd.conf" ]
    then
      echo "Can't overwrite. ${SYSCONFDIR}/xinetd.conf is write protected."
    fi
  fi
fi

if [ ! -f "${SYSCONFDIR}/xinetd.conf" ]
then
  echo "Creating default xinetd configuration files"
  cd ${SYSCONFDIR}
  cat > ${SYSCONFDIR}/xinetd.conf.sh << \TILLEOF
#!/bin/sh
# This is a shell archive (produced by GNU sharutils 4.2.1).
# To extract the files from this archive, save it to some FILE, remove
# everything before the `!/bin/sh' line above, then type `sh FILE'.
#
# Made on 2002-11-10 18:55 EST by <sos@SOS>.
# Source directory was `/tmp'.
#
# Existing files will *not* be overwritten unless `-c' is specified.
#
# This shar contains:
# length mode       name
# ------ ---------- ------------------------------------------
#   1808 -rw-rw-rw- xinetd.conf.tar.bz2
#
save_IFS="${IFS}"
IFS="${IFS}:"
gettext_dir=FAILED
locale_dir=FAILED
first_param="$1"
for dir in $PATH
do
  if test "$gettext_dir" = FAILED && test -f $dir/gettext \
     && ($dir/gettext --version >/dev/null 2>&1)
  then
    set `$dir/gettext --version 2>&1`
    if test "$3" = GNU
    then
      gettext_dir=$dir
    fi
  fi
  if test "$locale_dir" = FAILED && test -f $dir/shar \
     && ($dir/shar --print-text-domain-dir >/dev/null 2>&1)
  then
    locale_dir=`$dir/shar --print-text-domain-dir`
  fi
done
IFS="$save_IFS"
if test "$locale_dir" = FAILED || test "$gettext_dir" = FAILED
then
  echo=echo
else
  TEXTDOMAINDIR=$locale_dir
  export TEXTDOMAINDIR
  TEXTDOMAIN=sharutils
  export TEXTDOMAIN
  echo="$gettext_dir/gettext -s"
fi
if touch -am -t 200112312359.59 $$.touch >/dev/null 2>&1 && test ! -f 200112312359.59 -a -f $$.touch; then
  shar_touch='touch -am -t $1$2$3$4$5$6.$7 "$8"'
elif touch -am 123123592001.59 $$.touch >/dev/null 2>&1 && test ! -f 123123592001.59 -a ! -f 123123592001.5 -a -f $$.touch; then
  shar_touch='touch -am $3$4$5$6$1$2.$7 "$8"'
elif touch -am 1231235901 $$.touch >/dev/null 2>&1 && test ! -f 1231235901 -a -f $$.touch; then
  shar_touch='touch -am $3$4$5$6$2 "$8"'
else
  shar_touch=:
  echo
  $echo 'WARNING: not restoring timestamps.  Consider getting and'
  $echo "installing GNU \`touch', distributed in GNU File Utilities..."
  echo
fi
rm -f 200112312359.59 123123592001.59 123123592001.5 1231235901 $$.touch
#
if mkdir _sh01864; then
  $echo 'x -' 'creating lock directory'
else
  $echo 'failed to create lock directory'
  exit 1
fi
# ============= xinetd.conf.tar.bz2 ==============
if test -f 'xinetd.conf.tar.bz2' && test "$first_param" != -c; then
  $echo 'x -' SKIPPING 'xinetd.conf.tar.bz2' '(file already exists)'
else
  $echo 'x -' extracting 'xinetd.conf.tar.bz2' '(binary)'
  sed 's/^X//' << 'SHAR_EOF' | uudecode &&
begin 600 xinetd.conf.tar.bz2
M0EIH.3%!62936>W>M(D`#:9_]^7]`0!(;__Z+V_^I/_O_^H@`!````(+(X#`
M$!``"&`(;X/0`H```````-#*4TF$P3)H8`0R&1H8``1D]3)@`)C1Z0YDTT,@
M`8C(,@!I@@8@&C30`9`T`',FFAD`#$9!D`-,$#$`T::`#(&@`:94DR#R:@!@
M30T``,`"`R,@T8@&C!S)IH9``Q&09`#3!`Q`-&F@`R!H`$20FB":9!-3RCTI
MZ&@%,1LIIY-$]$>IL)`>4``V`D!=K?`4_;C#"I<"N!E=5_(T<$"2Y)#,D!#I
M`""$=0JCZ_7I7O/O_!BMUX?!G.;*%U")>(VN:8K3-KE9P5G$\=:OF29S@M6,
M7M?U*&Y`2.PA`D_@G5X4O@%F2P2[YIB8)`OB"2R]P6A<;-DE0TE@+EPJQ(!(
MOWD5:"*,&!/O&B!$J/K.U4(P"$$C%`"0`UT"B"D`$NN[5:2'V29%QPT*I))*
M6:6O6&T#24<A*IQ1[<R&`_1\M!]&V!-WHF^>]C*>^/PP*Z:>NOF$V_AO^Q3/
M@?"IU$(7`\`-@A&'Q]_GTK/GTKS]B5*FC3SY5U^\8]?CZZT?;/=!(H[PA[JA
M`36WEVN.S&/$3(E03O9]&;TOIWB%#\$J'TD/H$AOS0.[<)[UO`S2^DIPPT`]
MX?JT0Y_1P/+>="Q[0$*]PQX9P<Z_.Y-G.#]9P,>W?]VZC0T.U`M$"DHV*.-F
MP:.SPO8GL_?Q<F2C0#JG].QL:;T'H=Z!L;HGZS3/X;^/P7-LE#:/;M7;P[[<
M9WU51ZC)1I.0-ZZI88-6"*4?E+FO:4%PZ:8V.W<=X&FG;._C\)P0]Q3_N,0(
MP#/.O:.Z-P<[`:^1#>?T`^["ZH#FHD4444&R0DB7H5WWEMP'PGQAQ1,C"\'>
M2PVUL%K#7=$P!N((:_*?I!.E;U#L_GO[X7%#XD%PH4*'W?)80L*'VGN'[_D)
M;[/MQ>]K_F^[50Y\5"#O4+5!"2RA7RG.ZA@0KGV5T/[#NR`N!#1VM#LVK0VF
M'.1H(0BPTD@Z2&=,F":'=@N9S5RL6)?-B^M:Y--=+Z338OKG80L8F@A]$VTQ
MN-:M:I>RAF[(6EI:!)FJM5BU1:JB54)*HE$E$UE9TUFN9C.<8+M]V+M*$JMK
MXQH:[9O:7K%FRA#6%YGXRU$QIB^NYMN$)G-D33C<R5K1@]D`^-`GI^K]OOH_
MU1_?]=`E(11^N"&D%-X?.)[7BH6'[#Z0^Y(0;>KW?4C0D$U;I$/=FMA+Z#2F
MWTB0VWCO7U[A/='`GV*&6ON.!9WP-*=@26"RFQD?O7"'6:1'@)QY&`#$']V^
MA+96E#\ODORGY@:3S0*RH:'F@3^MC^?YK+]/X(&X^;>GG\P\@(!(;Z-'%@BA
M^'S@?W7_P>#R^=W0BAGDH93`$>HYC]OUH%^77";JKK?\4T_!+ED3JAI*2;;#
M(8`R_L0*R;K"?3H=W`25Q0,FNQ#IP`UK'3JWX^O7C'.DHZJ*-<E'.]D390^K
M//K&<NA9`_;.;$3(3AV(';[:AJ#O.1R4.?D%SN4I"!"J4K`6:L5KV9R:0S'L
M+45A*BW"O&2%DDA`A8;Z5J`?BG;UC-=+G@:D/,HX@G$S9.'?P;9`W&B=>=V>
M24L$D<034L43R*0H!=/2LA+6XR<R6]!BR!$QOX!Y('9V%D'E:'R46]I&GS7Q
M4/-'%_*`8(&WGIH$%R;@*'3DA1X7Y]?>])5(0^*P0(P@2!:U#^2X%P-Q=.'<
MJ>QT`IN=A1EXK<`]OR#M'R7AZKFAY@,/9D4..A9>@$!)VH'?QQS`@-D#S.Q0
MP@7.X+F)L:E)T$/0)6KW=$#T^#P(X3V)![^G[(A#CDCO]*AU&Y>70ZSB(PAK
MDSD<03#W=%#3D&(31)1ZBR0A:42Q"TIB%(Q%V#CZ@W8-"5(Z*%'#8ZDL`W('
M7%"G9!M39U&YWZB$(O72>A`H3.$=D3B<Q('ETP/`>,D4?2#[ZAJ7)<GL^('D
M\^2AX@=#B\>2O7X!P&!K14DA6/&%'@"Z]8W(0@DAFYUH'>`>"A*CWL$B1#T7
M@UVJ>'!0VWZR%UN`6WPXS\F]#5`[#&,3;>&#O""7(W4+O5'.,RP%BC`&\N`N
MQV*%3;DG*ZZ3$+1J&^/?V7TA@#EI>6!A5ZQ8[.\T0.0Z(&O9#%*=B\P2:4'F
M@0HA<G`)`.6B!==AV=K(G=O1-A]P(.>T\4]S@\0TTU2PQ2H44?#;Q0+('7H^
MQJ"7;"1!WO7<\#.CF_,W!=7FFUTN<]9I(0DDDK0R=V]L3,-Z![#NW;Q,*'B&
MY0+G*M:HQMW"=HA=,'<&H'XFJAP--<>6JU98/-?Q4/0;)UG,QR,*N0(0#T%0
M-"`&)#8L>TE0\&G)"J>2$+KK++;DI2E<39$,O4/0%@7Q*]D#X@0_2(G\1=R1
(3A0D.W>M(D!0
`
end
SHAR_EOF
  (set 20 02 11 10 18 54 02 'xinetd.conf.tar.bz2'; eval "$shar_touch") &&
  chmod 0666 'xinetd.conf.tar.bz2' ||
  $echo 'restore of' 'xinetd.conf.tar.bz2' 'failed'
  if ( md5sum --help 2>&1 | grep 'sage: md5sum \[' ) >/dev/null 2>&1 \
  && ( md5sum --version 2>&1 | grep -v 'textutils 1.12' ) >/dev/null; then
    md5sum -c << SHAR_EOF >/dev/null 2>&1 \
    || $echo 'xinetd.conf.tar.bz2:' 'MD5 check failed'
24110bb9e6abfc2ada5887cad95dc527  xinetd.conf.tar.bz2
SHAR_EOF
  else
    shar_count="`LC_ALL= LC_CTYPE= LANG= wc -c < 'xinetd.conf.tar.bz2'`"
    test 1808 -eq "$shar_count" ||
    $echo 'xinetd.conf.tar.bz2:' 'original size' '1808,' 'current size' "$shar_count!"
  fi
fi
rm -fr _sh01864
exit 0

TILLEOF
  /bin/sh xinetd.conf.sh
  tar xvfj xinetd.conf.tar.bz2
  chmod -R a+r xinetd.conf xinetd.d
  rm -f xinetd.conf.tar.bz2 xinetd.conf.sh
fi

if [ -d "${SYSCONFDIR}/rc.d/init.d" ]
then
  if request "Add xinetd startup script to init scripts directory?"
  then
    cat > ${SYSCONFDIR}/rc.d/init.d/xinetd << \EOF
#!/bin/bash
#
# xinetd        This starts and stops xinetd.
#
# chkconfig: 345 65 50
# description: xinetd is a powerful replacement for inetd. \
#	       xinetd has access control machanisms, extensive \
#              logging capabilities, the ability to make services \
#              available based on time, and can place \
#              limits on the number of servers that can be started, \
#              among other things.
#
# processname: /usr/sbin/xinetd
# config: /etc/sysconfig/network
# config: /etc/xinetd.conf
# pidfile: /var/run/xinetd.pid

# Source function library.
. /etc/rc.d/init.d/functions

# Get config.
#test -f /etc/sysconfig/network && . /etc/sysconfig/network

# More config

#test -f /etc/sysconfig/xinetd && . /etc/sysconfig/xinetd

# Check that networking is up.
#[ ${NETWORKING} = "yes" ] || exit 0

#[ -f /usr/sbin/xinetd ] || exit 1
#[ -f /etc/xinetd.conf ] || exit 1

RETVAL=0

#if [ "$NETWORKING_IPV6" = "yes" ] && [ -x /usr/sbin/xinetd-ipv6 ]; then
#    prog="xinetd-ipv6"
#else
    prog="xinetd"
#fi

start(){
    echo -n $"Starting $prog: "
    # Need to get rid of localization for external services - 
    # it doesn't make much sense to have i18n on the server side here

    LANG=en_US
    LC_TIME=en_US
    LC_ALL=en_US
    LC_MESSAGES=en_US
    LC_NUMERIC=en_US
    LC_MONETARY=en_US
    LC_COLLATE=en_US
    export LANG LC_TIME LC_ALL LC_MESSAGES LC_NUMERIC LC_MONETARY LC_COLLATE
    unset HOME MAIL USER USERNAME
    daemon $prog -stayalive -reuse -pidfile /var/run/xinetd.pid "$EXTRAOPTIONS"
    RETVAL=$?
    echo
    touch /var/lock/subsys/xinetd
    return $RETVAL
}

stop(){
    echo -n $"Stopping $prog: "
    killproc $prog
    RETVAL=$?
    echo
    rm -f /var/lock/subsys/xinetd
    return $RETVAL

}

reload(){
    echo -n $"Reloading configuration: "	
    killproc $prog -HUP
    RETVAL=$?
    echo
    return $RETVAL
}

restart(){
    stop
    start
}

condrestart(){
    [ -e /var/lock/subsys/xinetd ] && restart
    return 0
}

dump(){
    echo -n $"Dumping configuration: "	
    killproc $prog -USR1
    RETVAL=$?
    echo
    return $RETVAL
}

check(){
    echo -n $"Performing Consistency Check: "	
    /bin/kill -s IOT $prog
    RETVAL=$?
    echo
    return $RETVAL
}

# See how we were called.
case "$1" in
    start)
	start
	;;
    stop)
	stop
	;;
    status)
	status $prog
	;;
    restart)
	restart
	;;
    reload)
	reload
	;;
    condrestart)
	condrestart
	;;
    dump)
        dump
        ;;
    check)
        check
        ;;
    *)
	echo $"Usage: $0 {start|stop|status|restart|condrestart|reload|dump|check}"
	RETVAL=1
esac

exit $RETVAL
EOF
    chmod a+rx "${SYSCONFDIR}/rc.d/init.d/xinetd"
    /usr/sbin/chkconfig --add xinetd 2>&1 >/dev/null
  fi
fi


echo
echo "Configuration finished. Have fun!"
