#!/bin/sh
# Based on Chuck Wilson's mktemp-1.4-1.sh script

export PKG=wget
export VER=1.9
export REL=1

# find out where the build script is located
tdir=`echo "$0" | sed 's%[\\/][^\\/][^\\/]*$%%'`
test "x$tdir" = "x$0" && tdir=.
scriptdir=`cd $tdir; pwd`
# find src directory.  
# If scriptdir ends in SPECS, then topdir is $scriptdir/.. 
# If scriptdir ends in CYGWIN-PATCHES, then topdir is $scriptdir/../..
# Otherwise, we assume that topdir = scriptdir
topdir1=`echo ${scriptdir} | sed 's%/SPECS$%%'`
topdir2=`echo ${scriptdir} | sed 's%/CYGWIN-PATCHES$%%'`
if [ "x$topdir1" != "x$scriptdir" ] ; then # SPECS
  topdir=`cd ${scriptdir}/..; pwd`
else
  if [ "x$topdir2" != "x$scriptdir" ] ; then # CYGWIN-PATCHES
    topdir=`cd ${scriptdir}/../..; pwd`
  else
    topdir=`cd ${scriptdir}; pwd`
  fi
fi

export FULLPKG=${PKG}-${VER}-${REL}

export src_pkg_url=ftp://ftp.gnu.org/gnu/wget/
export src_orig_pkg_name=${PKG}-${VER}.tar.gz
export src_pkg_name=${FULLPKG}-src.tar.bz2
export src_patch_name=${FULLPKG}.patch
export bin_pkg_name=${FULLPKG}.tar.bz2

export src_orig_pkg=${topdir}/${src_orig_pkg_name}
export src_pkg=${topdir}/${src_pkg_name}
export src_patch=${topdir}/${src_patch_name}
export bin_pkg=${topdir}/${bin_pkg_name}
export srcdir=${topdir}/${PKG}-${VER}
export objdir=${srcdir}/.build
export instdir=${srcdir}/.inst
export srcinstdir=${srcdir}/.sinst
export checkfile=${topdir}/${FULLPKG}.check

export src_docs="${srcdir}/doc/sample.wgetrc ${srcdir}/AUTHORS \
    ${srcdir}/COPYING ${srcdir}/NEWS ${srcdir}/README ${srcdir}/TODO \
    ${srcdir}/PATCHES"
host=i686-pc-cygwin
target=i686-pc-cygwin
prefix=/usr
sysconfdir=/etc
configure_args=--with-ssl

prep() {
  (cd ${topdir} && \
  if [ ! -f ${src_orig_pkg} ] ; then
    wget -O ${src_orig_pkg} ${src_pkg_url}/${src_orig_pkg_name}
  fi && \
  tar xvzf ${src_orig_pkg} && \
  cd ${topdir} && \
  mkdir -p ${objdir} && \
  mkdir -p ${instdir} && \
  mkdir -p ${srcinstdir} && \
  if [ -f ${src_patch} ] ; then \
    patch -p0 --binary < ${src_patch} ; \
    cp ${src_patch} ${srcinstdir}/${src_patch_name} ; \
  fi && \
  )
}

conf() {
  (cd ${objdir} && \
  ${srcdir}/configure \
    --srcdir=${srcdir} --prefix=${prefix} \
    --exec-prefix=${prefix} --sysconfdir=${sysconfdir} \
    --libdir=${prefix}/lib --includedir=${prefix}/include \
    --mandir=${prefix}/share/man --infodir=${prefix}/share/info \
    --libexecdir='${sbindir}' --localstatedir=/var \
    --datadir='${prefix}/share' ${configure_args} )
}

build() {
  (cd ${objdir} && \
  make CFLAGS=-O2 )
}

check() {
  (cd ${objdir} && \
  make check | tee ${checkfile} 2>&1 )
}

clean() {
  (cd ${objdir} && \
  make clean )
}

install() {
  (cd ${objdir} && \
  make install INSTALL=install \
  prefix=${instdir}${prefix} \
  exec_prefix=${instdir}${prefix} \
  bindir=${instdir}${prefix}/bin \
  libdir=${instdir}${prefix}/lib \
  sysconfdir=${instdir}${sysconfdir} \
  infodir=${instdir}${prefix}/share/info \
  mandir=${instdir}${prefix}/share/man \
  includedir=${instdir}${prefix}/include &&
  if [ -f ${instdir}/etc/wgetrc ] ; then \
    rm ${instdir}/etc/wgetrc ; \
  fi && \
  if [ -f ${instdir}${prefix}/share/info/dir ] ; then \
    rm ${instdir}${prefix}/share/info/dir ; \
  fi && \
  if [ ! -d ${instdir}/etc/postinstall ]; then \
    mkdir -p ${instdir}/etc/postinstall ; \
  fi && \
  if [ ! -d ${instdir}${prefix}/share/doc/${PKG}-${VER} ]; then \
    mkdir -p ${instdir}${prefix}/share/doc/${PKG}-${VER} ; \
  fi && \
  echo "Updating files in CYGWIN-PATCHES ..." && \
  for template in ${srcdir}/CYGWIN-PATCHES/*.in ; do \
    editedfile=$(dirname ${template})/$(basename ${template} in)
    echo "converting ${template} to ${editedfile} ..." && \
    sed -e s/@VERSION@/${VER}/g -e s/@REL@/${REL}/g \
      <${template} \
      >${editedfile} \
      ; \
  done && \
  /usr/bin/install -D -m 755 ${srcdir}/CYGWIN-PATCHES/wget-postinstall.sh \
  	${instdir}/etc/postinstall/wget.sh && \
  /usr/bin/install -D -m 644 ${srcdir}/CYGWIN-PATCHES/${PKG}.README \
	${instdir}${prefix}/share/doc/Cygwin/${PKG}-${VER}.README && \
  /usr/bin/install -m 644 ${src_docs} \
	${instdir}${prefix}/share/doc/${PKG}-${VER} )
}

mkpatch() {
  (cd ${srcdir} && \
  tar xvzf ${src_orig_pkg} && \
  mv ${PKG}-${VER} ../${PKG}-${VER}-orig && \
  cd ${topdir} && \
  diff -urN --strip-trailing-cr -x '.build' -x '.inst' -x '.sinst' \
  	-x 'texi2pod.pl' -x '*.orig' \
    ${PKG}-${VER}-orig ${PKG}-${VER} > \
    ${srcinstdir}/${src_patch_name} ; \
  rm -rf ${PKG}-${VER}-orig )
}

strip() {
  (cd ${instdir} && \
  find . -name "*.exe" | xargs strip )
}

pkg() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg} * )
}

spkg() {
  (if [ ! -f ${srcinstdir}/${src_patch_name} ] ; then mkpatch; fi && \
  cp ${src_orig_pkg} ${srcinstdir}/${src_orig_pkg_name} && \
  cp $0 ${srcinstdir}/`basename $0` && \
  cd ${srcinstdir} && \
  tar cvjf ${src_pkg} * )
}

finish() {
  rm -rf ${srcdir}
}

case $1 in
  prep)	prep ; STATUS=$? ;;
  conf)	conf ; STATUS=$? ;;
  build)	build ; STATUS=$? ;;
  check)	check ; STATUS=$? ;;
  clean)	clean ; STATUS=$? ;;
  install)	install ; STATUS=$? ;;
  strip)	strip ; STATUS=$? ;;
  mkpatch) mkpatch ; STATUS=$? ;;
  package)	pkg ; STATUS=$? ;;
  pkg)	pkg ; STATUS=$? ;;
  src-package)	spkg ; STATUS=$? ;;
  spkg)	spkg ; STATUS=$? ;;
  finish) finish ; STATUS=$? ;;
  all) prep && conf && build && install && \
     strip && pkg && spkg && finish ; STATUS=$? ;;
  *) echo -e "Error: bad arguments\nvalid arguments are:" prep, conf, build, \
     check, clean, install, strip, mkpatch, package, pkg, src-package, spkg, \
     finish, all ; exit 1 ;;
esac
exit ${STATUS}
