(* $I1: Unison file synchronizer: src/pixmaps.ml $ *)
(* $I2: Last modified by bcpierce on Sat, 01 May 2004 13:01:26 -0400 $ *)
(* $I3: Copyright 1999-2004 (see COPYING for details) $ *)

let copyAB color = [|
(* width height num_colors chars_per_pixel *)
"    28    14        2            1";
(* colors *)
". c None";
"# c #" ^ color;
(* pixels *)
"............................";
"............................";
"............................";
"......................#.....";
".....................###....";
"......................####..";
"..##########################";
"..##########################";
"......................####..";
".....................###....";
"......................#.....";
"............................";
"............................";
"............................"
|]

let copyBA color = [|
(* width height num_colors chars_per_pixel *)
"    28    14        2            1";
(* colors *)
". c None";
"# c #" ^ color;
(* pixels *)
"............................";
"............................";
"............................";
".....#......................";
"....###.....................";
"..####......................";
"##########################..";
"##########################..";
"..####......................";
"....###.....................";
".....#......................";
"............................";
"............................";
"............................"
|]

let mergeLogo color = [|
(* width height num_colors chars_per_pixel *)
"    28    14        2            1";
(* colors *)
". c None";
"# c #" ^ color;
(* pixels *)
"............................";
"............................";
".........##......##.........";
".........###....###.........";
".........####..####.........";
".........##.####.##.........";
".........##..##..##.........";
".........##......##.........";
".........##......##.........";
".........##......##.........";
".........##......##.........";
".........##......##.........";
"............................";
"............................"
|]

let ignore color = [|
(* width height num_colors chars_per_pixel *)
"    20    14        2            1";
(* colors *)
"  c None";
"* c #" ^ color;
(* pixels *)
"                    ";
"       *****        ";
"      **   **       ";
"      **   **       ";
"           **       ";
"          **        ";
"          **        ";
"         **         ";
"        **          ";
"                    ";
"                    ";
"        **          ";
"        **          ";
"                    "
|]

let success = [|
(* width height num_colors chars_per_pixel *)
"    20    14        2            1";
(* colors *)
"  c None";
"* c #00dd00";
(* pixels *)
"                    "; 
"                    ";
"             ***    ";
"           ******   ";
"          ***** *   ";
"         ****       ";
"   ***   ***        ";
"    *** **          ";
"    ******          ";
"      ***           ";
"       **           ";
"       **           ";
"       *            ";
"                    "
|]

let failure = [|
(* width height num_colors chars_per_pixel *)
"    20    14        2            1";
(* colors *)
"  c None";
"* c #ff0000";
(* pixels *)
"     *        *     "; 
"    ***      **     ";
"     ***    ***     ";
"      **    **      ";
"       **  **       ";
"       *****        ";
"        ****        ";
"        ***         ";
"       *****        ";
"       ** **        ";
"      **   **       ";
"     **    ***      ";
"    ***     **      ";
"   ***              "
|]


(***********************************************************************)
(*        Some alternative arrow shapes (not currently used)...        *)
(***********************************************************************)

let copyAB_asym = [|
(* width height num_colors chars_per_pixel *)
"    28    14        2            1";
(* colors *)
". c None";
"# c #3cf834";
(* pixels *)
"............................";
"............................";
"............................";
".......................#....";
"......................###...";
".......................####.";
"..##########################";
"..##########################";
".........................##.";
".......................####.";
"......................###...";
"............................";
"............................";
"............................"
|]

let copyABblack_asym = [|
(* width height num_colors chars_per_pixel *)
"    28    14        2            1";
(* colors *)
". c None";
"# c #000000";
(* pixels *)
"............................";
"............................";
"............................";
".......................#....";
"......................###...";
".......................####.";
"..##########################";
"..##########################";
".........................##.";
".......................####.";
"......................###...";
"............................";
"............................";
"............................"
|]

let copyBA_asym = [|
(* width height num_colors chars_per_pixel *)
"    28    14        2            1";
(* colors *)
". c None";
"# c #3cf834";
(* pixels *)
"............................";
"............................";
"............................";
".....#......................";
"....###.....................";
"..####......................";
"##########################..";
"##########################..";
"..##........................";
"..####......................";
"....###.....................";
"............................";
"............................";
"............................"
|]

let copyBAblack_asym = [|
(* width height num_colors chars_per_pixel *)
"    28    14        2            1";
(* colors *)
". c None";
"# c #000000";
(* pixels *)
"............................";
"............................";
"............................";
".....#......................";
"....###.....................";
"..####......................";
"##########################..";
"##########################..";
"..##........................";
"..####......................";
"....###.....................";
"............................";
"............................";
"............................"
|]
