#!/bin/sh
# find out where the build script is located
tdir=`echo "$0" | sed 's%[\\/][^\\/][^\\/]*$%%'`
test "x$tdir" = "x$0" && tdir=.
scriptdir=`cd $tdir; pwd`
# find src directory.  
# If scriptdir ends in SPECS, then topdir is $scriptdir/.. 
# If scriptdir ends in CYGWIN-PATCHES, then topdir is $scriptdir/../..
# Otherwise, we assume that topdir = scriptdir
topdir1=`echo ${scriptdir} | sed 's%/SPECS$%%'`
topdir2=`echo ${scriptdir} | sed 's%/CYGWIN-PATCHES$%%'`
if [ "x$topdir1" != "x$scriptdir" ] ; then # SPECS
  topdir=`cd ${scriptdir}/..; pwd`
else
  if [ "x$topdir2" != "x$scriptdir" ] ; then # CYGWIN-PATCHES
    topdir=`cd ${scriptdir}/../..; pwd`
  else
    topdir=`cd ${scriptdir}; pwd`
  fi
fi

tscriptname=`basename $0 .sh`
export PKG=`echo $tscriptname | sed -e 's/\-[^\-]*\-[^\-]*$//'`
export PKG2=libtiff5
export PKG3=libtiff-devel
export VER=`echo $tscriptname | sed -e "s/${PKG}\-//" -e 's/\-[^\-]*$//'`
export REL=`echo $tscriptname | sed -e "s/${PKG}\-${VER}\-//"`
export FULLPKG=${PKG}-${VER}-${REL}
export FULLPKG2=${PKG2}-${VER}-${REL}
export FULLPKG3=${PKG3}-${VER}-${REL}

# determine correct decompression option and tarball filename
if [ -e ${PKG}-${VER}.tar.gz ] ; then
  export opt_decomp=z
  export src_orig_pkg_ext=gz
elif [ -e ${PKG}-${VER}.tar.bz2 ] ; then
  export opt_decomp=j
  export src_orig_pkg_ext=bz2
fi

export src_orig_pkg_name=${PKG}-${VER}.tar.${src_orig_pkg_ext}
export src_orig_pkg_name2=pics-3.6.1.tar.gz
export src_orig_pkg_name3=pics-report-3.6.1.tar.gz
export src_pkg_name=${FULLPKG}-src.tar.bz2
export src_patch_name=${FULLPKG}.patch
export bin_pkg_name=${FULLPKG}.tar.bz2
export bin_pkg_name2=${FULLPKG2}.tar.bz2
export bin_pkg_name3=${FULLPKG3}.tar.bz2

export src_orig_pkg=${topdir}/${src_orig_pkg_name}
export src_orig_pkg2=${topdir}/${src_orig_pkg_name2}
export src_orig_pkg3=${topdir}/${src_orig_pkg_name3}
export src_pkg=${topdir}/${src_pkg_name}
export src_patch=${topdir}/${src_patch_name}
export bin_pkg=${topdir}/${bin_pkg_name}
export bin_pkg2=${topdir}/${bin_pkg_name2}
export bin_pkg3=${topdir}/${bin_pkg_name3}
export srcdir=${topdir}/tiff-${VER}
export objdir=${srcdir}/.build
export instdir=${srcdir}/.inst
export srcinstdir=${srcdir}/.sinst
export checkfile=${topdir}/${FULLPKG}.check
# run on
host=i686-pc-cygwin
# if this package creates binaries, they run on
target=i686-pc-cygwin
prefix=/usr
pnoslash=`echo $prefix | sed -e 's#^/##'`
sysconfdir=${prefix}/etc
snoslash=`echo $sysconfdir | sed -e 's#^/##'`
CFLAGS="-O2"

mkdirs() {
  (cd ${topdir} && \
  rm -fr ${objdir} ${instdir} ${srcinstdir} && \
  mkdir -p ${objdir} && \
  mkdir -p ${instdir} && \
  mkdir -p ${srcinstdir}
)}

prep() {
  (cd ${topdir} && \
  tar xv${opt_decomp}f ${src_orig_pkg} ; \
  cd ${srcdir} && \
  tar xvzf ${src_orig_pkg2} ; \
  tar xvzf ${src_orig_pkg3} ; \
  patch -p1 < ${src_patch} \
  && mkdirs && \
  cd ${srcdir} && \
  chmod +x CYGWIN-PATCHES/shtool && \
  CYGWIN-PATCHES/shtool mkshadow -v pics-3.6.1 ${objdir}/pics-3.6.1
)}

conf() {
  (cd ${objdir} && \
  ${srcdir}/configure \
  --srcdir=${srcdir} --prefix=${prefix} \
  --mandir=${prefix}/share/man
)}

build() {
  (cd ${objdir} && \
  make DESTDIR=${instdir} 
)}

check() {
  (cd ${objdir} && \
  make check | tee ${checkfile} 2>&1
  echo "Old-style tests: " | tee -a ${checkfile} 2>&1
  echo "There should be no output between the two lines below" | tee -a ${checkfile} 2>&1
  echo "------------------------------------------------------" | tee -a ${checkfile} 2>&1
  ${srcdir}/test_pics.sh pics-3.6.1/*.tif | tee -a ${checkfile} 2>&1
  echo "------------------------------------------------------" | tee -a ${checkfile} 2>&1
)}

clean() {
  (cd ${objdir} && \
  make clean
)}

install() {
  (cd ${objdir} && \
  make install DESTDIR=${instdir} && \
  if [ -f ${instdir}${prefix}/share/info/dir ] ; then \
    rm ${instdir}${prefix}/share/info/dir ; \
  fi && \
  for dirn in ${prefix}/share/doc/${PKG}-${VER} \
    ${prefix}/share/doc/${PKG3}-${VER} \
    ${prefix}/share/doc/Cygwin ; do \
    mkdir -p ${instdir}${dirn} ; \
  done && \
  templist=""; \
  for f in ${srcdir}/COPYRIGHT ${srcdir}/README ${srcdir}/RELEASE-DATE \
           ${srcdir}/TODO ${srcdir}/VERSION ${srcdir}/ChangeLog ; do \
    if [ -f $f ] ; then \
      templist="$templist $f"; \
    fi ; \
  done && \
  if [ ! "x$templist" = "x" ]; then \
    /usr/bin/install -m 644 $templist \
         ${instdir}${prefix}/share/doc/${PKG}-${VER} ;
    /usr/bin/install -m 644 $templist \
         ${instdir}${prefix}/share/doc/${PKG3}-${VER} ;
  fi && \
  (cd ${srcdir}; 
  templist=`find html -type f | grep -E -e "\.html|\.gif|\.jpg$"`
  tar cvf ${objdir}/html.tar $templist
  cd ${instdir}${prefix}/share/doc/${PKG}-${VER} ;
  tar xvf ${objdir}/html.tar) &&
  cat ${srcdir}/CYGWIN-PATCHES/${PKG}.frag \
    ${srcdir}/CYGWIN-PATCHES/README.frag > \
    ${instdir}${prefix}/share/doc/Cygwin/${PKG}-${VER}.README && \
  cat ${srcdir}/CYGWIN-PATCHES/${PKG3}.frag \
    ${srcdir}/CYGWIN-PATCHES/README.frag > \
    ${instdir}${prefix}/share/doc/Cygwin/${PKG3}-${VER}.README
)}

strip() {
  (cd ${instdir} && \
  find . -name "*.exe" | xargs strip >/dev/null 2>&1
  find . -name "*.dll" | xargs strip >/dev/null 2>&1
)}

mkpatch_setup() {
  (cd ${srcdir} && \
  tar xv${opt_decomp}f ${src_orig_pkg} ; \
  mv ${PKG}-${VER} ../${PKG}-${VER}-orig && \
  cd ../${PKG}-${VER}-orig && \
  tar xvzf ${src_orig_pkg2} && \
  tar xvzf ${src_orig_pkg3}
)}

mkpatch() {
  (mkpatch_setup && \
  cd ${topdir} && \
  diff -urN -x '.build' -x '.inst' -x '.sinst' \
    ${PKG}-${VER}-orig/ ${PKG}-${VER}/ > \
    ${srcinstdir}/${src_patch_name} ; \
  rm -rf ${PKG}-${VER}-orig
)}

pkg() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg} \
    ${pnoslash}/bin/*.exe \
    ${pnoslash}/share/man/man1/* \
    ${pnoslash}/share/doc/Cygwin/${PKG}-${VER}.README \
    ${pnoslash}/share/doc/tiff-${VER}/* 
  tar cvjf ${bin_pkg2} ${pnoslash}/bin/*.dll
  tar cvjf ${bin_pkg3} \
    ${pnoslash}/lib/* \
    ${pnoslash}/include/* \
    ${pnoslash}/share/man/man3/* \
    ${pnoslash}/share/doc/Cygwin/${PKG3}-${VER}.README \
    ${pnoslash}/share/doc/${PKG3}-${VER}/* 
)}

spkg() {
  (mkpatch && \
  cp ${src_orig_pkg} ${srcinstdir}/${src_orig_pkg_name} && \
  cp ${src_orig_pkg2} ${srcinstdir}/${src_orig_pkg_name2} && \
  cp ${src_orig_pkg3} ${srcinstdir}/${src_orig_pkg_name3} && \
  cp $0 ${srcinstdir}/`basename $0` && \
  cd ${srcinstdir} && \
  tar cvjf ${src_pkg} *
)}

finish() {
  rm -rf ${srcdir} 
}

case $1 in
  mkdirs) mkdirs ; STATUS=$? ;;
  prep)	prep ; STATUS=$? ;;
  conf)	conf ; STATUS=$? ;;
  build)	build ; STATUS=$? ;;
  check)	check ; STATUS=$? ;;
  clean)	clean ; STATUS=$? ;;
  install)	install ; STATUS=$? ;;
  strip)	strip ; STATUS=$? ;;
  mkpatch)	mkpatch ; STATUS=$? ;;
  package)	pkg ; STATUS=$? ;;
  pkg)	pkg ; STATUS=$? ;;
  src-package)	spkg ; STATUS=$? ;;
  spkg)	spkg ; STATUS=$? ;;
  finish) finish ; STATUS=$? ;;
  all) prep && conf && build && install && \
     strip && pkg && spkg && finish ; \
	  STATUS=$? ;;
  *) echo "Error: bad arguments" ; exit 1 ;;
esac
exit ${STATUS}
