--
--	PostgreSQL code for ISSNs.
--
--	$Id: isbn_issn.sql.in,v 1.9 2003/06/28 00:36:40 momjian Exp $
--

-- Adjust this setting to control where the objects get created.
SET search_path = public;

--
--	Input and output functions and the type itself:
--

CREATE FUNCTION issn_in(cstring)
RETURNS issn
AS '$libdir/isbn_issn'
LANGUAGE 'C';

CREATE FUNCTION issn_out(issn)
RETURNS cstring
AS '$libdir/isbn_issn'
LANGUAGE 'C';

CREATE TYPE issn (
	INTERNALLENGTH = 16,
	EXTERNALLENGTH = 9,
	INPUT = issn_in,
	OUTPUT = issn_out
);

COMMENT ON TYPE issn
  is 'International Standard Serial Number';


--
--	The various boolean tests:
--

CREATE FUNCTION issn_lt(issn, issn)
RETURNS bool
AS '$libdir/isbn_issn'
LANGUAGE 'C';

CREATE FUNCTION issn_le(issn, issn)
RETURNS bool
AS '$libdir/isbn_issn'
LANGUAGE 'C';

CREATE FUNCTION issn_eq(issn, issn)
RETURNS bool
AS '$libdir/isbn_issn'
LANGUAGE 'C';

CREATE FUNCTION issn_ge(issn, issn)
RETURNS bool
AS '$libdir/isbn_issn'
LANGUAGE 'C';

CREATE FUNCTION issn_gt(issn, issn)
RETURNS bool
AS '$libdir/isbn_issn'
LANGUAGE 'C';

CREATE FUNCTION issn_ne(issn, issn)
RETURNS bool
AS '$libdir/isbn_issn'
LANGUAGE 'C';

--
--	Now the operators.  Note how some of the parameters to some
--	of the 'create operator' commands are commented out.  This
--	is because they reference as yet undefined operators, and
--	will be implicitly defined when those are, further down.
--

CREATE OPERATOR < (
	LEFTARG = issn,
	RIGHTARG = issn,
--	NEGATOR = >=,
	PROCEDURE = issn_lt
);

CREATE OPERATOR <= (
	LEFTARG = issn,
	RIGHTARG = issn,
--	NEGATOR = >,
	PROCEDURE = issn_le
);

CREATE OPERATOR = (
	LEFTARG = issn,
	RIGHTARG = issn,
	COMMUTATOR = =,
--	NEGATOR = <>,
	PROCEDURE = issn_eq
);

CREATE OPERATOR >= (
	LEFTARG = issn,
	RIGHTARG = issn,
	NEGATOR = <,
	PROCEDURE = issn_ge
);

CREATE OPERATOR > (
	LEFTARG = issn,
	RIGHTARG = issn,
	NEGATOR = <=,
	PROCEDURE = issn_gt
);

CREATE OPERATOR <> (
	LEFTARG = issn,
	RIGHTARG = issn,
	NEGATOR = =,
	PROCEDURE = issn_ne
);

-- Register 'issn' comparison function
CREATE FUNCTION issn_cmp(issn, issn)
RETURNS integer
AS '$libdir/isbn_issn'
LANGUAGE c;

-- Create default operator class for 'issn'    --
-- Needed to create index or primary key       --

CREATE OPERATOR CLASS issn_ops
DEFAULT FOR TYPE issn USING btree 
AS
        OPERATOR        1       < ,
        OPERATOR        2       <= ,
        OPERATOR        3       = ,
        OPERATOR        4       >= ,
        OPERATOR        5       > ,
        FUNCTION        1       issn_cmp(issn, issn);


------------------------------------------------------------------------

--
--	Same code for ISBN
--
--	Input and output functions and the type itself:
--

CREATE FUNCTION isbn_in(cstring)
RETURNS isbn
AS '$libdir/isbn_issn'
LANGUAGE 'C';

CREATE FUNCTION isbn_out(isbn)
RETURNS cstring
AS '$libdir/isbn_issn'
LANGUAGE 'C';

CREATE TYPE isbn (
	INTERNALLENGTH = 16,
	EXTERNALLENGTH = 13,
	INPUT = isbn_in,
	OUTPUT = isbn_out
);

COMMENT ON TYPE isbn IS 'International Standard Book Number';


--
--	The various boolean tests:
--

CREATE FUNCTION isbn_lt(isbn, isbn)
RETURNS bool
AS '$libdir/isbn_issn'
LANGUAGE 'C';

CREATE FUNCTION isbn_le(isbn, isbn)
RETURNS bool
AS '$libdir/isbn_issn'
LANGUAGE 'C';

CREATE FUNCTION isbn_eq(isbn, isbn)
RETURNS bool
AS '$libdir/isbn_issn'
LANGUAGE 'C';

CREATE FUNCTION isbn_ge(isbn, isbn)
RETURNS bool
AS '$libdir/isbn_issn'
LANGUAGE 'C';

CREATE FUNCTION isbn_gt(isbn, isbn)
RETURNS bool
AS '$libdir/isbn_issn'
LANGUAGE 'C';

CREATE FUNCTION isbn_ne(isbn, isbn)
RETURNS bool
AS '$libdir/isbn_issn'
LANGUAGE 'C';

--
--	Now the operators.  Note how some of the parameters to some
--	of the 'create operator' commands are commented out.  This
--	is because they reference as yet undefined operators, and
--	will be implicitly defined when those are, further down.
--

CREATE OPERATOR < (
	LEFTARG = isbn,
	RIGHTARG = isbn,
--	NEGATOR = >=,
	PROCEDURE = isbn_lt
);

CREATE OPERATOR <= (
	LEFTARG = isbn,
	RIGHTARG = isbn,
--	NEGATOR = >,
	PROCEDURE = isbn_le
);

CREATE OPERATOR = (
	LEFTARG = isbn,
	RIGHTARG = isbn,
	COMMUTATOR = =,
--	NEGATOR = <>,
	PROCEDURE = isbn_eq
);

CREATE OPERATOR >= (
	LEFTARG = isbn,
	RIGHTARG = isbn,
	NEGATOR = <,
	PROCEDURE = isbn_ge
);

CREATE OPERATOR > (
	LEFTARG = isbn,
	RIGHTARG = isbn,
	NEGATOR = <=,
	PROCEDURE = isbn_gt
);

CREATE OPERATOR <> (
	LEFTARG = isbn,
	RIGHTARG = isbn,
	NEGATOR = =,
	PROCEDURE = isbn_ne
);


-- Register 'isbn' comparison function
CREATE FUNCTION isbn_cmp(isbn, isbn)
RETURNS integer
AS '$libdir/isbn_issn'
LANGUAGE c;

-- Create default operator class for 'isbn'    --
-- Needed to create index or primary key       --

CREATE OPERATOR CLASS isbn_ops
DEFAULT FOR TYPE isbn USING btree 
AS
        OPERATOR        1       < ,
        OPERATOR        2       <= ,
        OPERATOR        3       = ,
        OPERATOR        4       >= ,
        OPERATOR        5       > ,
        FUNCTION        1       isbn_cmp(isbn, isbn);
