/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.postgresql.PGConnection;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;

public class threadsafe {
    Connection db;
    Statement st;

    public threadsafe(String[] args) throws ClassNotFoundException, FileNotFoundException, IOException, SQLException {
        String url = args[0];
        String usr = args[1];
        String pwd = args[2];
        Class.forName("org.postgresql.Driver");
        System.out.println("Connecting to Database URL = " + url);
        this.db = DriverManager.getConnection(url, usr, pwd);
        System.out.println("Connected...Now creating a statement");
        this.st = this.db.createStatement();
        this.cleanup();
        this.db.setAutoCommit(false);
        this.doexample();
        this.cleanup();
        System.out.println("Now closing the connection");
        this.st.close();
        this.db.close();
    }

    public void cleanup() {
        try {
            this.st.executeUpdate("drop table basic1");
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.st.executeUpdate("drop table basic2");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doexample() throws SQLException {
        block5: {
            System.out.println("\nThis test runs three Threads. Two simply insert data into a table, then\nthey perform a query. While they are running, a third thread is running,\nand it load data into, then reads from a Large Object.\n\nIf alls well, this should run without any errors. If so, we are Thread Safe.\nWhy test JDBC & LargeObject's? Because both will run over the network\nconnection, and if locking on the stream isn't done correctly, the backend\nwill get pretty confused!\n");
            thread3 thread32 = null;
            try {
                Thread thread0 = Thread.currentThread();
                thread1 thread12 = new thread1(this.db);
                thread2 thread22 = new thread2(this.db);
                thread32 = new thread3(this.db);
                thread12.start();
                thread22.start();
                thread32.start();
                System.out.println("Waiting for threads to run");
                while (true) {
                    if (!(thread12.isAlive() || thread22.isAlive() || thread32.isAlive())) {
                        Object var6_5 = null;
                        if (thread32 == null) break block5;
                        break;
                    }
                    Thread.yield();
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (thread32 != null) {
                    thread32.cleanup();
                }
                throw throwable;
            }
            thread32.cleanup();
        }
        System.out.println("No Exceptions have been thrown. This is a good omen, as it means that we are\npretty much thread safe as we can get.");
    }

    public static void instructions() {
        System.out.println("\nThis tests the thread safety of the driver.\n\nThis is done in two parts, the first with standard JDBC calls, and the\nsecond mixing FastPath and LargeObject calls with queries.\n");
        System.out.println("Useage:\n java example.threadsafe jdbc:postgresql:database user password [debug]\n\nThe debug field can be anything. It's presence will enable DriverManager's\ndebug trace. Unless you want to see screens of items, don't put anything in\nhere.");
        System.exit(1);
    }

    public static void main(String[] args) {
        System.out.println("PostgreSQL Thread Safety test v6.4 rev 1\n");
        if (args.length < 3) {
            threadsafe.instructions();
        }
        if (args.length > 3) {
            DriverManager.setLogStream(System.err);
        }
        try {
            threadsafe test = new threadsafe(args);
        }
        catch (Exception ex) {
            System.err.println("Exception caught.\n" + ex);
            ex.printStackTrace();
        }
    }

    class thread3
    extends Thread {
        Connection c;
        Statement st;
        LargeObjectManager lom;
        LargeObject lo;
        int oid;

        public thread3(Connection c) throws SQLException {
            this.c = c;
            this.lom = ((PGConnection)c).getLargeObjectAPI();
            this.oid = this.lom.create();
            System.out.println("Thread 3 has created a blob of oid " + this.oid);
        }

        /*
         * WARNING - void declaration
         */
        public void run() {
            try {
                int rc;
                System.out.println("Thread 3 running...");
                DriverManager.println("Thread 3: Loading data into blob " + this.oid);
                this.lo = this.lom.open(this.oid);
                FileInputStream fis = new FileInputStream("example/threadsafe.java");
                byte[] buf = new byte[128];
                int bc = 1;
                int bs = 0;
                while ((rc = fis.read(buf)) > 0) {
                    void var3_6;
                    DriverManager.println("Thread 3 read block " + bc + " " + bs + " bytes");
                    this.lo.write(buf, 0, (int)var3_6);
                    ++bc;
                    bs += var3_6;
                }
                this.lo.close();
                fis.close();
                DriverManager.println("Thread 3: Reading blob " + this.oid);
                this.lo = this.lom.open(this.oid);
                bc = 0;
                while (buf.length > 0) {
                    if ((buf = this.lo.read(buf.length)).length <= 0) continue;
                    String s = new String(buf);
                    DriverManager.println("Thread 3 block " + ++bc);
                    DriverManager.println("Block " + bc + " got " + s);
                }
                this.lo.close();
                System.out.println("Thread 3 finished");
            }
            catch (Exception se) {
                System.err.println("Thread 3: " + se.toString());
                se.printStackTrace();
                System.exit(1);
            }
        }

        public void cleanup() throws SQLException {
            if (this.lom != null && this.oid != 0) {
                System.out.println("Thread 3: Removing blob oid=" + this.oid);
                this.lom.delete(this.oid);
            }
        }
    }

    class thread2
    extends Thread {
        Connection c;
        Statement st;

        public thread2(Connection c) throws SQLException {
            this.c = c;
            this.st = c.createStatement();
        }

        public void run() {
            try {
                System.out.println("Thread 2 running...");
                this.st.executeUpdate("create table basic2 (a int2, b int2)");
                PreparedStatement ps = threadsafe.this.db.prepareStatement("insert into basic2 values (?,?)");
                int i = 2;
                while (i < 2000) {
                    ps.setInt(1, 4);
                    ps.setInt(2, i);
                    ps.executeUpdate();
                    if (i % 50 == 0) {
                        DriverManager.println("Thread 2 done " + i + " inserts");
                    }
                    ++i;
                }
                ps.close();
                DriverManager.println("Thread 2 performing a query");
                ResultSet rs = this.st.executeQuery("select * from basic2 where b>1");
                int cnt = 0;
                if (rs != null) {
                    int col_a = rs.findColumn("a");
                    int col_b = rs.findColumn("b");
                    while (rs.next()) {
                        int a = rs.getInt(col_a);
                        int b = rs.getInt(col_b);
                        ++cnt;
                    }
                    rs.close();
                }
                DriverManager.println("Thread 2 read " + cnt + " rows");
                System.out.println("Thread 2 finished");
            }
            catch (SQLException se) {
                System.err.println("Thread 2: " + se.toString());
                se.printStackTrace();
                System.exit(1);
            }
        }
    }

    class thread1
    extends Thread {
        Connection c;
        Statement st;

        public thread1(Connection c) throws SQLException {
            this.c = c;
            this.st = c.createStatement();
        }

        public void run() {
            try {
                System.out.println("Thread 1 running...");
                this.st.executeUpdate("create table basic1 (a int2, b int2)");
                this.st.executeUpdate("insert into basic1 values (1,1)");
                this.st.executeUpdate("insert into basic1 values (2,1)");
                this.st.executeUpdate("insert into basic1 values (3,1)");
                PreparedStatement ps = threadsafe.this.db.prepareStatement("insert into basic1 values (?,?)");
                int i = 2;
                while (i < 2000) {
                    ps.setInt(1, 4);
                    ps.setInt(2, i);
                    ps.executeUpdate();
                    if (i % 50 == 0) {
                        DriverManager.println("Thread 1 done " + i + " inserts");
                    }
                    ++i;
                }
                ps.close();
                DriverManager.println("Thread 1 performing a query");
                ResultSet rs = this.st.executeQuery("select a, b from basic1");
                int cnt = 0;
                if (rs != null) {
                    while (rs.next()) {
                        int a = rs.getInt("a");
                        int b = rs.getInt(2);
                        ++cnt;
                    }
                    rs.close();
                }
                DriverManager.println("Thread 1 read " + cnt + " rows");
                System.out.println("Thread 1 finished");
            }
            catch (SQLException se) {
                System.err.println("Thread 1: " + se.toString());
                se.printStackTrace();
                System.exit(1);
            }
        }
    }
}

