.\"

.\" GLE Tubing & Extrusions Library Documentation 

.\"

.TH glePolyCone 3GLE "3.6" "GLE" "GLE"

.SH NAME

glePolyCone - Draw polycone, specified as a polyline with radii.

.SH SYNTAX

.nf

.LP

void glePolyCone(int npoints,

                 gleDouble point_array[][3],

                 float color_array[][3],

                 gleDouble radius_array[]);

.fi

.SH ARGUMENTS

.IP \fInpoints\fP 1i

numpoints in poly-line

.IP \fIpoint_array\fP 1i

polyline vertices

.IP \fIcolor_array\fP 1i

colors at polyline verts

.IP \fIradius_array\fP 1i

cone radii at polyline

.SH DESCRIPTION



Draw polycone, specified as a polyline with radii.



Note that neither the very first segment, nor the very last segment are

drawn. The first and last segments serve only to define the angle of

the join at the very ends of the polyline. Thus, to draw one segment,

three must be specified. To draw two segments, four must be specified,

etc.



The color array may be NULL. If NULL, the current color is used. If not

NULL, the glColor3f() routine is used to set the color; therefore,

specifying the glColorMaterial() subroutine before this primitive can

be used to set diffuse, specular, ambient, etc. colors.



.SH SEE ALSO

glePolyCylinder

.SH AUTHOR

Linas Vepstas (linas@fc.net)

