.\"

.\" GLE Tubing & Extrusions Library Documentation 

.\"

.TH gle 3GLE "3.6" "GLE" "GLE"

.SH NAME

gle - an introduction to the GLE Tubing & Extrusions Library

.SH SYNOPSIS

.nf

.LP

#include <GL/tube.h>

.fi

.SH DESCRIPTION

The GLE Tubing and Extrusion Library is a graphics application

programming interface (API). The library consists of a number of "C"

language subroutines for drawing tubing and extrusions. The library is

distributed in source code form, in a package that includes

documentation, a VRML proposal, Makefiles, and full source code and

header files. It uses the OpenGL (TM) programming API to perform the

actual drawing of the tubing and extrusions.



A "sweep" or "extrusion" is a 2D contour (polyline) that is swept or

extruded along a 3D path (polyline). For example, sweeping a circle

along a straight line will generate a cylinder.  Sweeping a circle

along a circular path will generate a doughnut (torus).



The library also includes a set of utility routines for drawing some of

the more common extruded shapes: a polycylinder, a polycone, a

generalized torus (circle swept along a helical path), a "helix"

(arbitrary contour swept along a helical path) and a "lathe" (arbitrary

contour swept along a helical path, with torsion used to keep the

contour aligned).



The most general extrusion supported by this library allows an

arbitrary 2D contour to be swept around an arbitrary 3D path. A set of

normal vectors can be specified to go along with the contour; the

normal vectors determine the appearance of the contour when lighting is

turned on. A set of colors and affine matrices can be specified to go

along with the 3D path.  The colors are used to color along the path.

The affine matrices are used to operate on the contour as it is swept

along. If no affine matrices are specified, the contour is extruded

using the mathematical concept of "parallel translation" or "Gaussian

translation". That is, the contour is moved (and drawn) along the

extrusion path in a "straight" manner. If there are affine matrices,

they are applied to the contour at each extrusion segment before the

segment is drawn.



The affine matrices allow work in a quasi-non-Euclidean space. They

essentially allow the contour to be distorted as it is swept along. The

allow the contour to be rotated, translated and rescaled as it is

drawn. For example, a rescaling will turn a polycylinder into a

poly-cone, since the circle that is being extruded is scaled to a

different size at each extrusion vertex. A rotation allows the contour

to be spun around while it is being extruded, thus for instance

allowing drill-bit type shapes to be drawn. A translation allows the

appearance of shearing in real space; that is, taking a contour and

displacing it, without otherwise bending it. Note that the affines are

2x3 matrices, not 3x4 matrices, since they apply to the 2D contour as

it is being extruded.

.SH WEB SITE

http://linas.org/gle/index.html

.SH SEE ALSO

gleExtrusion, gleHelicoid, gleLathe, glePolyCone, glePolyCylinder,

gleScrew, gleSetJoinStyle, gleSpiral, gleSuperExtrusion, gleTextureMode,

gleToroid, gleTwistExtrusion, gleTwistExtrusion, gleSuperExtrusion

.SH AUTHOR

Linas Vepstas (linas@fc.net)

