/* To exercise the program */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <netinet/in.h>
#include <netdb.h>
#include <resolv.h>

int main(int argc, char * argv[])
{
  char pack[PACKETSZ];
  int i;
  char * host;
  int type;

  if (argc > 2) {
    host = argv[1];
    type = atoi(argv[2]);
  }
  else {
    host = "mit.edu";
    type = T_MX;   /* T_A */
    fprintf(stderr, "Usage: %s host type\n", argv[0]);
    fprintf(stderr, "Using host = %s, type = %d\n", host, type);
    fprintf(stderr, " also testing behavior after a fork\n");
  }
  
  _res.options |= RES_DEBUG;
  res_init();

  fprintf(stderr, "%d _res.options %lx\n", 
	  getpid(), _res.options);
  for (i = 0; i < PACKETSZ; i++) pack[i] = 'X';
 
  i = res_search(host, C_IN, type , pack, sizeof(pack)); 
  fprintf(stderr, "res = %d, h_errno: %d\n", i, h_errno);
  fflush(stderr);

  if (argc <= 2) { /* Check behavior under fork */
    if (fork() == 0) {
      fprintf(stderr, "%d _res.options %lx\n", 
  	      getpid(), _res.options);
      res_query(host, C_IN, type , pack, sizeof(pack)); 
      fprintf(stderr, "h_errno: %d\n", h_errno);
      fflush(stderr);
      _exit(0);
    }
    sleep(5);
  }
#if 0
  /* Change the 0 above to print the packet on stdout */ 
  for (i = 0; i < PACKETSZ; i++)
    fputc(pack[i], stdout);
#endif
  exit(0);
}

