#!/bin/bash
# find out where the build script is located
tdir=`echo "$0" | sed 's%[\\/][^\\/][^\\/]*$%%'`
test "x$tdir" = "x$0" && tdir=.
scriptdir=`cd $tdir; pwd`
# find src directory.  
# If scriptdir ends in SPECS, then topdir is $scriptdir/.. 
# If scriptdir ends in CYGWIN-PATCHES, then topdir is $scriptdir/../..
# Otherwise, we assume that topdir = scriptdir
topdir1=`echo ${scriptdir} | sed 's%/SPECS$%%'`
topdir2=`echo ${scriptdir} | sed 's%/CYGWIN-PATCHES$%%'`
if [ "x$topdir1" != "x$scriptdir" ] ; then # SPECS
  topdir=`cd ${scriptdir}/..; pwd`
else
  if [ "x$topdir2" != "x$scriptdir" ] ; then # CYGWIN-PATCHES
    topdir=`cd ${scriptdir}/../..; pwd`
  else
    topdir=`cd ${scriptdir}; pwd`
  fi
fi

tscriptname=`basename $0 .sh`
export PKG=`echo $tscriptname | sed -e 's/\-[^\-]*\-[^\-]*$//'`
export VER=`echo $tscriptname | sed -e "s/^${PKG}-//" -e 's/\-[^\-]*$//'`
export REL=`echo $tscriptname | sed -e "s/^${PKG}-${VER}-//"`
export FULLPKG=${PKG}-${VER}-${REL}
BASEPKG=`echo $PKG | sed -e 's/mingw-//'`

# determine correct decompression option and tarball filename
if [ -e ${BASEPKG}-${VER}.tar.gz ] ; then
  export opt_decomp=z
  export src_orig_pkg_ext=gz
elif [ -e ${BASEPKG}-${VER}.tar.bz2 ] ; then
  export opt_decomp=j
  export src_orig_pkg_ext=bz2
fi

export src_orig_pkg_name=${BASEPKG}-${VER}.tar.${src_orig_pkg_ext}
export src_pkg_name=${FULLPKG}-src.tar.bz2
export src_patch_name=${FULLPKG}.patch
export bin_pkg_name=${FULLPKG}.tar.bz2

export src_orig_pkg=${topdir}/${src_orig_pkg_name}
export src_pkg=${topdir}/${src_pkg_name}
export src_patch=${topdir}/${src_patch_name}
export bin_pkg=${topdir}/${bin_pkg_name}
export srcdir=${topdir}/${BASEPKG}-${VER}
export objdir=${srcdir}/.build
export instdir=${srcdir}/.inst
export srcinstdir=${srcdir}/.sinst
export checkfile=${topdir}/${FULLPKG}.check
# run on
host=i686-pc-cygwin
# if this package creates binaries, they run on
target=i686-pc-mingw32
prefix=/usr
sysconfdir=/etc
pnoslash=`echo $prefix | sed -e 's#^/##'`
snoslash=`echo $sysconfdir | sed -e 's#^/##'`
MY_CC=${objdir}/mgcc
MY_CFLAGS="-O2"
MY_LDFLAGS="-L/usr/lib/mingw"

mkdirs() {
  (cd ${topdir} && \
  rm -rf ${objdir} ${instdir} ${srcinstdir} && \
  mkdir -p ${objdir} && \
  mkdir -p ${instdir} && \
  mkdir -p ${srcinstdir}
)}

mktools() {
  cat >${objdir}/mgcc <<EOF
#!/bin/sh
gcc -mno-cygwin \$*
EOF
  chmod +x ${objdir}/mgcc
}

prep() {
  (cd ${topdir} && \
  tar xv${opt_decomp}f ${src_orig_pkg} && \
  cd ${srcdir} && \
  patch -p1 < ${src_patch} 
  chmod +x ${srcdir}/CYGWIN-PATCHES/shtool && \
  mkdirs && \
  CYGWIN-PATCHES/shtool mkshadow -v . .build
  cd ${objdir} && \
  rm -f Makefile zconf.h
  mktools
)}

conf() {
  (cd ${objdir} && \
  CC="${MY_CC}" CFLAGS="${MY_CFLAGS}" LDFLAGS="${MY_LDFLAGS}" \
  target="${target}" ${srcdir}/configure \
    --prefix=${prefix} --exec_prefix=${prefix} \
    --libdir=${prefix}/lib/mingw --includedir=${prefix}/include/mingw
)}

build() {
  (cd ${objdir} && \
   CC="${MY_CC}" CFLAGS="${MY_CFLAGS}" LDFLAGS="${MY_LDFLAGS}" make
)}

check() {
  (cd ${objdir} && \
  make test | tee ${checkfile} 2>&1
)}

clean() {
  (cd ${objdir} && \
  make clean
)}

install-mingw-cleanup() {
  (cd ${objdir}
  delfiles="${prefix}/share/man/man3/zlib.3"
  deldirs="${prefix}/share/man/man3 usr/share/man"
  for f in $delfiles ; do \
    if [ -f ${instdir}/$f ] ; then \
      rm -f ${instdir}/$f ;\
    fi ;\
  done &&\
  for d in $deldirs; do \
    if [ -d ${instdir}/$d ] ; then \
      rmdir ${instdir}/$d ;\
    fi ;\
  done
)}

install() {
  (cd ${objdir} && \
  make install DESTDIR=${instdir} && \
  if [ -f ${instdir}${prefix}/share/info/dir ] ; then \
    rm ${instdir}${prefix}/share/info/dir ; \
  fi && \
  if [ ! -d ${instdir}${prefix}/share/doc/${PKG}-${VER} ]; then \
    mkdir -p ${instdir}${prefix}/share/doc/${PKG}-${VER} ; \
  fi && \
  if [ ! -d ${instdir}${prefix}/share/doc/Cygwin ]; then \
    mkdir -p ${instdir}${prefix}/share/doc/Cygwin ; \
  fi && \
  templist=""; \
  for f in ${srcdir}/README ${srcdir}/FAQ ; do \
    if [ -f $f ] ; then \
      templist="$templist $f"; \
    fi ; \
  done && \
  if [ ! "x$templist" = "x" ]; then \
    /usr/bin/install -m 644 $templist \
         ${instdir}${prefix}/share/doc/${PKG}-${VER} ;
  fi && \
  /usr/bin/install -m 644 ${srcdir}/CYGWIN-PATCHES/${PKG}.README \
    ${instdir}${prefix}/share/doc/Cygwin/${PKG}-${VER}.README ; \
  install-mingw-cleanup
)}

strip() {
  (cd ${instdir} && \
  find . -name "*.dll" | xargs strip >/dev/null 2>&1
  find . -name "*.exe" | xargs strip >/dev/null 2>&1
  /bin/true
)}

pkg() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg} *
)}

mkpatch() {
  (cd ${srcdir} && \
  tar xv${opt_decomp}f ${src_orig_pkg} && \
  mv ${BASEPKG}-${VER} ../${BASEPKG}-${VER}-orig && \
  cd ${topdir} && \
  diff -urN -x '.build' -x '.inst' -x '.sinst' \
    ${BASEPKG}-${VER}-orig ${BASEPKG}-${VER} > \
    ${srcinstdir}/${src_patch_name} ; \
  rm -rf ${BASEPKG}-${VER}-orig
)}

spkg() {
  (mkpatch && \
  cp ${src_orig_pkg} ${srcinstdir}/${src_orig_pkg_name} && \
  cp $0 ${srcinstdir}/`basename $0` && \
  cd ${srcinstdir} && \
  tar cvjf ${src_pkg} *
)}

finish() {
  rm -rf ${srcdir} 
}
case $1 in
  prep)	prep ; STATUS=$? ;;
  mkdirs)	mkdirs ; STATUS=$? ;;
  mktools)	mktools ; STATUS=$? ;;
  install-mingw-cleanup) install-mingw-cleanup ; STATUS=$? ;;
  conf)	conf ; STATUS=$? ;;
  build)	build ; STATUS=$? ;;
  check)	check ; STATUS=$? ;;
  clean)	clean ; STATUS=$? ;;
  install)	install ; STATUS=$? ;;
  strip)	strip ; STATUS=$? ;;
  package)	pkg ; STATUS=$? ;;
  pkg)	pkg ; STATUS=$? ;;
  src-package)	spkg ; STATUS=$? ;;
  spkg)	spkg ; STATUS=$? ;;
  finish) finish ; STATUS=$? ;;
  all) prep && conf && build && install && \
     strip && pkg && spkg && finish ; \
	  STATUS=$? ;;
  *) echo "Error: bad arguments" ; exit 1 ;;
esac
exit ${STATUS}
