#include <sys/types.h>
#include <sys/mman.h>
#include <sys/stat.h>

#include <unistd.h> 
#include <fcntl.h>

#include "stream.h"

int stream_open(stream *f, buffer *fn) {
	struct stat st;
	
	f->state = FILE_UNSET;
	
	if (-1 == stat(fn->ptr, &st)) {
		return -1;
	}
	
	f->size = st.st_size;
	
	if (-1 == (f->fd = open(fn->ptr, O_RDONLY))) {
		return -1;
	}
	
	f->state = FILE_OPENED;
	
	if (MAP_FAILED == (f->start = mmap(0, f->size, PROT_READ, MAP_SHARED, f->fd, 0))) {
		return -1;
	}
	
	f->state = FILE_MMAPED;
	
	return 0;
}

int stream_close(stream *f) {
	switch(f->state) {
	case FILE_MMAPED:
		munmap(f->start, f->size);
	case FILE_OPENED:
		close(f->fd);
	default:
		break;
	}
	return 0;
}
