#include <stdlib.h>
#include <stdio.h>

#include "server.h"
#include "connections.h"
#include "log.h"

#include "plugin.h"
#if 0
#include <localizer.h>

typedef struct {
	PLUGIN_DATA;
	localizer *l;
	buffer *b_q;
} plugin_data;

static void *mod_maps_init(void) {
	plugin_data *p;
	
	p = calloc(1, sizeof(*p));
	
	p->l = localizer_init();
	
	if (0 != localizer_read_shm(p->l, "/home/weigon/projects/localizer/src/domains-gold.csv.gz")) {
		/* */
		
		localizer_free(p->l);
		p->l = NULL;
	}
	
	p->b_q = buffer_init();
	
	return p;
}

static int mod_maps_cleanup(void *p_d) {
	plugin_data *p = p_d;
	
	if (p->l) {
		localizer_free(p->l);
	}
	
	buffer_free(p->b_q);
	
	free(p);
	
	return 0;
}

static uri_handler_t mod_maps_handler(server *srv, connection *con, void *p_d) {
	buffer *b;
	char *params, *amp, *param, *eq;
	l_data_export lext;
	
	char *ip = NULL, *format = NULL;
	long l_ip;
	char buf[32];
	
	plugin_data *p = p_d;
	
	/* 
	 * REQ : GET /localize?ip=<string>&q=geo,provider,region,zip,nielsen HTTP/1.0\r\n
	 *       Host: jan.kneschke.de\r\n
	 *       \r\n
	 * RESP: HTTP/1.0 200 OK\r\n
	 *       Connection: close\r\n
	 *       Content-Type: text/plain\r\n
	 *       \r\n
	 *       city=Hannover\r\n
	 *       province=Niedersachsen\r\n
	 *       country=Germany\r\n
	 *       provider=de.telekom\r\n
	 *       longitude=64.3242\r\n
	 *       latitude=10.4373\r\n
	 *       radius=7.748\r\n
	 *       <EOF>
	 */
	
	/* not our job */
	if (0 != strcmp(con->uri.path->ptr, "/localize")) {
		return URI_HANDLER_GO_ON;
	}
	
	b = chunk_get_append_buffer(con->write_chunk);
	buffer_reset(b);
	
	buffer_strcpy_buffer(p->b_q, con->uri.query);
	log_error_write(srv, __FILE__, __LINE__, "s", p->b_q->ptr);
	
	params = p->b_q->ptr;
	
	/* search for & */
	for (param = params; NULL != (amp = strchr(param, '&')); param = amp + 1) {
		*amp = '\0';
		
		/* search for = in param */
		
		if (NULL == (eq = strchr(param, '='))) {
			con->http_status = 400;
			return URI_HANDLER_FINISHED;
		}
		
		*eq++ = '\0';
		
		if (0 == strcmp(param, "ip")) {
			ip = eq;
		} else if (0 == strcmp(param, "format")) {
			format = eq;
		}
	}
	
	if (NULL == (eq = strchr(param, '='))) {
		con->http_status = 400;
		return URI_HANDLER_FINISHED;
	}
		
	*eq++ = '\0';
		
	if (0 == strcmp(param, "ip")) {
		ip = eq;
	} else if (0 == strcmp(param, "format")) {
		format = eq;
	}
	
	if (!ip) {
		con->http_status = 400;
		return URI_HANDLER_FINISHED;
	}
	
	if (0 == (l_ip = localizer_ip2int(ip))) {
		con->http_status = 500;
		return URI_HANDLER_FINISHED;
	}
	
	if (0 != localizer_search(p->l, l_ip, &lext)) {
		con->http_status = 404;
		return URI_HANDLER_FINISHED;
	}
	
	if ((format == NULL) || (0 == strcmp(format, "html"))) {
#define TABLE_START() \
	buffer_strcat(b, \
		"<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>\n" \
		      "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"\n" \
		      "    \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n" \
		      "<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">\n" \
		      " <head>\n" \
		      "  <title>localizer</title>\n" \
		      " </head>\n" \
		      " <body>\n" \
		      "  <table>\n");
#define TABLE_END() \
	buffer_strcat(b, "  </table>\n </body>\n</html>");
#define TABLE_ROW(x, y) \
	buffer_strcat(b, "   <tr><td>" x "</td><td>"); \
	buffer_strcat(b, lext.y); \
	buffer_strcat(b, "</td></tr>\n") ;
		
#define TABLE_ROW_DOUBLE(x, y) \
	buffer_strcat(b, "   <tr><td>" x "</td><td>"); \
	sprintf(buf, "%.4f", lext.y); \
	buffer_strcat(b, buf); \
	buffer_strcat(b, "</td></tr>\n");
		
		TABLE_START();
		
		TABLE_ROW("City", city);
		TABLE_ROW("Province", province);
		TABLE_ROW("Country", country);
		TABLE_ROW("Provider", provider);
		
		TABLE_ROW_DOUBLE("Longitude", longitude);
		TABLE_ROW_DOUBLE("Latitude", latitude);
		TABLE_ROW_DOUBLE("Radius", distance);
		
		TABLE_END();
		
#undef TABLE_START
#undef TABLE_END
#undef TABLE_ROW
#undef TABLE_ROW_DOUBLE
		
	} else if (0 == strcmp(format, "csv")) {
		int line = 0;
#define TABLE_START() \
	buffer_strcat(b, "## City, Province, Country, Provider, Longitude, Latitude, Radius\n");
#define TABLE_END() \
	buffer_strcat(b, "\n");
#define TABLE_ROW(x, y) \
	if (line++) buffer_strcat(b, ",");  \
	buffer_strcat(b, lext.y); 
	
		
#define TABLE_ROW_DOUBLE(x, y) \
	if (line++) buffer_strcat(b, ",");  \
	sprintf(buf, "%.4f", lext.y); \
	buffer_strcat(b, buf); 
	
		TABLE_START();
		
		TABLE_ROW("City", city);
		TABLE_ROW("Province", province);
		TABLE_ROW("Country", country);
		TABLE_ROW("Provider", provider);
		
		TABLE_ROW_DOUBLE("Longitude", longitude);
		TABLE_ROW_DOUBLE("Latitude", latitude);
		TABLE_ROW_DOUBLE("Radius", distance);
		
		TABLE_END();
		
#undef TABLE_START
#undef TABLE_END
#undef TABLE_ROW
#undef TABLE_ROW_DOUBLE
		
		buffer_strcpy(con->response.content_type, "text/csv");
	} else if (0 == strcmp(format, "text")) {
#define TABLE_START() ;
		
#define TABLE_END() ;
		
#define TABLE_ROW(x, y) \
	buffer_strcat(b, x" = " ); \
	buffer_strcat(b, lext.y); \
	buffer_strcat(b, "\n");
#define TABLE_ROW_DOUBLE(x, y) \
	buffer_strcat(b, x" = " ); \
	sprintf(buf, "%.4f", lext.y); \
	buffer_strcat(b, buf); \
	buffer_strcat(b, "\n");
	
		TABLE_START();
		
		TABLE_ROW("City", city);
		TABLE_ROW("Province", province);
		TABLE_ROW("Country", country);
		TABLE_ROW("Provider", provider);
		
		TABLE_ROW_DOUBLE("Longitude", longitude);
		TABLE_ROW_DOUBLE("Latitude", latitude);
		TABLE_ROW_DOUBLE("Radius", distance);
		
		TABLE_END();
		
#undef TABLE_START
#undef TABLE_END
#undef TABLE_ROW
#undef TABLE_ROW_DOUBLE
		
		buffer_strcpy(con->response.content_type, "text/plain");
	}
	
	con->http_status = 200;
	con->file_finished = 1;
	
	return URI_HANDLER_FINISHED;
}

#endif

int mod_maps_plugin_init(plugin *p) {
	p->name        = buffer_init_string("maps");
#if 0
	p->init        = mod_maps_init;
	p->handler_uri_clean = mod_maps_handler;
	p->cleanup     = mod_maps_cleanup;
#endif
	p->data        = NULL;
	
	return 0;
}
