#include <stdlib.h>

#include "base.h"
#include "joblist.h"

int joblist_append(server *srv, connection *con) {
	if (con->in_joblist) return 0;
	
	if (srv->joblist->size == 0) {
		srv->joblist->size  = 16;
		srv->joblist->ptr   = malloc(sizeof(*srv->joblist->ptr) * srv->joblist->size);
	} else if (srv->joblist->used == srv->joblist->size) {
		srv->joblist->size += 16;
		srv->joblist->ptr   = realloc(srv->joblist->ptr, sizeof(*srv->joblist->ptr) * srv->joblist->size);
	}
	
	srv->joblist->ptr[srv->joblist->used++] = con;
	
	return 0;
}

void joblist_free(connections *joblist) {
	free(joblist->ptr);
	free(joblist);
}
