Summary: A fast webserver with minimal memory-footprint (lighttpd)
Name: lighttpd
Version: 1.3.0
Release: 1
Source: http://jan.kneschke.de/projects/lighttpd/download/lighttpd-%version.tar.gz
Packager: Jan Kneschke <jan@kneschke.de>
License: QPL
Group: Networking/Daemons
URL: http://jan.kneschke.de/projects/lighttpd/
Requires: pcre >= 3.1 zlib 
BuildPrereq: libtool pcre-devel >= 3.1 zlib-devel
BuildRoot: %{_tmppath}/%{name}-root


%description
lighttpd is intented to be a frontend for ad-servers which have to deliver
small files concurrently to many connections.

Available rpmbuild rebuild options :
--with : ssl mysql

%prep

%setup -q

%build
rm -rf %{buildroot}
%configure \
    %{?_with_mysql:       --with-mysql} \
    %{?_with_ssl:         --with-openssl} 
make

%install

%makeinstall

mkdir -p %{buildroot}%{_sysconfdir}/{init.d,sysconfig}
if test -f /etc/redhat-release -o -f /etc/fedora-release; then
  install -m 755 doc/rc.lighttpd.redhat %{buildroot}%{_sysconfdir}/init.d/lighttpd
else
  install -m 755 doc/rc.lighttpd %{buildroot}%{_sysconfdir}/init.d/lighttpd
fi
install -m 644 doc/sysconfig.lighttpd %{buildroot}%{_sysconfdir}/sysconfig/lighttpd

%clean
rm -rf %{buildroot}

%post

if test "$1" = "0"; then
  # real install, not upgrade
  /sbin/chkconfig --add lighttpd
fi

%preun
if test "$1" = "0"; then
  # real uninstall, not upgrade
  %{_sysconfdir}/init.d/lighttpd stop
  /sbin/chkconfig --del lighttpd
fi

%files
%defattr(-,root,root)
%doc doc/lighttpd.conf doc/lighttpd.user README INSTALL ChangeLog COPYING AUTHORS 
%doc doc/accesslog.txt
%doc doc/authentification.txt
%doc doc/cgi.txt
%doc doc/compress.txt
%doc doc/configuration.txt
%doc doc/fastcgi-state.txt
%doc doc/fastcgi.txt
%doc doc/features.txt
%doc doc/performance.txt
%doc doc/plugins.txt
%doc doc/proxy.txt
%doc doc/redirect.txt
%doc doc/rewrite.txt
%doc doc/rrdtool.txt
%doc doc/secdownload.txt
%doc doc/security.txt
%doc doc/simple-vhost.txt
%doc doc/skeleton.txt
%doc doc/ssi.txt
%doc doc/state.txt
%config(noreplace) %attr(0755,root,root) %{_sysconfdir}/init.d/lighttpd
%config(noreplace) %attr(0644,root,root) %{_sysconfdir}/sysconfig/lighttpd
%{_mandir}/*
%{_libdir}/*
%{_sbindir}/*

%changelog
* Tue Jun 29 2004 17:26 <jan@kneschke.de> 1.2.3
- rpmlint'ed the package
- added URL
- added (noreplace) to start-script
- change group to Networking/Daemon (like apache)

* Sun Feb 23 2003 15:04 <jan@kneschke.de>
- initial version
