#!/bin/sh
# find out where the build script is located
tdir=`echo "$0" | sed 's%[\\/][^\\/][^\\/]*$%%'`
test "x$tdir" = "x$0" && tdir=.
scriptdir=`cd $tdir; pwd`
# find src directory.  
# If scriptdir ends in SPECS, then topdir is $scriptdir/.. 
# If scriptdir ends in CYGWIN-PATCHES, then topdir is $scriptdir/../..
# Otherwise, we assume that topdir = scriptdir
topdir1=`echo ${scriptdir} | sed 's%/SPECS$%%'`
topdir2=`echo ${scriptdir} | sed 's%/CYGWIN-PATCHES$%%'`
if [ "x$topdir1" != "x$scriptdir" ] ; then # SPECS
  topdir=`cd ${scriptdir}/..; pwd`
else
  if [ "x$topdir2" != "x$scriptdir" ] ; then # CYGWIN-PATCHES
    topdir=`cd ${scriptdir}/../..; pwd`
  else
    topdir=`cd ${scriptdir}; pwd`
  fi
fi

export PKG=gettext
export VER=0.10.40
export REL=1
export FULLPKG=${PKG}-${VER}-${REL}
export PKG2=libintl1
export FULLPKG2=${PKG2}-${VER}-${REL}

export src_orig_pkg_name=${PKG}-${VER}.tar.gz
export src_pkg_name=${FULLPKG}-src.tar.bz2
export src_pkg_name2=${FULLPKG2}-src.tar.bz2
export src_patch_name=${FULLPKG}.patch
export bin_pkg_name=${FULLPKG}.tar.bz2
export bin_pkg_name2=${FULLPKG2}.tar.bz2

export src_orig_pkg=${topdir}/${src_orig_pkg_name}
export src_pkg=${topdir}/${src_pkg_name}
export src_pkg2=${topdir}/${src_pkg_name2}
export src_patch=${topdir}/${src_patch_name}
export bin_pkg=${topdir}/${bin_pkg_name}
export bin_pkg2=${topdir}/${bin_pkg_name2}
export srcdir=${topdir}/${PKG}-${VER}
export objdir=${srcdir}/.build
export instdir=${srcdir}/.inst
export srcinstdir=${srcdir}/.sinst
export checkfile=${topdir}/${FULLPKG}.check
host=i686-pc-cygwin
target=i686-pc-cygwin
prefix=/usr
sysconfdir=/etc
docdir=${prefix}/doc/${PKG}-${VER}
alias_path='/usr/share/locale:/usr/local/share/locale:/usr/X11R6/lib/X11/locale'

# We do not want to copy configure.in into ${objdir}
# because we don't really need to run the autotools,
# so we don't care if configure doesn't find them.
prep() {
  (cd ${topdir} && \
  tar xvzf ${src_orig_pkg} ; \
  cd ${topdir} && \
  patch -p0 < ${src_patch} && \
  mkdir -p ${objdir} && \
  mkdir -p ${instdir} && \
  mkdir -p ${srcinstdir} )
}
# We --disable-shared because we don't want libtool to attempt 
# to do it.  We've already added special commands to the Makefile.in's
# to handle sharedlib building...
conf() {
  (cd ${objdir} && \
  ${srcdir}/configure --build=${host} --target=${target} \
  --srcdir=${srcdir} --prefix=${prefix} \
  --exec-prefix=${prefix} --sysconfdir=${sysconfdir} \
  --with-included-gettext --disable-shared )
}
build() {
  (cd ${objdir} && \
  make CFLAGS=-O2 aliaspath=${alias_path} )
}
build_dyn() {
  (cd ${objdir} && \
  make CFLAGS=-O2 aliaspath=${alias_path} && \
  cat src/Makefile | sed -e 's/-static//' > src/Makefile2 && \
  mv src/Makefile2 src/Makefile && \
  cp intl/libintl.dll.a intl/.libs/libintl.a && \
  cp intl/cygintl*.dll src && \
  cp intl/cygintl*.dll tests && \
  rm -f src/*.exe && \
  rm -f tests/*.exe && \
  make CFLAGS=-O2 aliaspath=${alias_path} )
}
check() {
  (cd ${objdir} && \
  make check | tee ${checkfile} 2>&1 )
}
clean() {
  (cd ${objdir} && \
  make clean )
}
install_dirs() {
  (if [ ! -d ${instdir}${prefix}/doc/Cygwin ]; then \
    mkdir -p ${instdir}${prefix}/doc/Cygwin ; \
  fi && \
  if [ ! -d ${instdir}${prefix}/doc/${PKG}-${VER} ]; then \
    mkdir -p ${instdir}${prefix}/doc/${PKG}-${VER} ; \
  fi && \
  if [ ! -d ${instdir}${sysconfdir}/postinstall ]; then \
    mkdir -p ${instdir}${sysconfdir}/postinstall ; \
  fi )
}
install_extra() {
  (cd ${objdir} && \
  /usr/bin/install -m 644 ${srcdir}/CYGWIN-PATCHES/${PKG}.README \
    ${instdir}${prefix}/doc/Cygwin/${PKG}-${VER}.README && \
  /usr/bin/install -m 644 ${srcdir}/README \
    ${srcdir}/ABOUT-NLS ${srcdir}/AUTHORS ${srcdir}/BUGS ${srcdir}/COPYING \
	 ${srcdir}/DISCLAIM ${srcdir}/NEWS ${srcdir}/THANKS ${srcdir}/TODO \
	 ${instdir}${prefix}/doc/${PKG}-${VER} && \
  /usr/bin/install -m 755 ${srcdir}/CYGWIN-PATCHES/postinstall.sh \
    ${instdir}${sysconfdir}/postinstall/${PKG}.sh )
}
# since we cheated on the libtool-dll-creation, we don't
# want the (incorrecT) libtool .la file...
install() {
  (cd ${objdir} && \
  make install INSTALL=install \
  prefix=${instdir}${prefix} \
  exec_prefix=${instdir}${prefix} \
  sysconfdir=${instdir}${sysconfdir} \
  docdir=${instdir}${docdir} && \
  if [ -f ${instdir}${prefix}/info/dir ] ; then \
    rm ${instdir}${prefix}/info/dir ; \
  fi && \
  if [ -f ${instdir}${prefix}/lib/libintl.la ] ; then \
    rm ${instdir}${prefix}/lib/libintl.la ; \
  fi && \
  install_dirs && \
  install_extra )
}
mkpatch() {
  (cd ${srcdir} && \
  tar xvzf ${src_orig_pkg} ; \
  mv ${PKG}-${VER} ../${PKG}-${VER}-orig && \
  cd ${topdir} && \
  diff -urN -x '.build' -x '.inst' -x '.sinst' \
    ${PKG}-${VER}-orig ${PKG}-${VER} > \
    ${srcinstdir}/${src_patch_name} ; \
  rm -rf ${PKG}-${VER}-orig )
}
strip() {
  (cd ${instdir} && \
  find . -name "*.exe" | xargs strip && \
  find . -name "*.dll" | xargs strip )
}
pkg() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg} * --exclude='usr/bin/*.dll' && \
  tar cvjf ${bin_pkg2} usr/bin/*.dll )
}
spkg() {
  (mkpatch && \
  cp ${src_orig_pkg} ${srcinstdir}/${src_orig_pkg_name} && \
  cp $0 ${srcinstdir}/`basename $0` && \
  cd ${srcinstdir} && \
  tar cvjf ${src_pkg} * && \
  cd ${srcdir}/CYGWIN-PATCHES && \
  cp -a libintl1-src ${FULLPKG2} && \
  tar cvjf ${src_pkg2} ${FULLPKG2} && \
  rm -rf ${FULLPKG2} )
}
finish() {
  rm -rf ${srcdir}
}
case $1 in
  prep)	prep ; STATUS=$? ;;
  conf)	conf ; STATUS=$? ;;
  build)	build ; STATUS=$? ;;
  check)	check ; STATUS=$? ;;
  clean)	clean ; STATUS=$? ;;
  install)	install ; STATUS=$? ;;
  strip)	strip ; STATUS=$? ;;
  mkpatch) mkpatch ; STATUS=$? ;;
  package)	pkg ; STATUS=$? ;;
  pkg)	pkg ; STATUS=$? ;;
  src-package)	spkg ; STATUS=$? ;;
  spkg)	spkg ; STATUS=$? ;;
  finish) finish ; STATUS=$? ;;
  all) prep && conf && build && install && \
     strip && pkg && spkg && finish ; STATUS=$? ;;
  all_dyn) prep && conf && build_dyn && install && \
     strip && pkg && spkg && finish ; STATUS=$? ;;
  *) echo "Error: bad arguments" ; exit 1 ;;
esac
exit ${STATUS}
