/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;
import java.awt.image.IndexColorModel;

public abstract class RGBImageFilter
extends ImageFilter {
    protected ColorModel origmodel;
    protected ColorModel newmodel;
    protected boolean canFilterIndexColorModel;

    private /* synthetic */ void finit$() {
        this.origmodel = ColorModel.getRGBdefault();
        this.canFilterIndexColorModel = false;
    }

    public RGBImageFilter() {
        this.finit$();
    }

    public void setColorModel(ColorModel model) {
        this.origmodel = model;
        this.newmodel = model;
        if (model instanceof IndexColorModel && this.canFilterIndexColorModel) {
            this.newmodel = this.filterIndexColorModel((IndexColorModel)model);
        }
    }

    public void substituteColorModel(ColorModel oldcm, ColorModel newcm) {
        this.origmodel = oldcm;
        this.newmodel = newcm;
    }

    public IndexColorModel filterIndexColorModel(IndexColorModel icm) {
        int len = icm.getMapSize();
        byte[] reds = new byte[len];
        byte[] greens = new byte[len];
        byte[] blues = new byte[len];
        byte[] alphas = new byte[len];
        icm.getAlphas(alphas);
        icm.getReds(reds);
        icm.getGreens(greens);
        icm.getBlues(blues);
        for (int i = 0; i < len; ++i) {
            int rgb = this.filterRGB(-1, -1, this.makeColor(alphas[i], reds[i], greens[i], blues[i]));
            alphas[i] = (byte)((0xFF000000 & rgb) >> 24);
            reds[i] = (byte)((0xFF0000 & rgb) >> 16);
            greens[i] = (byte)((0xFF00 & rgb) >> 8);
            blues[i] = (byte)rgb & 0xFFFFFFFF;
        }
        return new IndexColorModel(icm.getPixelSize(), len, reds, greens, blues, alphas);
    }

    private int makeColor(byte a, byte r, byte g, byte b) {
        return 0xFF000000 & a << 24 | 0xFF0000 & r << 16 | 0xFF00 & b << 8 | 0xFF & g;
    }

    public void filterRGBPixels(int x, int y, int w, int h, int[] pixels, int off, int scansize) {
        for (int xp = x; xp < x + w; ++xp) {
            for (int yp = y; yp < y + h; ++yp) {
                pixels[off + yp * scansize + xp] = this.filterRGB(xp, yp, pixels[off + yp * scansize + xp]);
            }
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int offset, int scansize) {
        if (model == this.origmodel) {
            this.consumer.setPixels(x, y, w, h, this.newmodel, pixels, offset, scansize);
        } else {
            int[] pixelsi = new int[pixels.length / 4];
            this.filterRGBPixels(x, y, w, h, pixelsi, offset, scansize);
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int offset, int scansize) {
        if (model == this.origmodel) {
            this.consumer.setPixels(x, y, w, h, this.newmodel, pixels, offset, scansize);
        } else {
            this.convertColorModelToDefault(x, y, w, h, model, pixels, offset, scansize);
            this.filterRGBPixels(x, y, w, h, pixels, offset, scansize);
        }
    }

    private void convertColorModelToDefault(int x, int y, int w, int h, ColorModel model, int[] pixels, int offset, int scansize) {
        for (int xp = x; xp < x + w; ++xp) {
            for (int yp = y; yp < y + h; ++yp) {
                pixels[offset + yp * scansize + xp] = this.makeColorbyDefaultCM(pixels[offset + yp * scansize + xp]);
            }
        }
    }

    private int makeColorbyDefaultCM(int rgb) {
        return this.makeColor(this.origmodel.getRed(rgb), this.origmodel.getGreen(rgb), this.origmodel.getGreen(rgb), this.origmodel.getBlue(rgb));
    }

    private int makeColor(int a, int r, int g, int b) {
        return 0xFF000000 & a << 24 | 0xFF0000 & r << 16 | 0xFF00 & b << 8 | 0xFF & g;
    }

    public abstract int filterRGB(int var1, int var2, int var3);
}

