/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import gnu.java.nio.FloatBufferImpl;
import java.nio.Buffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;

public abstract class FloatBuffer
extends Buffer
implements Comparable {
    protected float[] backing_buffer;
    protected int array_offset = 0;

    public static FloatBuffer allocateDirect(int capacity) {
        throw new Error("direct buffers not implemented");
    }

    public static FloatBuffer allocate(int capacity) {
        return new FloatBufferImpl(capacity, 0, capacity);
    }

    public static final FloatBuffer wrap(float[] array, int offset, int length) {
        return new FloatBufferImpl(array, offset, length);
    }

    public static final FloatBuffer wrap(String a) {
        int len = a.length();
        float[] buffer = new float[len];
        for (int i = 0; i < len; ++i) {
            buffer[i] = a.charAt(i);
        }
        return FloatBuffer.wrap(buffer, 0, len);
    }

    public static final FloatBuffer wrap(float[] array) {
        return FloatBuffer.wrap(array, 0, array.length);
    }

    FloatBuffer(int capacity, int limit, int position, int mark) {
        super(capacity, limit, position, mark);
    }

    public FloatBuffer get(float[] dst, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            dst[i] = this.get();
        }
        return this;
    }

    public FloatBuffer get(float[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public FloatBuffer put(FloatBuffer src) {
        while (src.hasRemaining()) {
            this.put(src.get());
        }
        return this;
    }

    public FloatBuffer put(float[] src, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            this.put(src[i]);
        }
        return this;
    }

    public final FloatBuffer put(float[] src) {
        return this.put(src, 0, src.length);
    }

    public final boolean hasArray() {
        return this.backing_buffer != null && this.isReadOnly() ^ true;
    }

    public final float[] array() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        return this.backing_buffer;
    }

    public final int arrayOffset() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        return this.array_offset;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FloatBuffer) {
            return this.compareTo(obj) == 0;
        }
        return false;
    }

    public int compareTo(Object ob) {
        FloatBuffer a = (FloatBuffer)ob;
        if (a.remaining() != this.remaining()) {
            return 1;
        }
        if (!this.hasArray() || !a.hasArray()) {
            return 1;
        }
        int r = this.remaining();
        int i1 = this.position();
        int i2 = a.position();
        for (int i = 0; i < r; ++i) {
            int t = (int)(this.get(i1) - a.get(i2));
            if (t == 0) continue;
            return t;
        }
        return 0;
    }

    public abstract ByteOrder order();

    public abstract float get();

    public abstract FloatBuffer put(float var1);

    public abstract float get(int var1);

    public abstract FloatBuffer put(int var1, float var2);

    public abstract FloatBuffer compact();

    public abstract boolean isDirect();

    public abstract FloatBuffer slice();

    public abstract FloatBuffer duplicate();

    public abstract FloatBuffer asReadOnlyBuffer();
}

