/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;

public class GZIPInputStream
extends InflaterInputStream {
    public static final int GZIP_MAGIC = 35615;
    protected CRC32 crc;
    protected boolean eos;
    static final int Z_DEFLATED = 8;
    static final int HEAD_CRC = 2;
    static final int EXTRA_FIELD = 4;
    static final int ORIG_NAME = 8;
    static final int COMMENT = 16;
    static final int RESERVED = 224;

    public void close() throws IOException {
        super.close();
    }

    public GZIPInputStream(InputStream istream) throws IOException {
        this(istream, 512);
    }

    private final int eof_read() throws IOException {
        int r = this.in.read();
        if (r == -1) {
            throw new ZipException("gzip header corrupted");
        }
        return r & 0xFF;
    }

    public GZIPInputStream(InputStream istream, int readsize) throws IOException {
        super(istream, new Inflater(true), readsize);
        int c;
        int magic = this.eof_read() | this.eof_read() << 8;
        if (magic != 35615) {
            throw new ZipException("gzip header corrupted");
        }
        int method = this.eof_read();
        int flags = this.eof_read();
        if (method != 8 || (flags & 0xE0) != 0) {
            throw new ZipException("gzip header corrupted");
        }
        for (int i = 0; i < 6; ++i) {
            this.eof_read();
        }
        if ((flags & 4) != 0) {
            int len = this.eof_read() | this.eof_read() << 8;
            while (len-- != 0) {
                this.eof_read();
            }
        }
        if ((flags & 8) != 0) {
            while ((c = this.eof_read()) != 0) {
            }
        }
        if ((flags & 0x10) != 0) {
            while ((c = this.eof_read()) != 0) {
            }
        }
        if ((flags & 2) != 0) {
            this.eof_read();
            this.eof_read();
        }
        this.crc = new CRC32();
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        if (this.eos) {
            return -1;
        }
        int r = super.read(buf, off, len);
        if (r == -1) {
            this.eos = true;
            byte[] tmp = new byte[8];
            int avail = this.inf.getRemaining();
            System.arraycopy(this.buf, this.len - avail, tmp, 0, avail);
            for (int i = avail; i < 8; ++i) {
                tmp[i] = (byte)this.eof_read();
            }
            int header_crc = this.read4(tmp, 0);
            if (this.crc.getValue() != (long)header_crc) {
                throw new ZipException("corrupted gzip file - crc mismatch");
            }
            int isize = this.read4(tmp, 4);
            if (this.inf.getTotalOut() != isize) {
                throw new ZipException("corrupted gzip file - size mismatch");
            }
            return -1;
        }
        this.crc.update(buf, off, r);
        return r;
    }

    private final int read4(byte[] buf, int offset) throws IOException {
        return ((buf[offset + 3] & 0xFF) << 24) + ((buf[offset + 2] & 0xFF) << 16) + ((buf[offset + 1] & 0xFF) << 8) + (buf[offset] & 0xFF);
    }
}

