/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Enumeration;
import java.util.Hashtable;

public class MemoryImageSource
implements ImageProducer {
    private boolean animated;
    private boolean fullbuffers;
    private int[] pixeli;
    private int width;
    private int height;
    private int offset;
    private int scansize;
    private byte[] pixelb;
    private ColorModel cm;
    private Hashtable props;
    private Hashtable consumers;

    private /* synthetic */ void finit$() {
        this.animated = false;
        this.fullbuffers = false;
        this.consumers = new Hashtable();
    }

    public MemoryImageSource(int w, int h, ColorModel cm, byte[] pix, int off, int scan) {
        this(w, h, cm, pix, off, scan, (Hashtable)null);
    }

    public MemoryImageSource(int w, int h, ColorModel cm, byte[] pix, int off, int scan, Hashtable props) {
        this.finit$();
        this.width = w;
        this.height = h;
        this.cm = cm;
        this.offset = off;
        this.scansize = scan;
        this.props = props;
        int max = this.scansize > this.width ? this.scansize : this.width;
        this.pixelb = new byte[max * this.height];
        System.arraycopy(pix, 0, this.pixelb, 0, max);
    }

    public MemoryImageSource(int w, int h, ColorModel cm, int[] pix, int off, int scan) {
        this(w, h, cm, pix, off, scan, null);
    }

    public MemoryImageSource(int w, int h, ColorModel cm, int[] pix, int off, int scan, Hashtable props) {
        this.finit$();
        this.width = w;
        this.height = h;
        this.cm = cm;
        this.offset = off;
        this.scansize = scan;
        this.props = props;
        int max = this.scansize > this.width ? this.scansize : this.width;
        this.pixeli = new int[max * this.height];
        System.arraycopy(pix, 0, this.pixeli, 0, max);
    }

    public MemoryImageSource(int w, int h, int[] pix, int off, int scan, Hashtable props) {
        this(w, h, ColorModel.getRGBdefault(), pix, off, scan, props);
    }

    public MemoryImageSource(int w, int h, int[] pix, int off, int scan) {
        this(w, h, ColorModel.getRGBdefault(), pix, off, scan, null);
    }

    public synchronized void addConsumer(ImageConsumer ic) {
        if (this.consumers.containsKey(ic)) {
            return;
        }
        this.consumers.put(ic, ic);
    }

    public synchronized boolean isConsumer(ImageConsumer ic) {
        return this.consumers.containsKey(ic);
    }

    public synchronized void removeConsumer(ImageConsumer ic) {
        this.consumers.remove(ic);
    }

    public void startProduction(ImageConsumer ic) {
        if (!this.consumers.containsKey(ic)) {
            this.consumers.put(ic, ic);
        }
        Enumeration e = this.consumers.elements();
        while (e.hasMoreElements()) {
            ic = (ImageConsumer)e.nextElement();
            this.sendPicture(ic);
            ic.imageComplete(16);
        }
    }

    public void requestTopDownLeftRightResend(ImageConsumer ic) {
        this.startProduction(ic);
    }

    public synchronized void setAnimated(boolean animated) {
        this.animated = animated;
    }

    public synchronized void setFullBufferUpdates(boolean fullbuffers) {
        this.fullbuffers = fullbuffers;
    }

    public void newPixels() {
        if (this.animated) {
            Enumeration e = this.consumers.elements();
            while (e.hasMoreElements()) {
                ImageConsumer ic = (ImageConsumer)e.nextElement();
                this.sendPicture(ic);
                ic.imageComplete(16);
            }
        }
    }

    private void sendPicture(ImageConsumer ic) {
        ic.setHints(2);
        if (this.props != null) {
            ic.setProperties(this.props);
        }
        if (this.pixeli != null) {
            ic.setPixels(0, 0, this.width, this.height, this.cm, this.pixeli, this.offset, this.scansize);
        } else {
            ic.setPixels(0, 0, this.width, this.height, this.cm, this.pixelb, this.offset, this.scansize);
        }
    }

    public synchronized void newPixels(int x, int y, int w, int h) {
        if (this.animated) {
            if (this.fullbuffers) {
                this.newPixels();
            } else {
                Enumeration e = this.consumers.elements();
                while (e.hasMoreElements()) {
                    ImageConsumer ic = (ImageConsumer)e.nextElement();
                    ic.setHints(2);
                    if (this.props != null) {
                        ic.setProperties(this.props);
                    }
                    if (this.pixeli != null) {
                        ic.setPixels(0, 0, this.width, this.height, this.cm, this.pixeli, this.offset, this.scansize);
                    } else {
                        ic.setPixels(0, 0, this.width, this.height, this.cm, this.pixelb, this.offset, this.scansize);
                    }
                    ic.imageComplete(16);
                }
            }
        }
    }

    public synchronized void newPixels(int x, int y, int w, int h, boolean framenotify) {
        if (this.animated) {
            if (this.fullbuffers) {
                this.newPixels();
            } else {
                Enumeration e = this.consumers.elements();
                while (e.hasMoreElements()) {
                    ImageConsumer ic = (ImageConsumer)e.nextElement();
                    ic.setHints(2);
                    if (this.props != null) {
                        ic.setProperties(this.props);
                    }
                    if (this.pixeli != null) {
                        ic.setPixels(0, 0, this.width, this.height, this.cm, this.pixeli, this.offset, this.scansize);
                    } else {
                        ic.setPixels(0, 0, this.width, this.height, this.cm, this.pixelb, this.offset, this.scansize);
                    }
                    if (!framenotify) continue;
                    ic.imageComplete(16);
                }
            }
        }
    }

    public synchronized void newPixels(byte[] newpix, ColorModel newmodel, int offset, int scansize) {
        if (this.animated) {
            // empty if block
        }
    }

    public synchronized void newPixels(int[] newpix, ColorModel newmodel, int offset, int scansize) {
        if (this.animated) {
            // empty if block
        }
    }
}

