/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;

public class BorderLayout
implements LayoutManager2,
Serializable {
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String EAST = "East";
    public static final String WEST = "West";
    public static final String CENTER = "Center";
    public static final String BEFORE_FIRST_LINE = "First";
    public static final String AFTER_LAST_LINE = "Last";
    public static final String BEFORE_LINE_BEGINS = "Before";
    public static final String AFTER_LINE_ENDS = "After";
    public static final String PAGE_START = "First";
    public static final String PAGE_END = "Last";
    public static final String LINE_START = "Before";
    public static final String LINE_END = "After";
    private static final long serialVersionUID = -8658291919501921765L;
    private Component north;
    private Component south;
    private Component east;
    private Component west;
    private Component center;
    private Component firstLine;
    private Component lastLine;
    private Component firstItem;
    private Component lastItem;
    private int hgap;
    private int vgap;
    private static final int MIN = 0;
    private static final int MAX = 1;
    private static final int PREF = 2;

    public BorderLayout() {
        this(0, 0);
    }

    public BorderLayout(int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    public void addLayoutComponent(Component component, Object constraints) {
        if (constraints != null && !(constraints instanceof String)) {
            throw new IllegalArgumentException("Constraint must be a string");
        }
        String str = (String)constraints;
        if (str == null || str.equals(CENTER)) {
            this.center = component;
        } else if (str.equals(NORTH)) {
            this.north = component;
        } else if (str.equals(SOUTH)) {
            this.south = component;
        } else if (str.equals(EAST)) {
            this.east = component;
        } else if (str.equals(WEST)) {
            this.west = component;
        } else if (str.equals("First")) {
            this.firstLine = component;
        } else if (str.equals("Last")) {
            this.lastLine = component;
        } else if (str.equals("Before")) {
            this.firstItem = component;
        } else if (str.equals("After")) {
            this.lastItem = component;
        } else {
            throw new IllegalArgumentException("Constraint value not valid: " + str);
        }
    }

    public void addLayoutComponent(String constraints, Component component) {
        this.addLayoutComponent(component, constraints);
    }

    public void removeLayoutComponent(Component component) {
        if (this.north == component) {
            this.north = null;
        }
        if (this.south == component) {
            this.south = null;
        }
        if (this.east == component) {
            this.east = null;
        }
        if (this.west == component) {
            this.west = null;
        }
        if (this.center == component) {
            this.center = null;
        }
        if (this.firstItem == component) {
            this.firstItem = null;
        }
        if (this.lastItem == component) {
            this.lastItem = null;
        }
        if (this.firstLine == component) {
            this.firstLine = null;
        }
        if (this.lastLine == component) {
            this.lastLine = null;
        }
    }

    public Dimension minimumLayoutSize(Container target) {
        return this.calcSize(target, 0);
    }

    public Dimension preferredLayoutSize(Container target) {
        return this.calcSize(target, 2);
    }

    public Dimension maximumLayoutSize(Container target) {
        return this.calcSize(target, 1);
    }

    public float getLayoutAlignmentX(Container parent) {
        return parent.getAlignmentX();
    }

    public float getLayoutAlignmentY(Container parent) {
        return parent.getAlignmentY();
    }

    public void invalidateLayout(Container parent) {
    }

    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            try {
                Insets i = target.getInsets();
                ComponentOrientation orient = target.getComponentOrientation();
                boolean left_to_right = orient.isLeftToRight();
                Component my_north = this.north;
                Component my_east = this.east;
                Component my_south = this.south;
                Component my_west = this.west;
                if (this.firstLine != null) {
                    my_north = this.firstLine;
                }
                if (this.lastLine != null) {
                    my_south = this.lastLine;
                }
                if (this.firstItem != null) {
                    if (left_to_right) {
                        my_west = this.firstItem;
                    } else {
                        my_east = this.firstItem;
                    }
                }
                if (this.lastItem != null) {
                    if (left_to_right) {
                        my_east = this.lastItem;
                    } else {
                        my_west = this.lastItem;
                    }
                }
                Dimension c = this.calcCompSize(this.center, 2);
                Dimension n = this.calcCompSize(my_north, 2);
                Dimension s = this.calcCompSize(my_south, 2);
                Dimension e = this.calcCompSize(my_east, 2);
                Dimension w = this.calcCompSize(my_west, 2);
                Dimension t = target.getSize();
                int x1 = i.left;
                int x2 = x1 + w.width + this.hgap;
                int x3 = t.width - i.right - e.width;
                int ww = t.width - i.right - i.left;
                int y1 = i.top;
                int y2 = y1 + n.height + this.vgap;
                int y3 = t.height - i.bottom - s.height;
                int hh = y3 - y2 - this.vgap;
                this.setBounds(this.center, x2, y2, x3 - x2 - this.hgap, hh);
                this.setBounds(my_north, x1, y1, ww, n.height);
                this.setBounds(my_south, x1, y3, ww, s.height);
                this.setBounds(my_west, x1, y2, w.width, hh);
                this.setBounds(my_east, x3, y2, e.width, hh);
            }
            finally {
                Object var3_3 = null;
            }
            return;
        }
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + "]";
    }

    private void setBounds(Component comp, int x, int y, int w, int h) {
        if (comp == null) {
            return;
        }
        comp.setBounds(x, y, w, h);
    }

    private Dimension calcCompSize(Component comp, int what) {
        if (comp == null) {
            return new Dimension(0, 0);
        }
        if (what == 0) {
            return comp.getMinimumSize();
        }
        if (what == 1) {
            return comp.getMaximumSize();
        }
        return comp.getPreferredSize();
    }

    private Dimension calcSize(Container target, int what) {
        Object object = target.getTreeLock();
        synchronized (object) {
            try {
                Insets ins = target.getInsets();
                ComponentOrientation orient = target.getComponentOrientation();
                boolean left_to_right = orient.isLeftToRight();
                Component my_north = this.north;
                Component my_east = this.east;
                Component my_south = this.south;
                Component my_west = this.west;
                if (this.firstLine != null) {
                    my_north = this.firstLine;
                }
                if (this.lastLine != null) {
                    my_south = this.lastLine;
                }
                if (this.firstItem != null) {
                    if (left_to_right) {
                        my_west = this.firstItem;
                    } else {
                        my_east = this.firstItem;
                    }
                }
                if (this.lastItem != null) {
                    if (left_to_right) {
                        my_east = this.lastItem;
                    } else {
                        my_west = this.lastItem;
                    }
                }
                Dimension ndim = this.calcCompSize(my_north, what);
                Dimension sdim = this.calcCompSize(my_south, what);
                Dimension edim = this.calcCompSize(my_east, what);
                Dimension wdim = this.calcCompSize(my_west, what);
                Dimension cdim = this.calcCompSize(this.center, what);
                int width = edim.width + cdim.width + wdim.width + this.hgap * 2;
                if (ndim.width > width) {
                    width = ndim.width;
                }
                if (sdim.width > width) {
                    width = sdim.width;
                }
                width += ins.left + ins.right;
                int height = edim.height;
                if (cdim.height > height) {
                    height = cdim.height;
                }
                if (wdim.height > height) {
                    height = wdim.height;
                }
                Dimension dimension = new Dimension(width, height += ndim.height + sdim.height + this.vgap * 2 + ins.top + ins.bottom);
                Object var19_19 = null;
                return dimension;
            }
            catch (Throwable throwable) {
                Object var19_20 = null;
                throw throwable;
            }
        }
    }

    static {
        NORTH = NORTH;
        SOUTH = SOUTH;
        EAST = EAST;
        WEST = WEST;
        CENTER = CENTER;
        BEFORE_FIRST_LINE = "First";
        AFTER_LAST_LINE = "Last";
        BEFORE_LINE_BEGINS = "Before";
        AFTER_LINE_ENDS = "After";
        PAGE_START = "First";
        PAGE_END = "Last";
        LINE_START = "Before";
        LINE_END = "After";
    }
}

