#!/bin/sh
set -x
# find out where the build script is located
tdir=`echo "$0" | sed 's%[\\/][^\\/][^\\/]*$%%'`
test "x$tdir" = "x$0" && tdir=.
scriptdir=`cd $tdir; pwd`
# find src directory.  
# If scriptdir ends in SPECS, then topdir is $scriptdir/.. 
# If scriptdir ends in CYGWIN-PATCHES, then topdir is $scriptdir/../..
# Otherwise, we assume that topdir = scriptdir
topdir1=`echo ${scriptdir} | sed 's%/SPECS$%%'`
topdir2=`echo ${scriptdir} | sed 's%/CYGWIN-PATCHES$%%'`
if [ "x$topdir1" != "x$scriptdir" ] ; then # SPECS
  topdir=`cd ${scriptdir}/..; pwd`
else
  if [ "x$topdir2" != "x$scriptdir" ] ; then # CYGWIN-PATCHES
    topdir=`cd ${scriptdir}/../..; pwd`
  else
    topdir=`cd ${scriptdir}; pwd`
  fi
fi

tscriptname=`basename $0 .sh`
export PKG=`echo $tscriptname | sed -e 's/\-[^\-]*\-[^\-]*$//'`
export VER=`echo $tscriptname | sed -e "s/${PKG}\-//" -e 's/\-[^\-]*$//'`
export REL=`echo $tscriptname | sed -e "s/${PKG}\-${VER}\-//"`
export FULLPKG=${PKG}-${VER}-${REL}

# determine correct decompression option and tarball filename
if [ -e ${PKG}-${VER}-src.tar.gz ] ; then
  export opt_decomp=z
  export src_orig_pkg_ext=gz
elif [ -e ${PKG}-${VER}-src.tar.bz2 ] ; then
  export opt_decomp=j
  export src_orig_pkg_ext=bz2
fi

export src_orig_pkg_name=${PKG}-${VER}-src.tar.${src_orig_pkg_ext}
export src_pkg_name=${FULLPKG}-src.tar.bz2
export src_patch_name=${FULLPKG}.patch
export bin_pkg_name=${FULLPKG}.tar.bz2

export src_orig_pkg=${topdir}/${src_orig_pkg_name}
export src_pkg=${topdir}/${src_pkg_name}
export src_patch=${topdir}/${src_patch_name}
export bin_pkg=${topdir}/${bin_pkg_name}
export srcdir=${topdir}/${PKG}-${VER}-${REL}
export objdir=${srcdir}/.build
export instdir=${srcdir}/.inst
export srcinstdir=${srcdir}/.sinst
export checkfile=${topdir}/log.${FULLPKG}.check

# Global settings
prefix=/usr
sysconfdir=/etc
# run on
host=i686-pc-cygwin
# if this package creates binaries, they run on
target=i686-pc-cygwin

# For managed mode mounts
winbase=`cygpath -m ${topdir}`
mount_base=${winbase}
mount_target=${topdir}

MY_CFLAGS='-O3 -pipe -march=i486 -funroll-loops'
MY_CXXFLAGS='-O3 -pipe -march=i486 -funroll-loops'
MY_LIBCFLAGS='-O3 -pipe -march=i486 -funroll-loops'
MY_LIBCXXFLAGS='-O3 -pipe -march=i486 -funroll-loops'
MY_DFLAGS='-O3 -pipe -march=i486 -funroll-loops'
MY_LDFLAGS='-Wl,-s -Wl,--stack=0x00800000'
MY_JCFLAGS='-O3 -pipe -march=i486 -funroll-loops'
MY_GCJFLAGS='-O3'
MY_LIBGCJ_CFLAGS='-O3 -pipe -march=i486 -D__NO_MATH_INLINES -ffloat-store -fno-omit-frame-pointer -funroll-loops'
MY_LIBGCJ_CXXFLAGS='-O3 -pipe -march=i486 -D__NO_MATH_INLINES -ffloat-store -fno-omit-frame-pointer -funroll-loops'
MY_LIBGCJ_JAVAFLAGS='-O3 -pipe -march=i486 -ffloat-store -fno-omit-frame-pointer -funroll-loops'
MY_GNATLIBCFLAGS='-O3 -pipe -march=i486 -funroll-loops'

export TCL_LIBRARY=/usr/share/tcl8.4
export DEJAGNULIBS=/usr/share/dejagnu

# The directories that should be part of the various language-specific
# tar files.  These are all relative to the top of the source tree.
SOURCE_DIRECTORY=${PKG}-${VER}-${REL}

ADA_DIRS="${SOURCE_DIRECTORY}/gcc/ada"
CPLUSPLUS_DIRS="${SOURCE_DIRECTORY}/gcc/cp ${SOURCE_DIRECTORY}/libstdc++-v3"
FORTRAN_DIRS="${SOURCE_DIRECTORY}/gcc/f ${SOURCE_DIRECTORY}/libf2c"
JAVA_DIRS="${SOURCE_DIRECTORY}/gcc/java ${SOURCE_DIRECTORY}/libjava ${SOURCE_DIRECTORY}/libffi ${SOURCE_DIRECTORY}/fastjar ${SOURCE_DIRECTORY}/zlib ${SOURCE_DIRECTORY}/boehm-gc"
OBJECTIVEC_DIRS="${SOURCE_DIRECTORY}/gcc/objc ${SOURCE_DIRECTORY}/libobjc"
TESTSUITE_DIRS="${SOURCE_DIRECTORY}/gcc/testsuite"
GPC_DIRS="${SOURCE_DIRECTORY}/gcc/p"
GM2_DIRS="${SOURCE_DIRECTORY}/gcc/gm2"
GDC_DIRS="${srcdir}/gcc/d"

# all available = ada,c,c++,f77,gm2,java,objc,pascal
# additional languages added later
languages_to_build="c"

all_source_packages="${PKG}-core-${VER}.tar.bz2\
 ${PKG}-ada-${VER}.tar.bz2\
 ${PKG}-g++-${VER}.tar.bz2\
 ${PKG}-g77-${VER}.tar.bz2\
 ${PKG}-gdc-${VER}.tar.bz2\
 ${PKG}-gpc-${VER}.tar.bz2\
 ${PKG}-java-${VER}.tar.bz2\
 ${PKG}-objc-${VER}.tar.bz2\
 ${PKG}-testsuite-${VER}.tar.bz2"

# Modula 2 discontinued
#  ${PKG}-gm2-${VER}.tar.bz2\

# This is the main DESTDIR target:
PKG1=${instdir}/package-gcc

# These are the directories to build other packages in:
PKG2=${instdir}/package-gcc-g++
PKG3=${instdir}/package-gcc-g77
PKG4=${instdir}/package-gcc-gnat
PKG5=${instdir}/package-gcc-java
PKG6=${instdir}/package-gcc-objc
PKG7=${instdir}/package-gcc-gpc
PKG8=${instdir}/package-gcc-gm2
PKG9=${instdir}/package-gcc-gdc

# Main script

mkdirs() {
  (cd ${topdir} && \
   rm -fr ${objdir} ${instdir} ${srcinstdir} && \
   mkdir -p ${objdir} && \
   mkdir -p ${instdir} && \
   mkdir -p ${srcinstdir} 
  )
}
extract() {
  (cd ${topdir} && \
   tar xvjf ${PKG}-core-${VER}.tar.bz2 && \
   if [ -f ${PKG}-ada-${VER}.tar.bz2 ] ; then
     tar xvjf ${PKG}-ada-${VER}.tar.bz2
   fi
   if [ -f ${PKG}-g++-${VER}.tar.bz2 ] ; then
     tar xvjf ${PKG}-g++-${VER}.tar.bz2 
   fi
   if [ -f ${PKG}-g77-${VER}.tar.bz2 ] ; then
     tar xvjf ${PKG}-g77-${VER}.tar.bz2
   fi
   if [ -f ${PKG}-gdc-${VER}.tar.bz2 ] ; then
     tar xvjf ${PKG}-gdc-${VER}.tar.bz2
   fi
   if [ -f ${PKG}-gm2-${VER}.tar.bz2 ] ; then
     tar xvjf ${PKG}-gm2-${VER}.tar.bz2
   fi
   if [ -f ${PKG}-gpc-${VER}.tar.bz2 ] ; then
     tar xvjf ${PKG}-gpc-${VER}.tar.bz2
   fi
   if [ -f ${PKG}-java-${VER}.tar.bz2 ] ; then
     tar xvjf ${PKG}-java-${VER}.tar.bz2
   fi
   if [ -f ${PKG}-objc-${VER}.tar.bz2 ] ; then
     tar xvjf ${PKG}-objc-${VER}.tar.bz2
   fi
   if [ -f ${PKG}-testsuite-${VER}.tar.bz2 ] ; then
     tar xvjf ${PKG}-testsuite-${VER}.tar.bz2
   fi )
}

extract_for_patch() {
  (cd ${srcdir} && \
   tar xvjf ${topdir}/${PKG}-core-${VER}.tar.bz2 && \
   if [ -f ${topdir}/${PKG}-ada-${VER}.tar.bz2 ] ; then
     tar xvjf ${topdir}/${PKG}-ada-${VER}.tar.bz2
   fi
   if [ -f ${topdir}/${PKG}-g++-${VER}.tar.bz2 ] ; then
     tar xvjf ${topdir}/${PKG}-g++-${VER}.tar.bz2 
   fi
   if [ -f ${topdir}/${PKG}-g77-${VER}.tar.bz2 ] ; then
     tar xvjf ${topdir}/${PKG}-g77-${VER}.tar.bz2
   fi
   if [ -f ${topdir}/${PKG}-gdc-${VER}.tar.bz2 ] ; then
     tar xvjf ${topdir}/${PKG}-gdc-${VER}.tar.bz2
   fi
   if [ -f ${topdir}/${PKG}-gm2-${VER}.tar.bz2 ] ; then
     tar xvjf ${topdir}/${PKG}-gm2-${VER}.tar.bz2
   fi
   if [ -f ${topdir}/${PKG}-gpc-${VER}.tar.bz2 ] ; then
     tar xvjf ${topdir}/${PKG}-gpc-${VER}.tar.bz2
   fi
   if [ -f ${topdir}/${PKG}-java-${VER}.tar.bz2 ] ; then
     tar xvjf ${topdir}/${PKG}-java-${VER}.tar.bz2
   fi
   if [ -f ${topdir}/${PKG}-objc-${VER}.tar.bz2 ] ; then
     tar xvjf ${topdir}/${PKG}-objc-${VER}.tar.bz2
   fi
   if [ -f ${topdir}/${PKG}-testsuite-${VER}.tar.bz2 ] ; then
     tar xvjf ${topdir}/${PKG}-testsuite-${VER}.tar.bz2
   fi && \
   mv ${PKG}-${VER} ../${PKG}-${VER}-${REL}-orig )
}

prep() {
  (cd ${topdir} && \
  mountpwd && \
  extract && \
  mv ${PKG}-${VER} ${PKG}-${VER}-${REL} && \
  mkdirs && \
  if [ -f ${src_patch_name} ] ; then \
    (cd ${PKG}-${VER}-${REL}; patch -Z -p1<../${src_patch_name}) ;\
  fi )
}

mountpwd() {
  (mount -f -s -o managed ${mount_base} ${mount_target} && \
   mount -f -u -o managed ${mount_base} ${mount_target} )
}
unmount() {
  (umount -s  ${mount_target} && \
   umount -u  ${mount_target} )
}

# configure is interactive when building pascal front end
conf() {
  (# check which front ends are available to build
   if [ -d ${PKG}-${VER}-${REL}/gcc/ada ] ; then
     languages_to_build="${languages_to_build},ada"
   fi
   if [ -d ${PKG}-${VER}-${REL}/gcc/cp ] ; then
     languages_to_build="${languages_to_build},c++"
   fi
   if [ -d ${PKG}-${VER}-${REL}/gcc/d ] ; then
     languages_to_build="${languages_to_build},d"
   fi
   if [ -d ${PKG}-${VER}-${REL}/gcc/f ] ; then
     languages_to_build="${languages_to_build},f77"
   fi
   if [ -d ${PKG}-${VER}-${REL}/gcc/gm2 ] ; then
     languages_to_build="${languages_to_build},gm2"
   fi
   if [ -d ${PKG}-${VER}-${REL}/gcc/java ] ; then
     languages_to_build="${languages_to_build},java"
   fi
   if [ -d ${PKG}-${VER}-${REL}/gcc/objc ] ; then
     languages_to_build="${languages_to_build},objc"
   fi
   if [ -d ${PKG}-${VER}-${REL}/gcc/p ] ; then
     languages_to_build="${languages_to_build},pascal"
   fi
   cd ${objdir} && \
       CFLAGS=${MY_CFLAGS} \
       CXXFLAGS=${MY_CXXFLAGS} \
       LIBCFLAGS=${MY_LIBCFLAGS} \
       LIBCXXFLAGS=${MY_LIBCXXFLAGS} \
       DFLAGS=${MY_DFLAGS} \
       LDFLAGS=${MY_LDFLAGS} \
       JCFLAGS=${MY_JCFLAGS} \
       LIBGCJ_CFLAGS=${MY_LIBGCJ_CFLAGS} \
       LIBGCJ_CXXFLAGS=${MY_LIBGCJ_CXXFLAGS} \
       LIBGCJ_JAVAFLAGS=${MY_LIBGCJ_JAVAFLAGS} \
       GNATLIBCFLAGS=${MY_GNATLIBCFLAGS} \
   ${srcdir}/configure \
	--verbose \
	--prefix=/usr \
	--exec-prefix=/usr \
	--sysconfdir=/etc \
	--libdir=/usr/lib \
	--libexecdir=/usr/lib \
	--mandir=/usr/share/man \
	--infodir=/usr/share/info \
	--enable-languages=${languages_to_build} \
	--enable-nls \
	--without-included-gettext \
	--enable-libgcj \
	--with-system-zlib \
	--enable-interpreter \
	--enable-threads=posix \
	--enable-java-gc=boehm \
	--enable-sjlj-exceptions \
	--disable-version-specific-runtime-libs \
	--disable-win32-registry )
}
reconf() {
  (cd ${topdir} && \
  rm -fr ${objdir} && \
  mkdir -p ${objdir} && \
  conf )
}

build() {
  (cd ${objdir} && \
       CFLAGS=${MY_CFLAGS} \
       CXXFLAGS=${MY_CXXFLAGS} \
       LIBCFLAGS=${MY_LIBCFLAGS} \
       LIBCXXFLAGS=${MY_LIBCXXFLAGS} \
       DFLAGS=${MY_DFLAGS} \
       LDFLAGS=${MY_LDFLAGS} \
       JCFLAGS=${MY_JCFLAGS} \
       LIBGCJ_CFLAGS=${MY_LIBGCJ_CFLAGS} \
       LIBGCJ_CXXFLAGS=${MY_LIBGCJ_CXXFLAGS} \
       LIBGCJ_JAVAFLAGS=${MY_LIBGCJ_JAVAFLAGS} \
       GNATLIBCFLAGS=${MY_GNATLIBCFLAGS} \
   make \
       prefix=${prefix} exec_prefix=${prefix} \
       bindir=${prefix}/bin libexecdir=${prefix}/sbin \
       libdir=${prefix}/lib sysconfdir=/etc \
       includedir=${prefix}/include mandir=${prefix}/share/man \
       infodir=${prefix}/share/info tooldir=${prefix} \
     bootstrap  )
}
build_gnatlib_and_tools() {
  (cd ${objdir}/gcc && \
       CFLAGS=${MY_CFLAGS} \
       LDFLAGS=${MY_LDFLAGS} \
       GNATLIBCFLAGS=${MY_GNATLIBCFLAGS} \
     make \
     gnatlib_and_tools )
}
build_info() {
  (cd ${objdir} && \
     make info )
}

check() {
  (cd ${objdir} && \
   make -k check | tee ${checkfile} 2>&1 )
}

clean() {
  (cd ${objdir} && \
   make clean )
}

install() {
  (cd ${objdir} && \
   make install prefix=${PKG1}${prefix} exec_prefix=${PKG1}${prefix} \
    bindir=${PKG1}${prefix}/bin libexecdir=${PKG1}${prefix}/sbin \
    libdir=${PKG1}${prefix}/lib sysconfdir=${PKG1}/etc \
    includedir=${PKG1}${prefix}/include mandir=${PKG1}${prefix}/share/man \
    infodir=${PKG1}${prefix}/share/info tooldir=${PKG1}${prefix} && \
   make -i install-info prefix=${PKG1}${prefix} exec_prefix=${PKG1}${prefix} \
    bindir=${PKG1}${prefix}/bin libexecdir=${PKG1}${prefix}/sbin \
    libdir=${PKG1}${prefix}/lib sysconfdir=${PKG1}/etc \
    includedir=${PKG1}${prefix}/include mandir=${PKG1}${prefix}/share/man \
    infodir=${PKG1}${prefix}/share/info tooldir=${PKG1}${prefix} )
}
install2() {
  (cd ${objdir} && \
   rm -f ${PKG1}${prefix}/lib/libiberty.a && \
   ( cd ${PKG1}${prefix}/bin && \
    if [ !-f ${target}-gcc-${VER}.exe ] ; then \
      mv -f ${target}-gcc-${VER} ${target}-gcc-${VER}.exe ; \
    fi && \
    rm -f ${target}-c++.exe  && \
    rm -f ${target}-g++.exe && \
    rm -f ${target}-gcc.exe && \
    rm -f ${target}-gdc.exe && \
    ln -sf g77.exe f77.exe && \
    ln -sf gcc.exe cc.exe && \
    ln -sf g++.exe c++.exe && \
    ln -sf gcc.exe ${target}-gcc.exe && \
    ln -sf g++.exe ${target}-c++.exe && \
    ln -sf g++.exe ${target}-g++.exe && \
    ln -sf gdc.exe ${target}-gdc.exe && \
    if [ -f gcj.exe ] ; then \
      rm -f ${target}-gcj.exe && \
      rm -f ${target}-gcjh.exe && \
      ln -sf gcj.exe ${target}-gcj.exe && \
      ln -sf gcjh.exe ${target}-gcjh.exe ; \
    fi ) && \
   ( cd ${PKG1}${prefix}/share/info ; rm -f dir ; gzip -fq9 * ) && \
   ( cd ${PKG1}${prefix}/share/man && \
    gzip -fq9 */* && \
    cd man1 && \
    ln -sf g++.1.gz c++.1.gz && \
    ln -sf g77.1.gz f77.1.gz && \
    ln -sf gcc.1.gz cc.1.gz && \
    cd ${PKG1}${prefix}/share/info && \
    if [ -f fastjar.info.gz ] ; then \
      ln -sf fastjar.info.gz jar.info.gz ; \
    fi ) && \
   ( cd ${srcdir} && \
    mkdir -p ${PKG1}${prefix}/share/doc/Cygwin && cp ${topdir}/gcc-core-${VER}-${REL}.README ${PKG1}${prefix}/share/doc/Cygwin && \
    mkdir -p ${PKG1}${prefix}/share/doc/${PKG}-${VER}-${REL} && \
    cp -a \
      BUGS COPYING COPYING.LIB ChangeLog FAQ INSTALL MAINTAINERS README* *.html \
      ${PKG1}${prefix}/share/doc/${PKG}-${VER}-${REL} && \
    mkdir -p ${PKG1}${prefix}/share/doc/${PKG}-${VER}-${REL}/gcc && \
    mkdir -p ${PKG2}${prefix}/share/doc/${PKG}-${VER}-${REL}/gcc/cp && \
    mkdir -p ${PKG3}${prefix}/share/doc/${PKG}-${VER}-${REL}/gcc/f && \
    mkdir -p ${PKG3}${prefix}/share/doc/Cygwin && cp ${topdir}/gcc-g77-${VER}-${REL}.README ${PKG3}${prefix}/share/doc/Cygwin && \
    mkdir -p ${PKG4}${prefix}/share/doc/${PKG}-${VER}-${REL}/gnat && \
    mkdir -p ${PKG4}${prefix}/share/doc/Cygwin && cp ${topdir}/gcc-ada-${VER}-${REL}.README ${PKG4}${prefix}/share/doc/Cygwin && \
    mkdir -p ${PKG5}${prefix}/share/doc/${PKG}-${VER}-${REL}/gcc/java && \
    mkdir -p ${PKG6}${prefix}/share/doc/${PKG}-${VER}-${REL}/gcc/objc && \
    mkdir -p ${PKG6}${prefix}/share/doc/Cygwin && cp ${topdir}/gcc-objc-${VER}-${REL}.README ${PKG6}${prefix}/share/doc/Cygwin && \
    mkdir -p ${PKG7}${prefix}/share/doc/Cygwin && cp ${topdir}/gcc-gpc-${VER}-${REL}.README ${PKG7}${prefix}/share/doc/Cygwin && \
    if [ -f ${PKG1}${prefix}/bin/gm2.exe ] ; then \
      mkdir -p ${PKG8}${prefix}/share/doc/${PKG}-${VER}-${REL}/gcc/gm2 && \
      mkdir -p ${PKG8}${prefix}/share/doc/Cygwin && cp ${topdir}/gcc-gm2-${VER}-${REL}.README ${PKG8}${prefix}/share/doc/Cygwin ; \
    fi && \
    mkdir -p ${PKG9}${prefix}/share/doc/${PKG}-${VER}-${REL}/gcc/d && \
    mkdir -p ${PKG9}${prefix}/share/doc/Cygwin && cp ${topdir}/gcc-gdc-${VER}-${REL}.README ${PKG9}${prefix}/share/doc/Cygwin && \
    ( cd gcc && \
      cp -a \
        ABOUT* COPYING* LANGUAGES ONEWS README* SERVICE FSF* ChangeLog ChangeLog.cygwin-mingw \
        ${PKG1}${prefix}/share/doc/${PKG}-${VER}-${REL}/gcc && \
      cd f && \
      cp -a \
        BUGS NEWS ChangeLog \
        ${PKG3}${prefix}/share/doc/${PKG}-${VER}-${REL}/gcc/f && \
      cd ../cp && \
      cp -a \
        NEWS ChangeLog \
        ${PKG2}${prefix}/share/doc/${PKG}-${VER}-${REL}/gcc/cp && \
      cd ../java && \
      cp -a \
        ChangeLog \
        ${PKG5}${prefix}/share/doc/${PKG}-${VER}-${REL}/gcc/java && \
      cd ../objc && \
      cp -a \
        README \
        ${PKG6}${prefix}/share/doc/${PKG}-${VER}-${REL}/gcc/objc && \
      cd ../ada && \
      cp -a \
        ChangeLog ChangeLog.cygwin-mingw \
        ${PKG4}${prefix}/share/doc/${PKG}-${VER}-${REL}/gnat && \
      if [ -f ${PKG1}${prefix}/bin/gm2.exe ] ; then \
        cd ../gm2 && \
        cp -a \
          ChangeLog README TODO \
          ${PKG8}${prefix}/share/doc/${PKG}-${VER}-${REL}/gcc/gm2 ; \
      fi && \
      cd ../d && \
      cp -a \
        ChangeLog.pub README INSTALL gpl.txt \
        ${PKG9}${prefix}/share/doc/${PKG}-${VER}-${REL}/gcc/d ) && \
    mkdir -p ${PKG5}${prefix}/share/doc/${PKG}-${VER}-${REL}/fastjar && \
    mkdir -p ${PKG5}${prefix}/share/doc/Cygwin && cp ${topdir}/gcc-java-${VER}-${REL}.README ${PKG5}${prefix}/share/doc/Cygwin && \
    ( cd fastjar && \
      cp -a \
        AUTHORS CHANGES COPYING ChangeLog NEWS README \
        ${PKG5}${prefix}/share/doc/${PKG}-${VER}-${REL}/fastjar  ) && \
    mkdir -p ${PKG3}${prefix}/share/doc/${PKG}-${VER}-${REL}/libf2c && \
    mkdir -p ${PKG3}${prefix}/share/doc/${PKG}-${VER}-${REL}/libf2c/libF77 && \
    mkdir -p ${PKG3}${prefix}/share/doc/${PKG}-${VER}-${REL}/libf2c/libI77 && \
    mkdir -p ${PKG3}${prefix}/share/doc/${PKG}-${VER}-${REL}/libf2c/libU77 && \
    ( cd libf2c && \
      cp -a \
        ChangeLog README TODO disclaimer.netlib permission.netlib readme.netlib \
        ${PKG3}${prefix}/share/doc/${PKG}-${VER}-${REL}/libf2c && \
        ( cd libF77 && \
          cp -a Notice README.netlib \
            ${PKG3}${prefix}/share/doc/${PKG}-${VER}-${REL}/libf2c/libF77 ) && \
        ( cd libI77 && \
          cp -a \
            Notice README.netlib \
            ${PKG3}${prefix}/share/doc/${PKG}-${VER}-${REL}/libf2c/libI77 ) && \
        ( cd libU77 && \
          cp -a \
            COPYING.LIB PROJECTS README \
            ${PKG3}${prefix}/share/doc/${PKG}-${VER}-${REL}/libf2c/libU77 )) && \
    mkdir -p ${PKG5}${prefix}/share/doc/${PKG}-${VER}-${REL}/libjava && \
    mkdir -p ${PKG5}${prefix}/share/doc/${PKG}-${VER}-${REL}/libffi && \
    mkdir -p ${PKG5}${prefix}/share/doc/${PKG}-${VER}-${REL}/boehm-gc && \
    ( cd libjava && \
      cp -a \
        COPYING ChangeLog ChangeLog.cygwin-mingw HACKING LIBGCJ_LICENSE NEWS README THANKS \
        ${PKG5}${prefix}/share/doc/${PKG}-${VER}-${REL}/libjava && \
      cd ../boehm-gc && \
      cp -a \
        ChangeLog ChangeLog.cygwin-mingw doc/* \
        ${PKG5}${prefix}/share/doc/${PKG}-${VER}-${REL}/boehm-gc && \
      cd ../libffi && \
      cp -a \
        ChangeLog ChangeLog.libgcj LICENSE README \
        ${PKG5}${prefix}/share/doc/${PKG}-${VER}-${REL}/libffi  ) && \
    mkdir -p ${PKG6}${prefix}/share/doc/${PKG}-${VER}-${REL}/libobjc && \
    ( cd libobjc && \
      cp -a \
        ChangeLog README README.threads THREADS THREADS.MACH \
        ${PKG6}${prefix}/share/doc/${PKG}-${VER}-${REL}/libobjc ) && \
    mkdir -p ${PKG2}${prefix}/share/doc/${PKG}-${VER}-${REL}/libstdc++-v3 && \
    mkdir -p ${PKG2}${prefix}/share/doc/Cygwin && cp ${topdir}/gcc-g++-${VER}-${REL}.README ${PKG2}${prefix}/share/doc/Cygwin && \
    ( cd libstdc++-v3 && \
      cp -a \
        ChangeLog ChangeLog.cygwin-mingw README \
        ${PKG2}${prefix}/share/doc/${PKG}-${VER}-${REL}/libstdc++-v3 && \
      cp -a \
        docs/html \
        ${PKG2}${prefix}/share/doc/${PKG}-${VER}-${REL}/libstdc++-v3  ) ) && \
    mkdir -p ${PKG7}/usr/share/doc/${PKG}-${VER}-${REL}/ && \
    mv ${PKG1}/usr/doc/gpc ${PKG7}/usr/share/doc/${PKG}-${VER}-${REL}/ && \
    rm -rf ${PKG1}/usr/doc )
}

strip_exe() {
  (cd ${instdir} && \
    find . | xargs file | grep "MS Windows PE 32-bit Intel 80386 console executable not relocatable" | grep 80386 | cut -f 1 -d : | xargs strip --strip-unneeded
    find ${PKG1}/usr/lib/gcc-lib -name "*.a" | xargs strip -g && \
   true )
}

pre_pkg() {
  (cd ${instdir} && \
   ( cd ${PKG1} && \
    for file in `find . -type f -name "*.la"` ; do
      cat $file | sed -e 's%-L/gcc/[[:graph:]]* % %g' > ${TMP}/tmp-la-file
      cat ${TMP}/tmp-la-file > $file
    done && \
    rm ${TMP}/tmp-la-file ) && \
    ( cd ${PKG2} && \
      mkdir -p usr/bin && \
      mv ${PKG1}/usr/bin/*++* usr/bin && \
      mkdir -p usr/include && \
      mv ${PKG1}/usr/include/c++ usr/include && \
      mkdir -p usr/lib && \
      mv ${PKG1}/usr/lib/*++* usr/lib && \
      mkdir -p usr/lib/gcc-lib/${target}/${VER} && \
      mv ${PKG1}/usr/lib/gcc-lib/${target}/${VER}/cc1plus.exe usr/lib/gcc-lib/${target}/${VER} && \
      mkdir -p usr/share/man/man1 && \
      mv ${PKG1}/usr/share/man/man1/*++* usr/share/man/man1 )
    ( cd ${PKG3} && \
      mkdir -p usr/bin && \
      mv ${PKG1}/usr/bin/*77* usr/bin && \
      mkdir -p usr/share/info && \
      mv ${PKG1}/usr/share/info/g77* usr/share/info && \
      mkdir -p usr/lib && \
      mv ${PKG1}/usr/lib/libfrtbegin.a usr/lib && \
      mv ${PKG1}/usr/lib/libg2c* usr/lib && \
      mkdir -p usr/lib/gcc-lib/${target}/${VER}/include && \
      mkdir -p usr/lib/gcc-lib/${target}/${VER} && \
      mv ${PKG1}/usr/lib/gcc-lib/${target}/${VER}/f771.exe usr/lib/gcc-lib/${target}/${VER} && \
      mv ${PKG1}/usr/lib/gcc-lib/${target}/${VER}/include/g2c.h usr/lib/gcc-lib/${target}/${VER}/include && \
      mkdir -p usr/share/man/man1 && \
      mv ${PKG1}/usr/share/man/man1/*77* usr/share/man/man1 )
    ( cd ${PKG4} && \
      mkdir -p usr/bin && \
      mv ${PKG1}/usr/bin/gnat* usr/bin && \
      mkdir -p usr/share/info && \
      mv ${PKG1}/usr/share/info/gnat* usr/share/info && \
      mkdir -p usr/lib/gcc-lib/${target}/${VER} && \
      mkdir -p usr/lib/gcc-lib/${target}/${VER} && \
      mv ${PKG1}/usr/lib/gcc-lib/${target}/${VER}/gnat1.exe usr/lib/gcc-lib/${target}/${VER} && \
      mv ${PKG1}/usr/lib/gcc-lib/${target}/${VER}/adainclude usr/lib/gcc-lib/${target}/${VER} && \
      mv ${PKG1}/usr/lib/gcc-lib/${target}/${VER}/adalib usr/lib/gcc-lib/${target}/${VER} )
    ( cd ${PKG5} && \
      if [ -f ${PKG1}/usr/bin/addr2name.awk ] ; then \
        mkdir -p usr/bin && \
        mv ${PKG1}/usr/bin/addr2name.awk usr/bin && \
        mv ${PKG1}/usr/bin/*gcj* usr/bin && \
        mv ${PKG1}/usr/bin/gij.exe usr/bin && \
        mv ${PKG1}/usr/bin/grepjar.exe usr/bin && \
        mv ${PKG1}/usr/bin/jar.exe usr/bin && \
        mv ${PKG1}/usr/bin/jcf-dump.exe usr/bin && \
        mv ${PKG1}/usr/bin/jv-* usr/bin && \
        mv ${PKG1}/usr/bin/rmi* usr/bin && \
        mkdir -p usr/include && \
        mv ${PKG1}/usr/include/gcj usr/include && \
        mv ${PKG1}/usr/include/gnu usr/include && \
        mv ${PKG1}/usr/include/java usr/include && \
        mv ${PKG1}/usr/include/javax usr/include && \
        mv ${PKG1}/usr/include/jni.h usr/include && \
        mv ${PKG1}/usr/include/jvmpi.h usr/include && \
        mv ${PKG1}/usr/include/ffi.h usr/include && \
        mkdir -p usr/share/info && \
        mv ${PKG1}/usr/share/info/gcj.* usr/share/info && \
        mv ${PKG1}/usr/share/info/fastjar.info.gz usr/share/info && \
        mv ${PKG1}/usr/share/info/jar.info.gz usr/share/info && \
        mkdir -p usr/lib/gcc-lib/${target}/${VER}/include && \
        mv ${PKG1}/usr/lib/libgcj* usr/lib && \
        mv ${PKG1}/usr/lib/libffi* usr/lib && \
        mv ${PKG1}/usr/lib/lib-org* usr/lib && \
        mv ${PKG1}/usr/lib/security usr/lib && \
        mkdir -p usr/lib/gcc-lib/${target}/${VER} && \
        mv ${PKG1}/usr/lib/gcc-lib/${target}/${VER}/jc1.exe usr/lib/gcc-lib/${target}/${VER} && \
        mv ${PKG1}/usr/lib/gcc-lib/${target}/${VER}/jvgenmain.exe usr/lib/gcc-lib/${target}/${VER} && \
        mv ${PKG1}/usr/lib/gcc-lib/${target}/${VER}/include/gcj usr/lib/gcc-lib/${target}/${VER}/include && \
        mkdir -p usr/share/man/man1 && \
        mv ${PKG1}/usr/share/man/man1/gcj.1.gz usr/share/man/man1 && \
        mv ${PKG1}/usr/share/man/man1/gcjh.1.gz usr/share/man/man1 && \
        mv ${PKG1}/usr/share/man/man1/gij.1.gz usr/share/man/man1 && \
        mv ${PKG1}/usr/share/man/man1/grepjar.1.gz usr/share/man/man1 && \
        mv ${PKG1}/usr/share/man/man1/jar.1.gz usr/share/man/man1 && \
        mv ${PKG1}/usr/share/man/man1/jcf-dump.1.gz usr/share/man/man1 && \
        mv ${PKG1}/usr/share/man/man1/jv-convert.1.gz usr/share/man/man1 && \
        mv ${PKG1}/usr/share/man/man1/jv-scan.1.gz usr/share/man/man1 && \
        mv ${PKG1}/usr/share/man/man1/rmic.1.gz usr/share/man/man1 && \
        mv ${PKG1}/usr/share/man/man1/rmiregistry.1.gz usr/share/man/man1 && \
        mv ${PKG1}/usr/share/java usr/share ; \
      fi )
    ( cd ${PKG6} && \
      mkdir -p usr/lib && \
      mv ${PKG1}/usr/lib/libobjc* usr/lib && \
      mkdir -p usr/lib/gcc-lib/${target}/${VER}/include && \
      mkdir -p usr/lib/gcc-lib/${target}/${VER} && \
      mv ${PKG1}/usr/lib/gcc-lib/${target}/${VER}/cc1obj.exe usr/lib/gcc-lib/${target}/${VER} && \
      mv ${PKG1}/usr/lib/gcc-lib/${target}/${VER}/include/objc usr/lib/gcc-lib/${target}/${VER}/include )
    ( cd ${PKG7} && \
      mkdir -p usr/bin && \
      mv ${PKG1}/usr/bin/binobj.exe usr/bin && \
      mv ${PKG1}/usr/bin/gpidump.exe usr/bin && \
      mv ${PKG1}/usr/bin/gpc* usr/bin && \
      mkdir -p usr/lib/gcc-lib/${target}/${VER} && \
      mv ${PKG1}/usr/lib/gcc-lib/${target}/${VER}/*gpc* usr/lib/gcc-lib/${target}/${VER} && \
      mv ${PKG1}/usr/lib/gcc-lib/${target}/${VER}/units usr/lib/gcc-lib/${target}/${VER} && \
      mkdir -p usr/lib/gcc-lib/${target}/${VER}/include && \
      mv ${PKG1}/usr/lib/gcc-lib/${target}/${VER}/include/gpc-in-c.h usr/lib/gcc-lib/${target}/${VER}/include && \
      mkdir -p usr/share/info && \
      mv ${PKG1}/usr/share/info/gpc* usr/share/info && \
      mkdir -p usr/share/man/man1 && \
      mv ${PKG1}/usr/share/man/man1/gp* usr/share/man/man1 )
    if [ -f ${PKG1}${prefix}/bin/gm2.exe ] ; then \
     ( cd ${PKG8} && \
       mkdir -p usr/bin && \
       mv ${PKG1}/usr/bin/gm2.exe usr/bin && \
       mkdir -p usr/lib/gcc-lib/${target}/${VER} && \
       mv ${PKG1}/usr/lib/gcc-lib/${target}/${VER}/*gm2* usr/lib/gcc-lib/${target}/${VER} ) ; \
    fi
    ( cd ${PKG9} && \
      mkdir -p usr/bin && \
      mv ${PKG1}/usr/bin/gdc.exe usr/bin && \
      mv ${PKG1}/usr/bin/i686-pc-cygwin-gdc.exe usr/bin && \
      mv ${PKG1}/usr/bin/dmd usr/bin && \
      mkdir -p usr/lib/gcc-lib/${target}/${VER} && \
      mv ${PKG1}/usr/lib/gcc-lib/${target}/${VER}/cc1d.exe usr/lib/gcc-lib/${target}/${VER} )
    rm -rf ${PKG1}/usr/include )
}

pkg() {
  (cd ${instdir} && \
   ( cd ${PKG1} && \
    ( cd ${PKG1} && \
      tar cjvf ${topdir}/${PKG}-core-${VER}-${REL}.tar.bz2 usr/ \
    )
    ( cd ${PKG2} && \
      if [ -f usr/bin/g++.exe ] ; then \
        tar cjvf ${topdir}/${PKG}-g++-${VER}-${REL}.tar.bz2 usr/ ; \
      fi  \
    )
    ( cd ${PKG3} && \
      if [ -f usr/bin/g77.exe ] ; then \
        tar cjvf ${topdir}/${PKG}-g77-${VER}-${REL}.tar.bz2 usr/ ; \
      fi  \
    )
    ( cd ${PKG4} && \
      if [ -f usr/bin/gnat.exe ] ; then \
        tar cjvf ${topdir}/${PKG}-ada-${VER}-${REL}.tar.bz2 usr/ ; \
      fi  \
    )
    ( cd ${PKG5} && \
      if [ -f usr/bin/gcj.exe ] ; then \
        tar cjvf ${topdir}/${PKG}-java-${VER}-${REL}.tar.bz2 usr/ ; \
      fi  \
    )
    ( cd ${PKG6} && \
      if [ -f usr/lib/gcc-lib/i686-pc-cygwin/3.3.3/cc1obj.exe ] ; then \
        tar cjvf ${topdir}/${PKG}-objc-${VER}-${REL}.tar.bz2 usr/ ; \
      fi  \
    )
    ( cd ${PKG7} && \
      if [ -f usr/bin/gpc.exe ] ; then \
        tar cjvf ${topdir}/${PKG}-gpc-${VER}-${REL}.tar.bz2 usr/ ; \
      fi  \
    )
    ( if [ -f ${PKG8}/usr/bin/gm2.exe ] ; then \
        cd ${PKG8} && \
        tar cjvf ${topdir}/${PKG}-gm2-${VER}-${REL}.tar.bz2 usr/ ; \
      fi  \
    )
    ( cd ${PKG9} && \
      if [ -f usr/bin/gdc.exe ] ; then \
        tar cjvf ${topdir}/${PKG}-gdc-${VER}-${REL}-no-libphobos.tar.bz2 usr/ ; \
      fi  \
    )
  )
 )
}

mkpatch() {
  (cd ${srcdir} && \
  rm -f gcc/d/phobos/lt* && \
  rm -f gcc/d/phobos/config-ml.in && \
  rm -f gcc/d/phobos/boehm-gc && \
  extract_for_patch && \
  cd ${topdir} && \
  (cd ${PKG}-${VER}-${REL}-orig && rm -f gcc/d/phobos/boehm-gc) && \
  diff -urdN -x '.build' -x '.inst' -x '.sinst' -x 'CVS' -x 'MinGW' \
             -x '.brik' -x '.cvsignore' -x 'gcc-2.95.1.diff' \
             -x 'gcc-2.95.2.diff' -x 'gcc-2.95.3-5.diff' \
             -x 'gcc-2.95.3-6.diff' -x 'gcc-2.95.3-8.diff' \
             -x 'gcc-2.95.3.diff' -x 'gcc-2.95.4.diff' \
             -x 'gcc-3.2.2.diff' -x 'gcc-3.2.3.diff' -x 'gcc-3.3.1.diff' \
             -x 'gm2-ebnf.texi' -x 'gm2.info' -x 'gm2.info-1' -x 'gm2.info-2' \
             -x 'gnat_ug_unx.info' -x 'gnat_ug_unx.texi' \
             -x 'gnat_ug_unx.info-1' -x 'gnat_ug_unx.info-2' \
             -x 'gnat_ug_unx.info-3' \
             -x 'gnat_ug_vms.info' -x 'gnat_ug_vms.texi' \
             -x 'gnat_ug_vms.info-1' -x 'gnat_ug_vms.info-2' \
             -x 'gnat_ug_vms.info-3' \
             -x 'gnat_ug_vxw.info' -x 'gnat_ug_vxw.texi' \
             -x 'gnat_ug_vxw.info-1' -x 'gnat_ug_vxw.info-2' \
             -x 'gnat_ug_vxw.info-3' \
             -x 'gnat_ug_wnt.info' -x 'gnat_ug_wnt.texi' \
             -x 'gnat_ug_wnt.info-1' -x 'gnat_ug_wnt.info-2' \
             -x 'gnat_ug_wnt.info-3' \
             -x 'gnat-style.info' -x 'gnat_rm.info' \
             -x 'autom4te.cache' \
    ${PKG}-${VER}-${REL}-orig ${PKG}-${VER}-${REL} > \
    ${srcinstdir}/${src_patch_name} ; \
  rm -rf ${PKG}-${VER}-${REL}-orig  )
}

spkg() {
  (mkpatch && \
  cp -f ${srcinstdir}/${src_patch_name} ./${src_patch_name} && \
  cp ${all_source_packages} ${srcinstdir}/ && \
  cp $0 ${srcinstdir}/`basename $0` && \
  cp ${PKG}-*-${VER}-${REL}.README ${srcinstdir} && \
  cd ${srcinstdir} && \
  tar cjvf ${topdir}/${PKG}-all-${VER}-${REL}-src.tar.bz2 \
      ${all_source_packages} \
      `basename $0` \
      ${src_patch_name} \
      *.README && \
  tar cjvf ${topdir}/${PKG}-ada-${VER}-${REL}-src.tar.bz2 \
      ${PKG}-ada-${VER}.tar.bz2 \
      ${PKG}-ada-${VER}-${REL}.README && \
  tar cjvf ${topdir}/${PKG}-g++-${VER}-${REL}-src.tar.bz2 \
      ${PKG}-g++-${VER}.tar.bz2 \
      ${PKG}-g++-${VER}-${REL}.README && \
  tar cjvf ${topdir}/${PKG}-g77-${VER}-${REL}-src.tar.bz2 \
      ${PKG}-g77-${VER}.tar.bz2 \
      ${PKG}-g77-${VER}-${REL}.README && \
  tar cjvf ${topdir}/${PKG}-gpc-${VER}-${REL}-src.tar.bz2 \
      ${PKG}-gpc-${VER}.tar.bz2 \
      ${PKG}-gpc-${VER}-${REL}.README && \
  if [ -f ${PKG}-gm2-${VER}.tar.bz2 ] ; then \
      tar cjvf ${topdir}/${PKG}-gm2-${VER}-${REL}-src.tar.bz2 \
          ${PKG}-gm2-${VER}.tar.bz2 \
          ${PKG}-gm2-${VER}-${REL}.README ; \
  fi && \
  tar cjvf ${topdir}/${PKG}-gdc-${VER}-${REL}-src.tar.bz2 \
      ${PKG}-gdc-${VER}.tar.bz2 \
      ${PKG}-gdc-${VER}-${REL}.README && \
  tar cjvf ${topdir}/${PKG}-java-${VER}-${REL}-src.tar.bz2 \
      ${PKG}-java-${VER}.tar.bz2 \
      ${PKG}-java-${VER}-${REL}.README && \
  tar cjvf ${topdir}/${PKG}-objc-${VER}-${REL}-src.tar.bz2 \
      ${PKG}-objc-${VER}.tar.bz2 \
      ${PKG}-objc-${VER}-${REL}.README && \
  tar cjvf ${topdir}/${PKG}-testsuite-${VER}-${REL}-src.tar.bz2 \
      ${PKG}-testsuite-${VER}.tar.bz2 && \
  tar cjvf ${topdir}/${PKG}-core-${VER}-${REL}-src.tar.bz2 \
      ${PKG}-core-${VER}.tar.bz2 \
      `basename $0` \
      ${src_patch_name} \
      ${PKG}-core-${VER}-${REL}.README  )
}

finish() {
  (rm -rf ${srcdir} && \
   unmount )
}

# run the four libphobos targets after the new gcc is installed 
# in the system to get the libphobos runtime package
libphobos_conf() {
  (mkdir -p ${objdir}/gcc/d/phobos && \
   cd ${srcdir}/gcc/d/phobos && \
   sh ./prepcygwin.sh && \
   cd ${objdir}/gcc/d/phobos && \
   DFLAGS="${MY_DFLAGS}" \
   ${srcdir}/gcc/d/phobos/configure \
     	--verbose \
     	--prefix=/usr \
     	--exec-prefix=/usr \
     	--sysconfdir=/etc \
     	--libdir=/usr/lib \
     	--libexecdir=/usr/lib \
     	--mandir=/usr/share/man \
     	--infodir=/usr/share/info \
     	--with-system-zlib )
}
libphobos_build() {
  (cd ${objdir}/gcc/d/phobos && \
       CFLAGS="${MY_CFLAGS}" \
       CXXFLAGS="${MY_CFLAGS}" \
   make )
}
libphobos_clean() {
  (cd ${objdir}/gcc/d/phobos && \
   make clean )
}
libphobos_install() {
  (cd ${objdir}/gcc/d/phobos && \
    make install prefix=${PKG9}${prefix} exec_prefix=${PKG9}${prefix} \
    bindir=${PKG9}${prefix}/bin libexecdir=${PKG9}${prefix}/sbin \
    libdir=${PKG9}${prefix}/lib sysconfdir=${PKG9}/etc \
    includedir=${PKG9}${prefix}/include mandir=${PKG9}${prefix}/share/man \
    infodir=${PKG9}${prefix}/share/info tooldir=${PKG9}${prefix} )
}
libphobos_pkg() {
    ( cd ${PKG9} && \
      tar cjvf ${topdir}/${PKG}-gdc-${VER}-${REL}.tar.bz2 usr/   \
    )
}

depend() {
  (cd ${instdir} && \
  find ${instdir} -name "*.exe" -o -name "*.dll" | xargs cygcheck | \
  sed -e '/\.exe/d' -e 's,\\,/,g' | sort -bu | xargs -n1 cygpath -u \
  | xargs cygcheck -f | sed 's%^%  %' ; \
  true )
}

case $1 in
  build)	build ; STATUS=$? ;;
  build_gnatlib_and_tools)	build_gnatlib_and_tools ; STATUS=$? ;;
  build_info)	build_info ; STATUS=$? ;;
  check)	check ; STATUS=$? ;;
  clean)	clean ; STATUS=$? ;;
  conf*)	conf ; STATUS=$? ;;
  depend)	depend ; STATUS=$? ;;
  extract)	extract ; STATUS=$? ;;
  finish) 	finish ; STATUS=$? ;;
  install)	install ; STATUS=$? ;;
  install2)	install2 ; STATUS=$? ;;
  make)		build ; STATUS=$? ;;
  mkdirs)	mkdirs; STATUS=$? ;;
  mkpatch)	mkpatch ; STATUS=$? ;;
  package)	pkg ; STATUS=$? ;;
  pkg)		pkg ; STATUS=$? ;;
  pre_pkg)	pre_pkg ; STATUS=$? ;;
  prep*)	prep ; STATUS=$? ;;
  reconf)	reconf ; STATUS=$? ;;
  spkg)		spkg ; STATUS=$? ;;
  strip*)	strip_exe ; STATUS=$? ;;
  mount*)	mount ; STATUS=$? ;;
  umount)	unmount ; STATUS=$? ;;
  unmount)	unmount ; STATUS=$? ;;
  libphobos_conf)	libphobos_conf ; STATUS=$? ;;
  libphobos_build)	libphobos_build ; STATUS=$? ;;
  libphobos_clean)	libphobos_clean ; STATUS=$? ;;
  libphobos_install)	libphobos_install ; STATUS=$? ;;
  libphobos_pkg) libphobos_pkg ; STATUS=$? ;;
  all) build && build_gnatlib_and_tools && \
       build_info && install && strip_exe && install2 && \
       pre_pkg && pkg && spkg ; \
	  STATUS=$? ;;
  *) echo "Error: bad arguments" ; exit 1 ;;
esac
exit ${STATUS}

