/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.xalan;

import com.nwalsh.xalan.Callout;
import com.nwalsh.xalan.FormatCallout;
import org.apache.xml.utils.DOMBuilder;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class FormatUnicodeCallout
extends FormatCallout {
    int unicodeMax = 0;
    int unicodeStart = 0;
    String unicodeFont = "";

    public FormatUnicodeCallout(String font, int start, int max, boolean fo) {
        this.unicodeFont = font;
        this.unicodeMax = max;
        this.unicodeStart = start;
        this.stylesheetFO = fo;
    }

    public void formatCallout(DOMBuilder rtf, Callout callout) {
        Element area = callout.getArea();
        int num = callout.getCallout();
        String label = this.areaLabel(area);
        try {
            if (label == null && num <= this.unicodeMax) {
                AttributesImpl inAttr = new AttributesImpl();
                String ns = "";
                String prefix = "";
                String inName = "";
                if (!this.unicodeFont.equals("")) {
                    if (this.stylesheetFO) {
                        ns = "http://www.w3.org/1999/XSL/Format";
                        prefix = "fo:";
                        inName = "inline";
                        inAttr.addAttribute("", "", "font-family", "CDATA", this.unicodeFont);
                    } else {
                        inName = "font";
                        inAttr.addAttribute("", "", "face", "CDATA", this.unicodeFont);
                    }
                }
                char[] chars = new char[]{(char)(this.unicodeStart + num - 1)};
                this.startSpan(rtf);
                if (!this.unicodeFont.equals("")) {
                    rtf.startElement(ns, inName, prefix + inName, (Attributes)inAttr);
                }
                rtf.characters(chars, 0, 1);
                if (!this.unicodeFont.equals("")) {
                    rtf.endElement(ns, inName, prefix + inName);
                }
                this.endSpan(rtf);
            } else {
                this.formatTextCallout(rtf, callout);
            }
        }
        catch (SAXException e) {
            System.out.println("SAX Exception in unicode formatCallout");
        }
    }
}

