#if !defined(__path_hpp__)
#define __path_hpp__



//-----------------------------------------------------------------------------
class path {
public:
	path();
	path(const string& src);
	path(const char* src);
	path(const string srcdir, const string srcname);
	path(const string srcdir, const string srcname, const string srcext);

	path(const char* srcdir, const char* srcname, const char* srcext);
	path(const char* srcdir, const char* srcname);

	string full() const;
	string dir() const;
	string name() const;
	string name_ext() const;
	string ext() const;

	path& operator= (const path& rhs);
	path& operator= (const string& rhs);
	path& operator= (const char* rhs);

	bool operator< (const path& rhs);
	bool operator< (const string& rhs);
	bool operator< (const char* rhs);

	bool operator> (const path& rhs);
	bool operator> (const string& rhs);
	bool operator> (const char* rhs);

	bool operator== (const path& rhs);
	bool operator== (const string& rhs);
	bool operator== (const char* rhs);

protected:
	string get_home_dir();
	string get_cw_dir();
	void normalize_auxillary(const char* source_string);
	void normalize(const string& src);
	void normalize(const char* src);

	string fdir;
	string fname;
	string fext;
};



#endif /* !defined(__path_hpp__) */
