#!/bin/sh
# find out where the build script is located
tdir=`echo "$0" | sed 's%[\\/][^\\/][^\\/]*$%%'`
test "x$tdir" = "x$0" && tdir=.
scriptdir=`cd $tdir; pwd`
# find src directory.  
# If scriptdir ends in SPECS, then topdir is $scriptdir/.. 
# If scriptdir ends in CYGWIN-PATCHES, then topdir is $scriptdir/../..
# Otherwise, we assume that topdir = scriptdir
topdir1=`echo ${scriptdir} | sed 's%/SPECS$%%'`
topdir2=`echo ${scriptdir} | sed 's%/CYGWIN-PATCHES$%%'`
if [ "x$topdir1" != "x$scriptdir" ] ; then # SPECS
  topdir=`cd ${scriptdir}/..; pwd`
else
  if [ "x$topdir2" != "x$scriptdir" ] ; then # CYGWIN-PATCHES
    topdir=`cd ${scriptdir}/../..; pwd`
  else
    topdir=`cd ${scriptdir}; pwd`
  fi
fi

tscriptname=`basename $0 .sh`
export PKG=`echo $tscriptname | sed -e 's/\-[^\-]*\-[^\-]*$//'`
export VER=`echo $tscriptname | sed -e "s/${PKG}\-//" -e 's/\-[^\-]*$//'`
export REL=`echo $tscriptname | sed -e "s/${PKG}\-${VER}\-//"`
export FULLPKG=${PKG}-${VER}-${REL}

# determine correct decompression option and tarball filename
if [ -e ${PKG}-${VER}.tar.gz ] ; then
  export opt_decomp=z
  export src_orig_pkg_ext=gz
elif [ -e ${PKG}-${VER}.tar.bz2 ] ; then
  export opt_decomp=j
  export src_orig_pkg_ext=bz2
fi

export src_orig_pkg_name=${PKG}-${VER}.tar.${src_orig_pkg_ext}
export src_pkg_name=${FULLPKG}-src.tar.bz2
export src_patch_name=${FULLPKG}.patch
export src_patch_name2=${FULLPKG}.new
export bin_pkg_name=${FULLPKG}.tar.bz2

export src_orig_pkg=${topdir}/${src_orig_pkg_name}
export src_pkg=${topdir}/${src_pkg_name}
export src_patch=${topdir}/${src_patch_name}
export src_patch2=${topdir}/${src_patch_name2}
export bin_pkg=${topdir}/${bin_pkg_name}
export srcdir=${topdir}/${PKG}-${VER}
export objdir=${srcdir}/.build
export instdir=${srcdir}/.inst
export srcinstdir=${srcdir}/.sinst
export checkfile=${topdir}/${FULLPKG}.check
# run on
host=i686-pc-cygwin
# if this package creates binaries, they run on
target=i686-pc-cygwin
prefix=/usr
sysconfdir=/etc
MY_CFLAGS="-O2 -g"
MY_LDFLAGS=

mkdirs() {
  (cd ${topdir} && \
  rm -fr ${objdir} ${instdir} ${srcinstdir} && \
  mkdir -p ${objdir} && \
  mkdir -p ${instdir} && \
  mkdir -p ${srcinstdir}
)}

patchit() {
  thedir=$1
  (cd ${thedir}             && \
  patch -p1 < ${src_patch}
)}

fixup() {
  thedir=$1
  (cd ${thedir}             && \
  aclocal
  automake --copy
  autoheader
  autoconf
)}

prep() {
  (cd ${topdir} && \
  tar xv${opt_decomp}f ${src_orig_pkg} ; \
  patchit ${srcdir}
  fixup ${srcdir}
  cd ${topdir} && \
#  patch -p0 < ${src_patch2} 
  mkdirs
)}

conf() {
  (cd ${objdir} && \
  CFLAGS="${MY_CFLAGS}" LDFLAGS="${MY_LDFLAGS}" \
  ${srcdir}/configure --target=${target} \
  --srcdir=${srcdir} --prefix=${prefix} \
  --exec-prefix=${prefix} --sysconfdir=${sysconfdir} \
  --libdir=${prefix}/lib --includedir=${prefix}/include \
  --mandir=${prefix}/share/man --infodir=${prefix}/share/info \
  --libexecdir='${sbindir}' --localstatedir=/var \
  --datadir='${prefix}/share' \
  --with-gdbm --with-tmpdir=/tmp --without-krb4 --without-gssapi \
#  --with-cvs-admin-group=Administrators
)}

build() {
  (cd ${objdir} && \
  CFLAGS="${MY_CFLAGS}" make
)}

check() {
  (cd ${objdir} && \
  make SHELL="/bin/bash" check | tee ${checkfile} 2>&1 ;
  echo "" >> ${checkfile} 
  echo "---- THE ACTUAL LOG ----" >> ${checkfile}
  echo "" >> ${checkfile}
  cat ${objdir}/src/check.log >> ${checkfile}
)}

clean() {
  (cd ${objdir} && \
  make clean
)}

install() {
  (cd ${objdir} && \
  make install DESTDIR=${instdir} || exit 1
  if [ -f ${instdir}${prefix}/share/info/dir ] ; then \
    rm ${instdir}${prefix}/share/info/dir ; \
  fi && \
  if [ ! -d ${instdir}${prefix}/share/doc/${PKG}-${VER} ]; then \
    mkdir -p ${instdir}${prefix}/share/doc/${PKG}-${VER} ; \
  fi && \
  if [ ! -d ${instdir}${prefix}/share/doc/Cygwin ]; then \
    mkdir -p ${instdir}${prefix}/share/doc/Cygwin ; \
  fi && \
  templist=""; \
  for f in ${srcdir}/NEWS ${srcdir}/README ${srcdir}/FAQ \
           ${srcdir}/MINOR-BUGS ${srcdir}/COPYING ${srcdir}/COPYING.LIB \
           ${srcdir}/BUGS ${srcdir}/AUTHORS \
           ${srcdir}/HACKING ${srcdir}/PROJECTS ${srcdir}/TODO ; do \
    if [ -f $f ] ; then \
      templist="$templist $f"; \
    fi ; \
  done && \
  if [ ! "x$templist" = "x" ]; then \
    /usr/bin/install -m 644 $templist \
         ${instdir}${prefix}/share/doc/${PKG}-${VER} ;
  fi && \
  if [ -f ${srcdir}/CYGWIN-PATCHES/${PKG}.README ]; then \
    /usr/bin/install -m 644 ${srcdir}/CYGWIN-PATCHES/${PKG}.README \
      ${instdir}${prefix}/share/doc/Cygwin/${PKG}-${VER}.README ; \
  fi
)}

strip() {
  (cd ${instdir} && \
  find . -name "*.dll" | xargs strip > /dev/null 2>&1
  find . -name "*.exe" | xargs strip > /dev/null 2>&1
  true
)}

pkg() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg} *
)}

mkpatch() {
  (cd ${srcdir} && \
  tar xv${opt_decomp}f ${src_orig_pkg} ;\
  mv ${PKG}-${VER} ../${PKG}-${VER}-orig && \
  temp=`(cd ../${PKG}-${VER}-orig ; pwd)` && \
#  patchit $temp
#  fixup $temp
  cd $temp && \
  cd ${topdir} && \
  diff -urN -x '.build' -x '.inst' -x '.sinst' -x '*~' \
    -x 'autom4te.cache' -x 'aclocal.m4' -x 'Makefile.in' -x '*~' \
    -x 'config.h.in' -x '*.rej' -x '*.orig' \
    -x 'configure' -x 'Makefile' -x 'stamp-h1' \
    -x 'install-sh' -x 'missing' -x 'mkinstalldirs' \
    -x 'config.h' -x 'config.log' -x 'config.status' \
    ${PKG}-${VER}-orig ${PKG}-${VER} > \
    ${topdir}/${src_patch_name2} ; \
  rm -rf ${PKG}-${VER}-orig
)}

spkg() {
  (mkpatch ;\
  cp ${src_patch} ${srcinstdir}/${src_patch_name} && \
  cp ${src_orig_pkg} ${srcinstdir}/${src_orig_pkg_name} && \
  cp $0 ${srcinstdir}/`basename $0` && \
  cd ${srcinstdir} && \
  tar cvjf ${src_pkg} *
)}

finish() {
  rm -rf ${srcdir} 
}

check-local-pass() {
  (cd ${objdir}/src 
        # Basic/miscellaneous functionality
        tests="version basica basicb basicc basic1 deep basic2"
        tests="${tests} parseroot files spacefiles commit-readonly"
        tests="${tests} commit-add-missing"
        tests="${tests} status"
        # Branching, tagging, removing, adding, multiple directories
        tests="${tests} rdiff rdiff-short"
        tests="${tests} rdiff2 diff diffnl death death2"
        tests="${tests} rm-update-message rmadd rmadd2 rmadd3 resurrection"
        tests="${tests} dirs dirs2 branches branches2 tagc tagf"
        tests="${tests} rcslib multibranch import importb importc import-CVS"
        tests="${tests} update-p import-after-initial branch-after-import"
        tests="${tests} join join2 join3 join4 join5 join6"
        tests="${tests} join-readonly-conflict join-admin join-admin-2"
        tests="${tests} join-rm"
        tests="${tests} new newb conflicts conflicts2 conflicts3"
        tests="${tests} clean"
        # Checking out various places (modules, checkout -d, &c)
        tests="${tests} modules modules2 modules3 modules4 modules5"
        tests="${tests} mkmodules co-d"
        tests="${tests} cvsadm emptydir abspath abspath2 toplevel toplevel2"
        tests="${tests} rstar-toplevel trailingslashes checkout_repository"
        # Log messages, error messages.
        tests="${tests} mflag editor errmsg1 errmsg2 adderrmsg opterrmsg"
        # Watches, binary files, history browsing, &c.
        tests="${tests} devcom devcom2 devcom3 watch4 watch5"
        tests="${tests} unedit-without-baserev"
        tests="${tests} ignore ignore-on-branch binfiles binfiles2 binfiles3"
        tests="${tests} mcopy binwrap binwrap2"
        tests="${tests} binwrap3 mwrap info taginfo config"
        tests="${tests} serverpatch log log2 logopt ann ann-id"
        # Repository Storage (RCS file format, CVS lock files, creating
        # a repository without "cvs init", &c).
        tests="${tests} crerepos rcs rcs2 rcs3 lockfiles backuprecover"
        # More history browsing, &c.
        tests="${tests} history"
        tests="${tests} big modes modes2 modes3 stamps"
        # PreservePermissions stuff: permissions, symlinks et al.
        # tests="${tests} perms symlinks symlinks2 hardlinks"
        # More tag and branch tests, keywords.
        tests="${tests} sticky keyword keywordlog keywordname keyword2"
        tests="${tests} head tagdate multibranch2 tag8k"
        # "cvs admin", reserved checkouts.
        tests="${tests} admin reserved"
        # Nuts and bolts of diffing/merging (diff library, &c)
        tests="${tests} diffmerge1 diffmerge2"
        # Release of multiple directories
        tests="${tests} release"
        tests="${tests} recase"
        # Multiple root directories and low-level protocol tests.
        tests="${tests} multiroot multiroot2 multiroot3 multiroot4"
        tests="${tests} rmroot reposmv pserver server server2 client"
        tests="${tests} dottedroot fork commit-d"
   /bin/bash ${srcdir}/src/sanity.sh ${objdir}/src/cvs ${tests} |\
     tee ${checkfile} 2>&1
   cp ${objdir}/src/check.log ${checkfile}.localpass
)}

check-remote-pass() {
  (cd ${objdir}/src 
        # Basic/miscellaneous functionality
        tests="version basica basicb basicc basic1 deep basic2"
        tests="${tests} parseroot files spacefiles commit-readonly"
        tests="${tests} commit-add-missing"
        tests="${tests} status"
        # Branching, tagging, removing, adding, multiple directories
        tests="${tests} rdiff rdiff-short"
        tests="${tests} rdiff2 diff diffnl death death2"
        tests="${tests} rm-update-message rmadd rmadd2 rmadd3 resurrection"
        tests="${tests} dirs dirs2 branches branches2 tagc tagf"
        tests="${tests} rcslib multibranch import importb importc import-CVS"
        tests="${tests} update-p import-after-initial branch-after-import"
        tests="${tests} join join2 join3 join4 join5 join6"
        tests="${tests} join-readonly-conflict join-admin join-admin-2"
        tests="${tests} join-rm"
        tests="${tests} new newb conflicts conflicts2 conflicts3"
        tests="${tests} clean"
        # Checking out various places (modules, checkout -d, &c)
        tests="${tests} modules2 modules3 modules4 modules5"
        tests="${tests} mkmodules co-d"
        tests="${tests} cvsadm emptydir abspath abspath2 toplevel toplevel2"
        tests="${tests} rstar-toplevel trailingslashes checkout_repository"
        # Log messages, error messages.
        tests="${tests} mflag editor errmsg1 errmsg2 adderrmsg opterrmsg"
        # Watches, binary files, history browsing, &c.
        tests="${tests} devcom devcom2 devcom3 watch4 watch5"
        tests="${tests} unedit-without-baserev"
        tests="${tests} ignore ignore-on-branch binfiles binfiles2 binfiles3"
        tests="${tests} mcopy binwrap binwrap2"
        tests="${tests} binwrap3 mwrap info taginfo config"
        tests="${tests} serverpatch log log2 logopt ann ann-id"
        # Repository Storage (RCS file format, CVS lock files, creating
        # a repository without "cvs init", &c).
        tests="${tests} rcs rcs2 rcs3 lockfiles backuprecover"
        # More history browsing, &c.
        tests="${tests} history"
        tests="${tests} big modes modes2 modes3 stamps"
        # PreservePermissions stuff: permissions, symlinks et al.
        # tests="${tests} perms symlinks symlinks2 hardlinks"
        # More tag and branch tests, keywords.
        tests="${tests} sticky keyword keywordlog keywordname keyword2"
        tests="${tests} head tagdate multibranch2 tag8k"
        # "cvs admin", reserved checkouts.
        tests="${tests} admin reserved"
        # Nuts and bolts of diffing/merging (diff library, &c)
        tests="${tests} diffmerge1 diffmerge2"
        # Release of multiple directories
        tests="${tests} release"
        tests="${tests} recase"
        # Multiple root directories and low-level protocol tests.
        tests="${tests} multiroot multiroot2 multiroot3 multiroot4"
        tests="${tests} rmroot reposmv server server2 client"
        tests="${tests} dottedroot fork commit-d"
   /bin/bash ${srcdir}/src/sanity.sh -r ${objdir}/src/cvs ${tests} |\
     tee ${checkfile} 2>&1
   cp ${objdir}/src/check.log ${checkfile}.remotepass
)}

check-local-fail() {
  (cd ${objdir}/src 
   tests="         modules6"
   rm -f ${checkfile}.localfail
   rm -f ${checkfile}
   for test in ${tests} ; do
     /bin/bash ${srcdir}/src/sanity.sh ${objdir}/src/cvs ${test} |\
       tee -a ${checkfile} 2>&1 ;
     echo "" >> ${checkfile}.localfail
     echo "---- ${test} ----" >> ${checkfile}.localfail
     echo "" >> ${checkfile}.localfail
     cat ${objdir}/src/check.log >> ${checkfile}.localfail
   done
)}

check-remote-fail() {
  (cd ${objdir}/src 
   tests="         modules"
   tests="${tests} modules6"
   tests="${tests} crerepos"
   tests="${tests} pserver"
   rm -f ${checkfile}.remotefail
   rm -f ${checkfile}
   for test in ${tests} ; do
     /bin/bash ${srcdir}/src/sanity.sh -r ${objdir}/src/cvs ${test} |\
       tee -a ${checkfile} 2>&1 ;
     echo "" >> ${checkfile}.remotefail
     echo "---- ${test} ----" >> ${checkfile}.remotefail
     echo "" >> ${checkfile}.remotefail
     cat ${objdir}/src/check.log >> ${checkfile}.remotefail
   done
)}


case $1 in
  prep)	prep ; STATUS=$? ;;
  mkdirs)	mkdirs; STATUS=$? ;;
  conf)	conf ; STATUS=$? ;;
  build)	build ; STATUS=$? ;;
  check)	check ; STATUS=$? ;;
  check-local-pass)	check-local-pass ; STATUS=$? ;;
  check-remote-pass)	check-remote-pass ; STATUS=$? ;;
  check-local-fail)	check-local-fail ; STATUS=$? ;;
  check-remote-fail)	check-remote-fail ; STATUS=$? ;;
  clean)	clean ; STATUS=$? ;;
  install)	install ; STATUS=$? ;;
  strip)	strip ; STATUS=$? ;;
  package)	pkg ; STATUS=$? ;;
  pkg)	pkg ; STATUS=$? ;;
  mkpatch)	mkpatch ; STATUS=$? ;;
  src-package)	spkg ; STATUS=$? ;;
  spkg)	spkg ; STATUS=$? ;;
  finish) finish ; STATUS=$? ;;
  all) prep && conf && build && install && \
     strip && pkg && spkg && finish ; \
     STATUS=$? ;;
  *) echo "Error: bad arguments" ; exit 1 ;;
esac
exit ${STATUS}
