//@copyright_begin
// ================================================================
// Copyright Notice
// Copyright (C) 1998-2004 by Joe Linoff
// 
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL JOE LINOFF BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.
// 
// Comments and suggestions are always welcome.
// Please report bugs to http://ccdoc.sourceforge.net/ccdoc
// ================================================================
//@copyright_end
#include "phase1.h"
#include "phase1_file.h"

// ================================================================
// This variable allows the header version
// to be queried at runtime.
// ================================================================
namespace {
  char ccdoc_rcsid[] = "$Id: phase1_run.cc,v 1.6 2004/09/30 04:16:07 jlinoff Exp $";

}
// ================================================================
// Run
// ================================================================
bool ccdoc::phase1::run(switches& sw,
			database& db)
{
  if(sw.verbose()) {
    s_log << "phase1: begins\n";
  }
  bool debug = false;
  if( ::getenv("CCDOC_PHASE1_DEBUG") ) {
    debug = true;
  }

  // Walk through all of the files specified on
  // the command line.
  switches::files_type files;
  sw.files(files);
  switches::files_type::iterator itr = files.begin();
  for(;itr!=files.end();++itr) {
    phase1::file f(sw,db,*itr);
    f.set_debug(debug);
    f.compile();
  }

  if(sw.verbose()) {
    s_log << "phase1: ends\n";
  }

  return s_log.errors() == 0;
}
