#!/bin/sh
# This script will create symbolic links to the versioned 
# binaries, with unversioned names.  By default,
# it takes action ONLY if the version number encoded below, 
# in MYVERSION, is greater or equal to the largest version 
# number of an installed library from the same family -- 
# or if the '--force' option is given.
#
prefix=/usr/autotool/devel
bindir=${prefix}/bin
datadir=${prefix}/share
sysbindir=/usr/bin
NAME=automake-devel-1.9.2
TESTRUN=/bin/false

do_family() {
  (echo cd $sysbindir
   $TESTRUN || cd $sysbindir

   echo rm -f automake-$1 
   $TESTRUN || rm -f automake-$1

   echo rm -f aclocal-$1
   $TESTRUN || rm -f aclocal-$1

   echo ln -fs $bindir/automake-$1 automake-$1
   $TESTRUN || ln -fs $bindir/automake-$1 automake-$1

   echo ln -fs $bindir/aclocal-$1  aclocal-$1
   $TESTRUN || ln -fs $bindir/aclocal-$1  aclocal-$1
  )
}

do_core() {
  (echo cd $bindir
   $TESTRUN || cd $bindir

   echo rm -f automake
   $TESTRUN || rm -f automake

   echo rm -f aclocal
   $TESTRUN || rm -f aclocal

   echo ln -fs automake-$1 automake
   $TESTRUN || ln -fs automake-$1 automake

   echo ln -fs aclocal-$1  aclocal
   $TESTRUN || ln -fs aclocal-$1  aclocal
  )
  (echo cd ${datadir}/aclocal
   $TESTRUN || cd ${datadir}/aclocal

   echo rm -f dirlist
   $TESTRUN || rm -f dirlist

   echo Creating dirlist...
   $TESTRUN || echo /usr/share/aclocal > dirlist
  )
}

findver() {
  echo $1 | sed -n -e 's/^[^0-9]*\-\([0-9\.\-]*\)$/\1/p'
}
findfamily() {
  echo $1 | sed -n -e 's/^[^0-9]*\-\([0-9]*\)\.\([0-9]*\)\.\([0-9]*\)$/\1.\2/p'
}
nover() {
  echo $1 | sed -n -e 's/^\([^0-9]*\)-[0-9\.\-]*$/\1/p'
}

compute_number() {
  if [ -z "$1" ]; then
    echo 0
    return
  fi
  PKG=`echo $1 | sed -e 's,\-[^\-]*$,,'`
  VER=`echo $1 | sed -n -e "s,${PKG}\-,,p"`
  major=`echo $VER | sed -n -e 's,^\([0-9]*\)[0-9\.]*$,\1,p'`
  minor=`echo $VER | sed -n -e "s,^$major\.\([0-9]*\)[0-9\.]*$,\1,p"`
  micro=`echo $VER | sed -n -e "s,^$major\.$minor\.\([0-9]*\)$,\1,p"`
  if [ -z "$micro" ] ; then
    micro=0;
  fi
  number=`expr $major "*" 10000 "+" $minor "*" 100 "+" $micro`
  echo $number
}

installed_maxver() {
  maxVER=
  maxNUM=
  for fn in "$@" ; do
    if [ -e $fn ] ; then
      bignum=`compute_number $fn`
      ver=`findver $fn`
      if [ -n "$ver" ] ; then
        if [ -z "$maxVER" ] ; then
          maxVER=$ver
          maxNUM=$bignum
        elif [ $bignum -gt $maxNUM ] ; then
          maxVER=$ver
          maxNUM=$bignum
        fi
      fi
    fi
  done
  echo $maxVER
}

doREPLACEforFamily="no"
doREPLACEforPackage="no"
myVERSION=`findver $NAME`
myPACKAGE=`nover $NAME`
myFAMILY=`findfamily $NAME`
maxVER_for_PACKAGE=`installed_maxver ${prefix}/bin/automake-*`

if [ -z $maxVER_for_PACKAGE ] ; then
  doREPLACE="yes"
elif [ "x$1" = "x--force" ] ; then
  doREPLACE="yes"
else
  myNUM=`compute_number automake-$myVERSION`
  maxNUM=`compute_number automake-$maxVER_for_PACKAGE`
  if [ $myNUM -ge $maxNUM ] ; then
    doREPLACE="yes"
  fi
fi

do_family $myFAMILY

if [ "x$doREPLACE" = "xyes" ] ; then
  do_core $myFAMILY
fi

