#!/bin/sh
# find out where the build script is located
tdir=`echo "$0" | sed 's%[\\/][^\\/][^\\/]*$%%'`
test "x$tdir" = "x$0" && tdir=.
scriptdir=`cd $tdir; pwd`
# find src directory.  
# If scriptdir ends in SPECS, then topdir is $scriptdir/.. 
# If scriptdir ends in CYGWIN-PATCHES, then topdir is $scriptdir/../..
# Otherwise, we assume that topdir = scriptdir
topdir1=`echo ${scriptdir} | sed 's%/SPECS$%%'`
topdir2=`echo ${scriptdir} | sed 's%/CYGWIN-PATCHES$%%'`
if [ "x$topdir1" != "x$scriptdir" ] ; then # SPECS
  topdir=`cd ${scriptdir}/..; pwd`
else
  if [ "x$topdir2" != "x$scriptdir" ] ; then # CYGWIN-PATCHES
    topdir=`cd ${scriptdir}/../..; pwd`
  else
    topdir=`cd ${scriptdir}; pwd`
  fi
fi

export PKG=autoconf
export VER=2.57a
export REL=1
export FULLPKG=${PKG}-${VER}-${REL}

# determine correct decompression option and tarball filename
if [ -e autoconf-wrapper-${VER}.tar.gz ] ; then
  export opt_decomp=z
  export src_orig_pkg_ext=gz
elif [ -e autoconf-wrapper-${VER}.tar.bz2 ] ; then
  export opt_decomp=j
  export src_orig_pkg_ext=bz2
fi

export src_orig_pkg_name=autoconf-wrapper-${VER}.tar.${src_orig_pkg_ext}
export src_pkg_name=${FULLPKG}-src.tar.bz2
export src_patch_name=autoconf-wrapper-${VER}-${REL}.patch
export bin_pkg_name=${FULLPKG}.tar.bz2

export src_orig_pkg=${topdir}/${src_orig_pkg_name}
export src_pkg=${topdir}/${src_pkg_name}
export src_patch=${topdir}/${src_patch_name}
export bin_pkg=${topdir}/${bin_pkg_name}
export srcdir=${topdir}/autoconf-wrapper-${VER}
export objdir=${srcdir}/.build
export instdir=${srcdir}/.inst
export srcinstdir=${srcdir}/.sinst
export checkfile=${topdir}/autoconf-wrapper-${VER}.check
host=i686-pc-cygwin
target=i686-pc-cygwin
prefix=/usr
stableprefix=/usr/autotool/stable
develprefix=/usr/autotool/devel
sysconfdir=${prefix}/etc

mkdirs() {
  (cd ${srcdir} && \
  rm -fr ${objdir} ${instdir} ${srcinstdir} && \
  mkdir -p ${objdir} && \
  mkdir -p ${instdir} && \
  mkdir -p ${srcinstdir}
)}

prep() {
  (cd ${topdir} && \
  tar xv${opt_decomp}f ${src_orig_pkg} && \
  cd ${topdir} && \
  patch -p0 < ${src_patch} && \
  mkdirs
)}

conf() {
  (cd ${objdir} && \
  ${srcdir}/configure --build=${host} --target=${target} \
  --srcdir=${srcdir} --prefix=${prefix} \
  --with-devel-prefix=${develprefix} --with-stable-prefix=${stableprefix} \
  --exec-prefix=${prefix} --sysconfdir=${sysconfdir} \
  --libdir=${prefix}/lib
)}

build() {
  (cd ${objdir} && \
  make CFLAGS=-O2
)}

check() {
  (cd ${objdir} && \
  make check | tee ${checkfile} 2>&1
)}

clean() {
  (cd ${objdir} && \
  make clean
)}

install() {
  (cd ${objdir} && \
  make install INSTALL=install DESTDIR=${instdir} &&
  if [ -f ${instdir}${prefix}/info/dir ] ; then \
    rm ${instdir}${prefix}/info/dir ; \
  fi && \
  if [ ! -d ${instdir}${prefix}/doc/Cygwin ]; then \
    mkdir -p ${instdir}${prefix}/doc/Cygwin ; \
  fi && \
  if [ ! -d ${instdir}${prefix}/doc/${PKG}-${VER} ]; then \
    mkdir -p ${instdir}${prefix}/doc/${PKG}-${VER} ; \
  fi && \
  /usr/bin/install -m 644 ${srcdir}/CYGWIN-PATCHES/autoconf-wrapper.README \
    ${instdir}${prefix}/doc/Cygwin/${PKG}-${VER}.README && \
  /usr/bin/install -m 644 ${srcdir}/README \
    ${srcdir}/AUTHORS ${srcdir}/COPYING ${srcdir}/NEWS \
	 ${instdir}${prefix}/doc/${PKG}-${VER}
)}

mkpatch() {
  (cd ${srcdir} && \
  rm -rf autom4te.cache && \
  tar xv${opt_decomp}f ${src_orig_pkg} && \
  mv autoconf-wrapper-${VER} ../autoconf-wrapper-${VER}-orig && \
  cd ${topdir} && \
  diff -urN -x '.build' -x '.inst' -x '.sinst' \
    autoconf-wrapper-${VER}-orig autoconf-wrapper-${VER} > \
    ${srcinstdir}/${src_patch_name} ; \
  rm -rf autoconf-wrapper-${VER}-orig
)}

strip() {
  (cd ${instdir} && \
  find . -name "*.exe" | xargs strip >/dev/null 2>&1
  find . -name "*.dll" | xargs strip >/dev/null 2>&1
)}

pkg() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg} *
)}

spkg() {
  (mkpatch && \
  (cd $objdir && make dist) && \
  cp ${src_orig_pkg} ${srcinstdir}/${src_orig_pkg_name} && \
  cp $0 ${srcinstdir}/`basename $0` && \
  cd ${srcinstdir} && \
  tar cvjf ${src_pkg} *
)}

finish() {
  rm -rf ${srcdir}
}

case $1 in
  prep)	prep ; STATUS=$? ;;
  mkdirs)	mkdirs ; STATUS=$? ;;
  conf)	conf ; STATUS=$? ;;
  build)	build ; STATUS=$? ;;
  check)	check ; STATUS=$? ;;
  clean)	clean ; STATUS=$? ;;
  install)	install ; STATUS=$? ;;
  strip)	strip ; STATUS=$? ;;
  mkpatch) mkpatch ; STATUS=$? ;;
  package)	pkg ; STATUS=$? ;;
  pkg)	pkg ; STATUS=$? ;;
  src-package)	spkg ; STATUS=$? ;;
  spkg)	spkg ; STATUS=$? ;;
  finish) finish ; STATUS=$? ;;
  all) prep && conf && build && install && \
     pkg && spkg && finish ; STATUS=$? ;;
  *) echo "Error: bad arguments" ; exit 1 ;;
esac
exit ${STATUS}
