#!/bin/sh

# Set the path to programs
export PATH=/bin

FONTDIR=/usr/X11R6/lib/X11/fonts

# We have to umount any previous fonts dir mount, else
# cygpath will give us the path to the old mount, which
# might be on a different drive or in a different directory.
# Unmounting will cause the root mount or /usr mount to 
# be used to resolve the path to /usr/X11R6/lib/X11/fonts,
# which should point to the actual fonts directory.
umount -u $FONTDIR 2>/dev/null

# Get the path to the actual fonts directory
WFONTDIR=`cygpath -w $FONTDIR`

# Add a binary mode mount for the fonts directory
mount -bfs $WFONTDIR $FONTDIR 2>/dev/null || mount -bfu $WFONTDIR $FONTDIR

test -x "/usr/X11R6/bin/font-update" && "/usr/X11R6/bin/font-update"
