# set up Xerces build environment
export XERCESCROOT=`pwd`/xerces-c-2.4.0-1

# clean up after previous builds so our tar is smaller
cd ${XERCESCROOT}/src/xercesc &&
make distclean
cd ${XERCESCROOT}/.. &&
# make src tar
tar -cvjf xerces-c-2.4.0-1-src.tar.bz2 xerces-c-2.4.0-1.sh xerces-c-2.4.0-1 &&
# patch with post-release fixes
cd ${XERCESCROOT} &&
patch -p0 < CYGWIN-PATCHES/25032.patch &&
cd ${XERCESCROOT}/src/xercesc &&
# get rid of stuff already on the system...
/bin/rm -rf /usr/lib/libxerces-c24.dll.a /usr/lib/libxerces-c.dll.a  \
	/usr/lib/libxerces.dll.a /usr/bin/cygxerces-c24.dll /usr/include/xercesc &&
# configure options from the cygwin package guide
./runConfigure -p cygwin -c gcc -x g++ -P /usr -C --sysconfdir=/etc -C \
	--libexecdir=/usr/sbin -C --localstatedir=/var -C \
	--datadir=/usr/share -C --mandir=/usr/share/main -C \
	--infodir=/usr/share/info &&
# build everything
make &&
# install everything
make install &&
# strip binaries
strip /usr/bin/cygxerces-c24.dll &&
# put cygwin-specific files in place
cp ${XERCESCROOT}/CYGWIN-PATCHES/xerces-c-devel-postinstall.sh /etc/postinstall/xerces-c-devel.sh &&
cp ${XERCESCROOT}/CYGWIN-PATCHES/xerces-c-devel-preremove.sh /etc/preremove/xerces-c-devel.sh &&
/bin/rm -rf /usr/share/doc/Cygwin/xerces-c-2.4.0.README \
	/usr/share/doc/xerces-c-2.4.0 &&
cp ${XERCESCROOT}/CYGWIN-PATCHES/xerces-c.README \
	/usr/share/doc/Cygwin/xerces-c-2.4.0.README &&
mkdir /usr/share/doc/xerces-c-2.4.0 &&
cp ${XERCESCROOT}/credits.txt ${XERCESCROOT}/LICENSE.txt \
	/usr/share/doc/xerces-c-2.4.0/ &&
if [ -e /usr/share/doc/xerces-c-2.4.0/html ]; then \
	/bin/rm -rf /usr/share/doc/xerces-c-2.4.0/html*;
fi &&
ln -s ${XERCESCROOT}/doc/html/ /usr/share/doc/xerces-c-2.4.0 &&
cd / &&
# make doc tar
tar -cvhj --file=${XERCESCROOT}/../xerces-c-doc-2.4.0-1.tar.bz2 \
	--files-from=${XERCESCROOT}/CYGWIN-PATCHES/xerces-c-doc.tar.incl &&
# make library tar
tar -cvjf ${XERCESCROOT}/../libxerces-c24-2.4.0-1.tar.bz2 \
	usr/bin/cygxerces-c24.dll &&
tar -cvj --file=${XERCESCROOT}/../xerces-c-2.4.0-1.tar.bz2 \
	--files-from=${XERCESCROOT}/CYGWIN-PATCHES/xerces-c.tar.incl &&
# make dev tar
tar -cvj --file=${XERCESCROOT}/../xerces-c-devel-2.4.0-1.tar.bz2 \
	--files-from=${XERCESCROOT}/CYGWIN-PATCHES/xerces-c-devel.tar.incl &&
cd ${XERCESCROOT}/..
