/*
 * Decompiled with CFR 0.152.
 */
package jde.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import jde.util.DynamicClassLoader;

public class ClassInfo {
    public static final String NIL = "nil";
    public static final String NL = "\n";
    public static final String T = "t";
    public static final String LIST = "list";
    public static final String START_PAREN = "(";
    public static final String END_PAREN = ")";
    public static final String DOUBLE_QUOTE = "\"";
    public static final String SPACE = " ";
    public static final String START_LIST;
    public static final int PUBLIC = 0;
    public static final int PROTECTED = 1;
    public static final int PACKAGE = 2;
    public static final int PRIVATE = 3;
    public static final int FIELD_INFO = 0;
    public static final int CTOR_INFO = 1;
    public static final int METHOD_INFO = 2;
    public static final int INNER_CLASS_INFO = 3;

    public static void isAncestorOf(String ancestor, String child) {
        try {
            Class<?> classAncestor = Class.forName(ancestor);
            Class<?> classChild = Class.forName(child);
            if (classAncestor.isAssignableFrom(classChild)) {
                System.out.println(T);
            } else {
                System.out.println(NIL);
            }
        }
        catch (Exception ex) {
            System.out.println(NIL);
        }
    }

    private static boolean isAccessible(int modifiers, int level) {
        switch (level) {
            case 0: {
                return Modifier.isPublic(modifiers);
            }
            case 1: {
                return Modifier.isProtected(modifiers);
            }
            case 2: {
                return !Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers) && !Modifier.isPrivate(modifiers);
            }
            case 3: {
                return Modifier.isPrivate(modifiers);
            }
        }
        throw new Error("Completion.isAccessible(int, int) called with incorrect access level parameter:" + level);
    }

    private static String accessLevel(int modifiers) {
        String level = Modifier.isPublic(modifiers) ? String.valueOf(0) : (Modifier.isProtected(modifiers) ? String.valueOf(1) : (Modifier.isPrivate(modifiers) ? String.valueOf(3) : String.valueOf(2)));
        return level;
    }

    private static StringBuffer listModifiers(int modifiers) {
        StringBuffer sb = new StringBuffer(30);
        if (Modifier.isAbstract(modifiers)) {
            sb.append("\"abstract\"");
            sb.append(SPACE);
        }
        if (Modifier.isFinal(modifiers)) {
            sb.append("\"final\"");
            sb.append(SPACE);
        }
        if (Modifier.isInterface(modifiers)) {
            sb.append("\"interface\"");
            sb.append(SPACE);
        }
        if (Modifier.isNative(modifiers)) {
            sb.append("\"native\"");
            sb.append(SPACE);
        }
        if (Modifier.isPrivate(modifiers)) {
            sb.append("\"private\"");
            sb.append(SPACE);
        }
        if (Modifier.isProtected(modifiers)) {
            sb.append("\"protected\"");
            sb.append(SPACE);
        }
        if (Modifier.isPublic(modifiers)) {
            sb.append("\"public\"");
            sb.append(SPACE);
        }
        if (Modifier.isStatic(modifiers)) {
            sb.append("\"static\"");
            sb.append(SPACE);
        }
        if (Modifier.isStrict(modifiers)) {
            sb.append("\"strict\"");
            sb.append(SPACE);
        }
        if (Modifier.isSynchronized(modifiers)) {
            sb.append("\"synchronized\"");
            sb.append(SPACE);
        }
        if (Modifier.isTransient(modifiers)) {
            sb.append("\"transient\"");
            sb.append(SPACE);
        }
        if (Modifier.isVolatile(modifiers)) {
            sb.append("\"volotile\"");
            sb.append(SPACE);
        }
        if (sb.length() > 0) {
            StringBuffer temp = new StringBuffer(sb.length() + 26);
            temp.append("(cons 'typemodifiers (list ");
            temp.append((Object)sb);
            temp.append("))");
            sb = temp;
        }
        return sb;
    }

    private static StringBuffer listExceptions(Class[] classes) {
        StringBuffer sb = new StringBuffer(30);
        sb.append("(cons 'throws  (list ");
        int i = 0;
        while (i < classes.length) {
            sb.append(ClassInfo.printWithinQuotes(ClassInfo.className(classes[i])));
            if (i + 1 != classes.length) {
                sb.append(SPACE);
            }
            ++i;
        }
        sb.append("))");
        return sb;
    }

    private static StringBuffer tokenizeField(Field field) {
        StringBuffer sb = new StringBuffer(30);
        sb.append(START_LIST);
        sb.append(ClassInfo.printWithinQuotes(field.getName()));
        sb.append(SPACE);
        sb.append("'variable");
        sb.append(SPACE);
        sb.append(ClassInfo.printWithinQuotes(ClassInfo.className(field.getType())));
        sb.append(SPACE);
        sb.append(NIL);
        sb.append(SPACE);
        StringBuffer modifiers = ClassInfo.listModifiers(field.getModifiers());
        if (modifiers.length() > 0) {
            sb.append(START_LIST);
            sb.append((Object)modifiers);
            sb.append(END_PAREN);
        } else {
            sb.append(NIL);
        }
        sb.append(SPACE);
        sb.append(NIL);
        sb.append(END_PAREN);
        return sb;
    }

    private static StringBuffer tokenizeCtor(Constructor ctor) {
        Class[] types;
        StringBuffer sb = new StringBuffer(30);
        sb.append(START_LIST);
        sb.append(ClassInfo.printWithinQuotes(ctor.getName()));
        sb.append(SPACE);
        sb.append("'function ");
        sb.append((Object)ClassInfo.listClasses(ctor.getParameterTypes()));
        sb.append(SPACE);
        sb.append(START_LIST);
        sb.append("'(constructor . t)");
        StringBuffer temp = ClassInfo.listModifiers(ctor.getModifiers());
        if (temp.length() > 0) {
            sb.append(SPACE);
            sb.append((Object)temp);
        }
        if ((types = ctor.getExceptionTypes()).length > 0) {
            sb.append(SPACE);
            sb.append((Object)ClassInfo.listExceptions(types));
        }
        sb.append(END_PAREN);
        sb.append(SPACE);
        sb.append(NIL);
        sb.append(END_PAREN);
        return sb;
    }

    private static StringBuffer tokenizeMethod(Method method) {
        StringBuffer sb = new StringBuffer(30);
        sb.append(START_LIST);
        sb.append(ClassInfo.printWithinQuotes(method.getName()));
        sb.append(SPACE);
        sb.append("'function ");
        sb.append(SPACE);
        sb.append((Object)ClassInfo.listClasses(method.getParameterTypes()));
        sb.append(SPACE);
        StringBuffer temp = ClassInfo.listModifiers(method.getModifiers());
        Class[] types = method.getExceptionTypes();
        if (sb.length() > 0 || types.length > 0) {
            sb.append("(list");
            if (temp.length() > 0) {
                sb.append(SPACE);
                sb.append((Object)temp);
            }
            if (types.length > 0) {
                sb.append(SPACE);
                sb.append((Object)ClassInfo.listExceptions(types));
            }
        }
        sb.append(END_PAREN);
        sb.append(SPACE);
        sb.append(NIL);
        sb.append(END_PAREN);
        return sb;
    }

    private static StringBuffer innerClassInfo(Class ic) {
        StringBuffer sb = new StringBuffer(30);
        sb.append(START_LIST);
        sb.append(ClassInfo.printWithinQuotes(ic.getName()));
        sb.append(SPACE);
        sb.append(String.valueOf(3));
        sb.append(SPACE);
        sb.append(ClassInfo.accessLevel(ic.getModifiers()));
        sb.append(END_PAREN);
        return sb;
    }

    private static String printWithinQuotes(String item) {
        StringBuffer sb = new StringBuffer(30);
        sb.append(DOUBLE_QUOTE);
        sb.append(item);
        sb.append(DOUBLE_QUOTE);
        return sb.toString();
    }

    private static void getInheritedInnerClasses(Class c, StringBuffer sb) {
        if (c == null) {
            return;
        }
        Class<?>[] classes = c.getDeclaredClasses();
        int index = 0;
        while (index < classes.length) {
            Class<?> ic = classes[index];
            if (!Modifier.isPrivate(ic.getModifiers())) {
                sb.append((Object)ClassInfo.innerClassInfo(ic));
            }
            ++index;
        }
        ClassInfo.getInheritedInnerClasses(c.getSuperclass(), sb);
    }

    private static void getInnerClasses(Class c, StringBuffer sb) {
        Class<?>[] classes = c.getDeclaredClasses();
        int index = 0;
        while (index < classes.length) {
            sb.append((Object)ClassInfo.innerClassInfo(classes[index]));
            ++index;
        }
        ClassInfo.getInheritedInnerClasses(c.getSuperclass(), sb);
    }

    private static void getMemberInfo(Class c, StringBuffer sb) {
        sb.append(START_LIST);
        Field[] fields = c.getDeclaredFields();
        int index = 0;
        while (index < fields.length) {
            sb.append((Object)ClassInfo.tokenizeField(fields[index]));
            ++index;
        }
        Constructor<?>[] ctors = c.getDeclaredConstructors();
        int index2 = 0;
        while (index2 < ctors.length) {
            sb.append((Object)ClassInfo.tokenizeCtor(ctors[index2]));
            ++index2;
        }
        Method[] methods = c.getDeclaredMethods();
        int index3 = 0;
        while (index3 < methods.length) {
            sb.append((Object)ClassInfo.tokenizeMethod(methods[index3]));
            ++index3;
        }
        ClassInfo.getInnerClasses(c, sb);
        sb.append(END_PAREN);
        sb.append(NL);
    }

    public static void getClassInfo(String className) {
        try {
            DynamicClassLoader dcl = new DynamicClassLoader();
            Class c = dcl.loadClass(className);
            if (c != null) {
                StringBuffer sb = new StringBuffer(3000);
                sb.append(START_LIST);
                sb.append(ClassInfo.printWithinQuotes(className));
                sb.append(SPACE);
                sb.append("'type");
                sb.append(SPACE);
                ClassInfo.getMemberInfo(c, sb);
                sb.append(END_PAREN);
                sb.append(NL);
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter(System.out));
                try {
                    out.write(sb.toString());
                    ((Writer)out).flush();
                }
                catch (IOException e) {}
            }
        }
        catch (Exception cnfe) {
            System.out.println(NIL);
        }
    }

    public static void getClassInfo(String className, String[] imports) {
        int i = 0;
        while (i < imports.length) {
            String name = imports[i] + className;
            try {
                Class<?> c = Class.forName(name);
                if (c != null) {
                    ClassInfo.getClassInfo(name);
                }
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
            ++i;
        }
        System.out.println(NIL);
    }

    static String className(Class c) {
        if (c.isArray()) {
            return c.getComponentType().getName() + "[]";
        }
        return c.getName();
    }

    static StringBuffer listClasses(Class[] classes) {
        StringBuffer sb = new StringBuffer(100);
        if (classes.length > 0) {
            sb.append(START_LIST);
            sb.append(SPACE);
            int i = 0;
            while (i < classes.length) {
                sb.append(ClassInfo.printWithinQuotes(ClassInfo.className(classes[i])));
                if (i + 1 != classes.length) {
                    sb.append(SPACE);
                }
                ++i;
            }
            sb.append(END_PAREN);
        } else {
            sb.append(NIL);
        }
        return sb;
    }

    public static void hasMember(String className, String memberName) {
        try {
            DynamicClassLoader dcl = new DynamicClassLoader();
            Class c = dcl.loadClass(className);
            if (c != null) {
                Field[] fields = c.getFields();
                boolean hasField = false;
                int index = 0;
                while (index < fields.length) {
                    if (fields[index].getName().equals(memberName)) {
                        hasField = true;
                        break;
                    }
                    ++index;
                }
                Method[] methods = c.getMethods();
                boolean hasMethod = false;
                int index2 = 0;
                while (index2 < methods.length) {
                    if (methods[index2].getName().equals(memberName)) {
                        hasMethod = true;
                        break;
                    }
                    ++index2;
                }
                StringBuffer sb = new StringBuffer(3000);
                sb.append(START_LIST);
                sb.append(hasField ? T : NIL);
                sb.append(hasMethod ? " t" : " nil");
                sb.append(END_PAREN);
                sb.append(NL);
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter(System.out));
                try {
                    out.write(sb.toString());
                    ((Writer)out).flush();
                }
                catch (IOException e) {}
            }
        }
        catch (Exception cnfe) {
            System.out.println(NIL);
        }
    }

    public static void main(String[] args) {
        ClassInfo.getClassInfo("java.lang.Object");
    }

    static {
        StringBuffer sb = new StringBuffer(10);
        sb.append(START_PAREN);
        sb.append(LIST);
        sb.append(SPACE);
        START_LIST = sb.toString();
    }
}

