/*
 * Copyright (c) 2000, Red Hat, Inc.
 * Copyright (c) 2003 Robert Collins <rbtcollins@hotmail.com>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     A copy of the GNU General Public License can be found at
 *     http://www.gnu.org/
 *
 * Written by Robert Collins <rbtcollins@hotmail.com>
 *
 */

#ifndef SETUP_CHOOSE_H
#define SETUP_CHOOSE_H

#include "proppage.h"
#include "package_meta.h"
#include "PickView.h"


class ChooserPage:public PropertyPage
{
public:
  ChooserPage ()
  {
  };
  virtual ~ ChooserPage ()
  {
  };

  virtual bool OnMessageCmd (int id, HWND hwndctl, UINT code);

  bool Create ();
  virtual void OnInit ();
  virtual long OnNext ();
  virtual long OnBack ();
  virtual void OnActivate ();
  virtual long OnUnattended ()
  {
    return OnNext ();
  }; 
  private:
  void createListview ();
  RECT getDefaultListViewSize();
  void getParentRect (HWND parent, HWND child, RECT * r);
  void keepClicked();
  void logOnePackageResult(packagemeta const *aPkg);
  void logResults();
  void setPrompt(char const *aPrompt);
  template<class C> bool ifChecked(int const &id, void (C::*fn)()) {
     if (IsButtonChecked (id)) {
       (this->*fn)();
       return true;
     }
    else
      return false;
  }
  template <trusts aTrust> void changeTrust();
  PickView *chooser;
};

#endif /* SETUP_CHOOSE_H */
