#!/bin/sh
# find out where the build script is located
tdir=`echo "$0" | sed 's%[\\/][^\\/][^\\/]*$%%'`
test "x$tdir" = "x$0" && tdir=.
scriptdir=`cd $tdir; pwd`
# find src directory.  
# If scriptdir ends in SPECS, then topdir is $scriptdir/.. 
# If scriptdir ends in CYGWIN-PATCHES, then topdir is $scriptdir/../..
# Otherwise, we assume that topdir = scriptdir
topdir1=`echo ${scriptdir} | sed 's%/SPECS$%%'`
topdir2=`echo ${scriptdir} | sed 's%/CYGWIN-PATCHES$%%'`
if [ "x$topdir1" != "x$scriptdir" ] ; then # SPECS
  topdir=`cd ${scriptdir}/..; pwd`
else
  if [ "x$topdir2" != "x$scriptdir" ] ; then # CYGWIN-PATCHES
    topdir=`cd ${scriptdir}/../..; pwd`
  else
    topdir=`cd ${scriptdir}; pwd`
  fi
fi

tscriptname=`basename $0 .sh`
export PKG=`echo $tscriptname | sed -e 's/\-[^\-]*\-[^\-]*$//'`
export VER=`echo $tscriptname | sed -e 's/^[^\-]*\-//' -e 's/\-[^\-]*$//'`
export REL=`echo $tscriptname | sed -e 's/^[^\-]*\-[^\-]*\-//'`
export FULLPKG=${PKG}-${VER}-${REL}
# if the orig src package is bzip2'ed, remember to
# change 'z' to 'j' in the 'tar xvzf' commands in the
# prep) and mkpatch) sections
export src_orig_pkg_name=${PKG}-${VER}.tar.gz
export src_pkg_name=${FULLPKG}-src.tar.bz2
export src_patch_name=${FULLPKG}.patch
export bin_pkg_name=${FULLPKG}.tar.bz2
export bld_pkg_name=${PKG}-build-${VER}-${REL}.tar.bz2
export doc_pkg_name=${PKG}-doc-${VER}-${REL}.tar.bz2

export src_orig_pkg=${topdir}/${src_orig_pkg_name}
export src_pkg=${topdir}/${src_pkg_name}
export src_patch=${topdir}/${src_patch_name}
export bin_pkg=${topdir}/${bin_pkg_name}
export bld_pkg=${topdir}/${bld_pkg_name}
export doc_pkg=${topdir}/${doc_pkg_name}
export srcdir=${topdir}/${PKG}-${VER}
#export objdir=${srcdir}/.build
export objdir=${srcdir}
export instdir=${srcdir}/.inst
export srcinstdir=${srcdir}/.sinst
export checkfile=${topdir}/${FULLPKG}.check
# run on
host=i686-pc-cygwin
# if this package creates binaries, they run on
target=i686-pc-cygwin
prefix=/usr
sysconfdir=/etc
MY_CFLAGS="-O2 -g"
MY_LDFLAGS="-lrpc"

mkdirs() {
  (cd ${topdir} && \
  mkdir -p ${objdir} && \
  mkdir -p ${instdir} && \
  mkdir -p ${srcinstdir} )
}
prep() {
  (cd ${topdir} && \
  tar xvzf ${src_orig_pkg} ; \
  cd ${topdir} && \
  patch -b -p0 < ${src_patch} 
  && mkdirs) # && \
#  chmod +x ${srcdir}/CYGWIN-PATCHES/shtool && \
#  cd ${srcdir} && \
#  CYGWIN-PATCHES/shtool mkshadow -v . .build )
}
conf() {
#  (cd ${objdir} && \
#  CFLAGS="${MY_CFLAGS}" LDFLAGS="${MY_LDFLAGS}" \
#  ${srcdir}/configure --host=${host} --target=${target} \
#  --srcdir=${srcdir} --prefix=${prefix} \
#  --exec-prefix=${prefix} --sysconfdir=${sysconfdir} \
#  --libdir=${prefix}/lib --includedir=${prefix}/include \
#  --libexecdir='${sbindir}' --localstatedir=/var \
#  --datadir='${prefix}/share' --without-python
  (cd ${objdir} && \
  CFLAGS="${MY_CFLAGS}" LDFLAGS="${MY_LDFLAGS}" \
  ${srcdir}/configure --prefix=/usr --without-python
)
}
build() {
  (cd ${objdir} && \
  CFLAGS="${MY_CFLAGS}" make )
}
check() {
  echo done.
}
clean() {
  (cd ${objdir} && \
  make clean )
}
install() {
  (cd ${objdir} && \
  make install DESTDIR=${instdir} && \
  if [ -f ${instdir}${prefix}/info/dir ] ; then \
    rm ${instdir}${prefix}/info/dir ; \
  fi && \
  if [ ! -d ${instdir}${prefix}/doc/${PKG}-${VER} ]; then \
    mkdir -p ${instdir}${prefix}/doc/${PKG}-${VER} ; \
  fi && \
  if [ ! -d ${instdir}${prefix}/doc/Cygwin ]; then \
    mkdir -p ${instdir}${prefix}/doc/Cygwin ; \
  fi && \
  if [ ! -d ${instdir}${sysconfdir}/postinstall ]; then \
    mkdir -p ${instdir}${sysconfdir}/postinstall ; \
  fi && \
  templist=""; \
  for f in ${srcdir}/ANNOUNCE ${srcdir}/CHANGES ${srcdir}/INSTALL \
           ${srcdir}/KNOWNBUG ${srcdir}/LICENSE ${srcdir}/README \
			  ${srcdir}/TODO ; do \
    if [ -f $f ] ; then \
      templist="$templist $f"; \
    fi ; \
  done && \
  if [ ! "x$templist" = "x" ]; then \
    /usr/bin/install -m 644 $templist \
         ${instdir}${prefix}/doc/${PKG}-${VER} ;
  fi && \
  if [ -f ${srcdir}/CYGWIN-PATCHES/${PKG}.README ]; then \
    /usr/bin/install -m 644 ${srcdir}/CYGWIN-PATCHES/${PKG}.README \
      ${instdir}${prefix}/doc/Cygwin/${PKG}-${VER}.README ; \
  else \
    if [ -f ${srcdir}/CYGWIN-PATCHES/README ]; then \
      /usr/bin/install -m 644 ${srcdir}/CYGWIN-PATCHES/README \
        ${instdir}${prefix}/doc/Cygwin/${PKG}-${VER}.README ; \
    fi ;\
  fi ;\
  /usr/bin/install -m 755 ${srcdir}/CYGWIN-PATCHES/postinstall.sh \
    ${instdir}${sysconfdir}/postinstall/${PKG}.sh )
}
strip() {
  (cd ${instdir} && \
  find . -name "*.dll" | xargs strip > /dev/null 2>&1
  find . -name "*.exe" | xargs strip > /dev/null 2>&1 )
}
pkg() {
  (cd ${instdir} && \
  tar cvjfT ${bin_pkg} - <<EOF &&
usr/bin/rpm.exe
etc/postinstall/rpm.sh
usr/bin/gendiff
usr/bin/rpm2cpio.exe
usr/bin/rpmdb
usr/bin/rpmquery
usr/bin/rpmsign
usr/bin/rpmverify
usr/doc/Cygwin/rpm-4.1.README
usr/lib/rpm/config.guess
usr/lib/rpm/config.sub
usr/lib/rpm/convertrpmrc.sh
usr/lib/rpm/macros
usr/lib/rpm/mkinstalldirs
usr/lib/rpm/rpm.daily
usr/lib/rpm/rpm.log
usr/lib/rpm/rpm.xinetd
usr/lib/rpm/rpm2cpio.sh
usr/lib/rpm/rpmd.exe
usr/lib/rpm/rpmdiff
usr/lib/rpm/rpmdiff.cgi
usr/lib/rpm/rpme
usr/lib/rpm/rpmi.exe
usr/lib/rpm/rpmk.exe
usr/lib/rpm/rpmpopt-4.1
usr/lib/rpm/rpmq.exe
usr/lib/rpm/rpmrc
usr/lib/rpm/rpmu
usr/lib/rpm/rpmv
usr/lib/rpm/Specfile.pm
usr/lib/rpm/sql.prov
usr/lib/rpm/sql.req
usr/lib/rpm/tcl.req
usr/lib/rpm/tgpg
usr/lib/rpmpopt
usr/lib/rpmrc
usr/share/locale/cs/LC_MESSAGES/rpm.mo
usr/share/locale/da/LC_MESSAGES/rpm.mo
usr/share/locale/de/LC_MESSAGES/rpm.mo
usr/share/locale/fi/LC_MESSAGES/rpm.mo
usr/share/locale/fr/LC_MESSAGES/rpm.mo
usr/share/locale/gl/LC_MESSAGES/rpm.mo
usr/share/locale/is/LC_MESSAGES/rpm.mo
usr/share/locale/ja/LC_MESSAGES/rpm.mo
usr/share/locale/ko/LC_MESSAGES/rpm.mo
usr/share/locale/no/LC_MESSAGES/rpm.mo
usr/share/locale/pl/LC_MESSAGES/rpm.mo
usr/share/locale/pt/LC_MESSAGES/rpm.mo
usr/share/locale/pt_BR/LC_MESSAGES/rpm.mo
usr/share/locale/ro/LC_MESSAGES/rpm.mo
usr/share/locale/ru/LC_MESSAGES/rpm.mo
usr/share/locale/sk/LC_MESSAGES/rpm.mo
usr/share/locale/sl/LC_MESSAGES/rpm.mo
usr/share/locale/sr/LC_MESSAGES/rpm.mo
usr/share/locale/sv/LC_MESSAGES/rpm.mo
usr/share/locale/tr/LC_MESSAGES/rpm.mo
var/lib/rpm/
var/tmp/
EOF
  tar cvjfT ${doc_pkg} - <<EOF &&
usr/man/fr/man8/rpm.8
usr/man/ja/man8/rpm.8
usr/man/ja/man8/rpm2cpio.8
usr/man/ko/man8/rpm.8
usr/man/ko/man8/rpm2cpio.8
usr/man/man1/gendiff.1
usr/man/man8/rpm.8
usr/man/man8/rpm2cpio.8
usr/man/pl/man8/rpm.8
usr/man/pl/man8/rpm2cpio.8
usr/man/ru/man8/rpm.8
usr/man/ru/man8/rpm2cpio.8
usr/man/sk/man8/rpm.8
EOF
  tar cvjfT ${bld_pkg} - <<EOF &&
usr/bin/rpmbuild
usr/lib/rpm/brp-compress
usr/lib/rpm/brp-redhat
usr/lib/rpm/brp-sparc64-linux
usr/lib/rpm/brp-strip
usr/lib/rpm/brp-strip-comment-note
usr/lib/rpm/brp-strip-shared
usr/lib/rpm/check-files
usr/lib/rpm/check-prereqs
usr/lib/rpm/config.site
usr/lib/rpm/cross-build
usr/lib/rpm/find-debuginfo.sh
usr/lib/rpm/find-lang.sh
usr/lib/rpm/find-prov.pl
usr/lib/rpm/find-provides
usr/lib/rpm/find-provides.perl
usr/lib/rpm/find-req.pl
usr/lib/rpm/find-requires
usr/lib/rpm/find-requires.perl
usr/lib/rpm/getpo.sh
usr/lib/rpm/get_magic.pl
usr/lib/rpm/http.req
usr/lib/rpm/javadeps.exe
usr/lib/rpm/magic.prov
usr/lib/rpm/magic.req
usr/lib/rpm/perl.prov
usr/lib/rpm/perl.req
usr/lib/rpm/rpmb.exe
usr/lib/rpm/rpmt
usr/lib/rpm/striptofile.exe
usr/lib/rpm/trpm
usr/lib/rpm/unstripfile.exe
usr/lib/rpm/u_pkg.sh
usr/lib/rpm/vpkg-provides.sh
usr/lib/rpm/vpkg-provides2.sh
usr/man/man8/rpmbuild.8
usr/src/rpm/BUILD/
usr/src/rpm/RPMS/athlon/
usr/src/rpm/RPMS/i386/
usr/src/rpm/RPMS/i486/
usr/src/rpm/RPMS/i586/
usr/src/rpm/RPMS/i686/
usr/src/rpm/RPMS/noarch/
usr/src/rpm/SOURCES/
usr/src/rpm/SPECS/
usr/src/rpm/SRPMS/
EOF
) 
}
mkpatch() {
#  (cd ${srcdir} && \
#  tar xvzf ${src_orig_pkg} && \
#  mv ${PKG}-${VER} ../${PKG}-${VER}-orig && \
#  cd ${topdir} && \
#  diff -urN -x '.build' -x '.inst' -x '.sinst' \
#    ${PKG}-${VER}-orig ${PKG}-${VER} > \
#    ${srcinstdir}/${src_patch_name} ; \
#  rm -rf ${PKG}-${VER}-orig )
  (cd ${topdir} && \
  files=`find ${PKG}-${VER} -name \*.orig -print | sort`
  for f in ${files}
  do
    diff -ub $f `echo $f | sed 's/\.orig$//'`
  done > ${srcinstdir}/${src_patch_name}; true)
}
spkg() {
  (mkpatch && \
  cp ${src_orig_pkg} ${srcinstdir}/${src_orig_pkg_name} && \
  cp $0 ${srcinstdir}/`basename $0` && \
  cd ${srcinstdir} && \
  tar cvjf ${src_pkg} * )
}
finish() {
  rm -rf ${srcdir} 
}
case $1 in
  prep)	prep ; STATUS=$? ;;
  mkdirs)	mkdirs; STATUS=$? ;;
  conf)	conf ; STATUS=$? ;;
  build)	build ; STATUS=$? ;;
  check)	check ; STATUS=$? ;;
  clean)	clean ; STATUS=$? ;;
  install)	install ; STATUS=$? ;;
  strip)	strip ; STATUS=$? ;;
  package)	pkg ; STATUS=$? ;;
  pkg)	pkg ; STATUS=$? ;;
  mkpatch)	mkpatch ; STATUS=$? ;;
  src-package)	spkg ; STATUS=$? ;;
  spkg)	spkg ; STATUS=$? ;;
  finish) finish ; STATUS=$? ;;
  all) prep && conf && build && install && \
     strip && pkg && spkg && finish ; \
	  STATUS=$? ;;
  *) echo "Error: bad arguments" ; exit 1 ;;
esac
exit ${STATUS}
