#! /bin/bash

# $Id: build.sh,v 1.4 2004/08/27 20:34:53 jt Exp $

# vim: tabstop=4

# parse arguments
version=$1
port=$2

# constants
pkg=procmail

# dir variables
Prefix=/usr
TmpDir=/tmp/$pkg.$$
InstallPrefix=$TmpDir$Prefix

DataDir=$InstallPrefix/share
ManDir=$DataDir/man
DocDir=$DataDir/doc/$pkg-$version
CygDocDir=$DataDir/doc/Cygwin
PatchDir=CYGWIN-PATCHES
SrcDocDir=doc

# make
make EXE=.exe LOCKINGTEST=100

# make install
make BASENAME=$InstallPrefix MANDIR=$ManDir EXE=.exe install

# strip executables
find $InstallPrefix -name '*.exe' | xargs strip

# copy Cygwin procmail README file
mkdir -p $CygDocDir
cp $PatchDir/README $CygDocDir/$pkg-$version.README

# copy procmail COPYING, README, etc. files
TopFiles=(Artistic COPYING FAQ FEATURES HISTORY INSTALL KNOWN_BUGS README)
mkdir -p $DocDir
cp ${TopFiles[*]} $DocDir

# create package
tar -C $TmpDir -cjf $pkg-$version-$port.tar.bz2 usr

# remove temporary directory
rm -fr $TmpDir
