/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class metadata {
    Connection db;
    Statement st;
    DatabaseMetaData dbmd;
    private static final String[] allUserTables = new String[]{"TABLE", "INDEX", "SEQUENCE"};
    private static final String[] usrIndices = new String[]{"INDEX"};
    private static final String[] usrTables = new String[]{"TABLE"};
    private static final String[] usrSequences = new String[]{"SEQUENCE"};
    private static final String[] sysTables = new String[]{"SYSTEM TABLE", "SYSTEM INDEX"};

    public void doDatabaseMetaData() throws SQLException {
        if (this.doTest("getProcedures() - should show all available procedures")) {
            this.displayResult(this.dbmd.getProcedures(null, null, null));
        }
        if (this.doTest("getProcedures() with pattern - should show all circle procedures")) {
            this.displayResult(this.dbmd.getProcedures(null, null, "circle%"));
        }
        if (this.doTest("getProcedureColumns() on circle procedures")) {
            this.displayResult(this.dbmd.getProcedureColumns(null, null, "circle%", null));
        }
        if (this.doTest("getTables()")) {
            this.displayResult(this.dbmd.getTables(null, null, null, null));
        }
        if (this.doTest("getColumns() - should show all tables, can take a while to run")) {
            this.displayResult(this.dbmd.getColumns(null, null, null, null));
        }
        if (this.doTest("getColumns() - should show the test_b table")) {
            this.displayResult(this.dbmd.getColumns(null, null, "test_b", null));
        }
        if (this.doTest("getColumnPrivileges() - should show all tables")) {
            this.displayResult(this.dbmd.getColumnPrivileges(null, null, null, null));
        }
        if (this.doTest("getPrimaryKeys()")) {
            this.displayResult(this.dbmd.getPrimaryKeys(null, null, null));
        }
        if (this.doTest("getTypeInfo()")) {
            this.displayResult(this.dbmd.getTypeInfo());
        }
    }

    public void doResultSetMetaData() throws SQLException {
        String sql = "select imagename,descr,source,cost from test_a,test_b,test_c where test_a.id=test_b.imageid and test_a.id=test_c.imageid";
        System.out.println("Executing query for tests");
        ResultSet rs = this.st.executeQuery(sql);
        ResultSetMetaData rsmd = rs.getMetaData();
        if (this.doTest("isCurrency()")) {
            System.out.println("isCurrency on col 1 = " + rsmd.isCurrency(1) + " should be false\nisCurrency on col 4 = " + rsmd.isCurrency(4) + " should be true");
        }
        if (this.doTest("Display query result")) {
            System.out.println("Query: " + sql);
            this.displayResult(rs);
        } else {
            rs.close();
        }
    }

    public void init() throws SQLException {
        System.out.println("Creating some tables");
        this.cleanup();
        this.st.executeUpdate("create table test_a (imagename name,image oid,id int4)");
        this.st.executeUpdate("create table test_b (descr text,imageid int4,id int4)");
        this.st.executeUpdate("create table test_c (source text,cost money,imageid int4)");
        System.out.println("Adding some data");
        this.st.executeUpdate("insert into test_a values ('test1',0,1)");
        this.st.executeUpdate("insert into test_b values ('A test description',1,2)");
        this.st.executeUpdate("insert into test_c values ('nowhere particular','$10.99',1)");
    }

    public void cleanup() throws SQLException {
        try {
            this.st.executeUpdate("drop table test_a");
            this.st.executeUpdate("drop table test_b");
            this.st.executeUpdate("drop table test_c");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public metadata(String[] args) throws ClassNotFoundException, FileNotFoundException, IOException, SQLException {
        String url = args[0];
        String usr = args[1];
        String pwd = args[2];
        Class.forName("org.postgresql.Driver");
        System.out.println("Connecting to Database URL = " + url);
        this.db = DriverManager.getConnection(url, usr, pwd);
        this.dbmd = this.db.getMetaData();
        this.st = this.db.createStatement();
        System.out.println("Connected to " + this.dbmd.getDatabaseProductName() + " " + this.dbmd.getDatabaseProductVersion());
        this.init();
        System.out.println();
        if (this.doTest("Test DatabaseMetaData")) {
            this.doDatabaseMetaData();
        }
        if (this.doTest("Test ResultSetMetaData")) {
            this.doResultSetMetaData();
        }
        System.out.println("\nNow closing the connection");
        this.st.close();
        this.db.close();
        this.cleanup();
    }

    public boolean doTest(String s) {
        System.out.println();
        System.out.print(s);
        System.out.print(" Perform test? Y or N:");
        System.out.flush();
        int c = 32;
        try {
            while (c != 110 && c != 121 && c != 78 && c != 89) {
                c = (char)System.in.read();
            }
        }
        catch (IOException ioe) {
            return false;
        }
        return c == 121 || c == 89;
    }

    public void displayResult(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int count = 0;
        int cols = rsmd.getColumnCount();
        int i = 1;
        while (i <= cols) {
            System.out.print(rsmd.getColumnLabel(i) + (i < cols ? "\t" : "\n"));
            ++i;
        }
        while (rs.next()) {
            ++count;
            int i2 = 1;
            while (i2 <= cols) {
                Object o = rs.getObject(i2);
                if (rs.wasNull()) {
                    System.out.print("{null}" + (i2 < cols ? "\t" : "\n"));
                } else {
                    System.out.print(o.toString() + (i2 < cols ? "\t" : "\n"));
                }
                ++i2;
            }
        }
        System.out.println("Result returned " + count + " rows.");
        rs.close();
    }

    public void processSlashCommand(String line) throws SQLException {
        if (line.startsWith("\\d")) {
            if (line.startsWith("\\d ")) {
                String table = line.substring(3);
                this.displayResult(this.dbmd.getColumns(null, null, table, "%"));
            } else {
                String[] types = null;
                if (line.equals("\\d")) {
                    types = allUserTables;
                } else if (line.equals("\\di")) {
                    types = usrIndices;
                } else if (line.equals("\\dt")) {
                    types = usrTables;
                } else if (line.equals("\\ds")) {
                    types = usrSequences;
                } else if (line.equals("\\dS")) {
                    types = sysTables;
                } else {
                    throw new SQLException("Unsupported \\d command: " + line);
                }
                this.displayResult(this.dbmd.getTables(null, null, "%", types));
            }
        } else {
            throw new SQLException("Unsupported \\ command: " + line);
        }
    }

    public static void instructions() {
        System.out.println("\nThis is not really an example, but is used to test the various methods in\nthe DatabaseMetaData and ResultSetMetaData classes.\n");
        System.out.println("Useage:\n java example.metadata jdbc:postgresql:database user password [debug]\n\nThe debug field can be anything. It's presence will enable DriverManager's\ndebug trace. Unless you want to see screens of debug items, don't put anything in\nhere.");
        System.exit(1);
    }

    public static void main(String[] args) {
        System.out.println("PostgreSQL metdata tester v6.4 rev 1\n");
        if (args.length < 3) {
            metadata.instructions();
        }
        if (args.length > 3) {
            DriverManager.setLogStream(System.err);
        }
        try {
            metadata test = new metadata(args);
        }
        catch (Exception ex) {
            System.err.println("Exception caught.\n" + ex);
            ex.printStackTrace();
        }
    }
}

