#!/bin/sh
#set -x
# find out where the build script is located
tdir=`echo "$0" | sed 's%[\\/][^\\/][^\\/]*$%%'`
test "x$tdir" = "x$0" && tdir=.
scriptdir=`cd $tdir; pwd`
# find src directory.  
# If scriptdir ends in SPECS, then topdir is $scriptdir/.. 
# If scriptdir ends in CYGWIN-PATCHES, then topdir is $scriptdir/../..
# Otherwise, we assume that topdir = scriptdir
topdir1=`echo ${scriptdir} | sed 's%/SPECS$%%'`
topdir2=`echo ${scriptdir} | sed 's%/CYGWIN-PATCHES$%%'`
if [ "x$topdir1" != "x$scriptdir" ] ; then # SPECS
  topdir=`cd ${scriptdir}/..; pwd`
else
  if [ "x$topdir2" != "x$scriptdir" ] ; then # CYGWIN-PATCHES
    topdir=`cd ${scriptdir}/../..; pwd`
  else
    topdir=`cd ${scriptdir}; pwd`
  fi
fi

tscriptname=`basename $0 .sh`
export PKG=`echo $tscriptname | sed -e 's/\-[^\-]*\-[^\-]*$//'`
export PKG2=libopenldap2
export PKG3=openldap-devel
export VER=`echo $tscriptname | sed -e "s/${PKG}\-//" -e 's/\-[^\-]*$//'`
export REL=`echo $tscriptname | sed -e "s/${PKG}\-${VER}\-//"`
export FULLPKG=${PKG}-${VER}-${REL}
export FULLPKG2=${PKG2}-${VER}-${REL}
export FULLPKG3=${PKG3}-${VER}-${REL}

# determine correct decompression option and tarball filename
if [ -e ${PKG}-${VER}.tar.gz ] ; then
  export opt_decomp=z
  export src_orig_pkg_ext=gz
elif [ -e ${PKG}-${VER}.tgz ] ; then
  export opt_decomp=z
  export src_orig_pkg_ext=tgz
elif [ -e ${PKG}-${VER}.tar.bz2 ] ; then
  export opt_decomp=j
  export src_orig_pkg_ext=bz2
fi

export src_orig_pkg_name=${PKG}-${VER}.${src_orig_pkg_ext}
export src_pkg_name=${FULLPKG}-src.tar.bz2
export src_patch_name=${FULLPKG}.patch
export bin_pkg_name=${FULLPKG}.tar.bz2
export bin_pkg_name2=${FULLPKG2}.tar.bz2
export bin_pkg_name3=${FULLPKG3}.tar.bz2

export src_orig_pkg=${topdir}/${src_orig_pkg_name}
export src_pkg=${topdir}/${src_pkg_name}
export src_patch=${topdir}/${src_patch_name}
export bin_pkg=${topdir}/${bin_pkg_name}
export bin_pkg2=${topdir}/${bin_pkg_name2}
export bin_pkg3=${topdir}/${bin_pkg_name3}
export srcdir=${topdir}/${PKG}-${VER}
export objdir=${srcdir}/.build
export instdir=${srcdir}/.inst
export srcinstdir=${srcdir}/.sinst
export configurefile=${topdir}/${FULLPKG}.configure
export makefile=${topdir}/${FULLPKG}.make
export checkfile=${topdir}/${FULLPKG}.check
# run on
host=i686-pc-cygwin
# if this package creates binaries, they run on
target=i686-pc-cygwin

prefix=/usr
exec_prefix=${prefix}
sysconfdir=/etc
bindir=${prefix}/bin
sbindir=${prefix}/sbin
libexecdir=${prefix}/libexec
datadir=${prefix}/share
sharedstatedir=${prefix}/com
localstatedir=/var/openldap
libdir=${prefix}/lib
includedir=${prefix}/include
infodir=${datadir}/info
mandir=${datadir}/man

cygdatadir=${prefix}/share
docdir=${cygdatadir}/doc/${PKG}-${VER}
docdirdevel=${cygdatadir}/doc/${PKG}-devel-${VER}

pnoslash=`echo $prefix | sed -e 's#^/##'`
snoslash=`echo $sysconfdir | sed -e 's#^/##'`
vnoslash=var

MY_CFLAGS="-O2"
MY_LDFLAGS="-no-undefined"

mkdirs() {
  (cd ${topdir} && \
  rm -fr ${objdir} ${instdir} ${srcinstdir} && \
  mkdir -p ${objdir} && \
  mkdir -p ${instdir} && \
  mkdir -p ${srcinstdir} )
}
prep() {
  (cd ${topdir} && \
  tar xv${opt_decomp}f ${src_orig_pkg} ; \
  cd ${topdir} && \
  patch -p0 < ${src_patch} 
  && mkdirs )
}
conf() {
  (cd ${objdir} && \
#  lndir ../ && \
#  rm -rf .build .inst .sinst CYGWIN-PATCHES && \
  CFLAGS="${MY_CFLAGS}"            \
  LDFLAGS="${MY_LDFLAGS}"          \
  ${srcdir}/configure              \
  --srcdir=${srcdir}               \
  --prefix=${prefix}               \
  --exec-prefix=${exec_prefix}     \
  --sysconfdir=${sysconfdir}       \
  --libdir=${libdir}               \
  --includedir=${includedir}       \
  --mandir=${mandir}               \
  --infodir=${infodir}             \
  --libexecdir=${libexecdir}       \
  --localstatedir=${localstatedir} \
  --datadir=${datadir}             \
  --with-cyrus-sasl=no             \
  --enable-dynamic                 \
  --enable-aci                     \
  --enable-cleartext               \
  --enable-crypt                   \
  --enable-lmpasswd                \
  --enable-spasswd=no              \
  --enable-phonetic                \
  --enable-rewrite                 \
  --enable-rlookups                \
  --disable-slp                    \
  --disable-wrappers               \
  --enable-bdb                     \
  --enable-dnssrv                  \
  --enable-ldap                    \
  --enable-ldbm                    \
  --enable-meta                    \
  --enable-monitor                 \
  --enable-null                    \
  --enable-passwd                  \
  --disable-perl                   \
  --enable-shell                   \
  --enable-sql=no                  \
  --enable-static=no               \
  --enable-shared=yes              \
  | tee ${configurefile} 2>&1   && \
  cp /usr/autotool/devel/bin/libtool ${objdir}
)
}
build() {
  (cd ${objdir} && \
  make depend   && \
  make LDFLAGS="${MY_LDFLAGS}" | tee ${makefile} 2>&1 )
}
check() {
  (cd ${objdir} && \
  make test | tee ${checkfile} 2>&1 )
}
clean() {
  (cd ${objdir} && \
  make clean )
}
install() {
  (cd ${objdir} && \
  make install INSTALL=install DESTDIR=${instdir} 
  for f in ${prefix}/share/info/dir ${prefix}/info/dir ; do
    if [ -f ${instdir}${f} ] ; then \
      rm -f ${instdir}${f} ; \
    fi ;\
  done &&\
  for d in ${prefix}/share/doc/${PKG}-${VER} ${prefix}/share/doc/${PKG3}-${VER} \
           ${prefix}/share/doc/Cygwin ${sysconfdir}/postinstall ; do
    if [ ! -d ${instdir}${d} ] ; then
      mkdir -p ${instdir}${d} ;\
    fi ;\
  done &&\
  templist=""; \
  for f in ${srcdir}/ANNOUNCEMENT ${srcdir}/CHANGES ${srcdir}/INSTALL \
           ${srcdir}/KNOWNBUG ${srcdir}/LICENSE ${srcdir}/README \
           ${srcdir}/TODO ${srcdir}/COPYRIGHT ; do \
    if [ -f $f ] ; then \
      templist="$templist $f"; \
    fi ; \
  done && \
  if [ ! "x$templist" = "x" ]; then \
    /usr/bin/install -m 644 $templist \
         ${instdir}${prefix}/share/doc/${PKG}-${VER} ;
    /usr/bin/install -m 644 $templist \
         ${instdir}${prefix}/share/doc/${PKG3}-${VER} ;
  fi && \
  cat ${srcdir}/CYGWIN-PATCHES/${PKG}.frag \
    ${srcdir}/CYGWIN-PATCHES/README.frag > \
    ${instdir}${prefix}/share/doc/Cygwin/${PKG}-${VER}.README && \
  cat ${srcdir}/CYGWIN-PATCHES/${PKG3}.frag \
    ${srcdir}/CYGWIN-PATCHES/README.frag > \
    ${instdir}${prefix}/share/doc/Cygwin/${PKG3}-${VER}.README && \
  if [ -f ${srcdir}/CYGWIN-PATCHES/postinstall.sh ] ; then \
  /usr/bin/install -m 755 ${srcdir}/CYGWIN-PATCHES/postinstall.sh \
      ${instdir}${sysconfdir}/postinstall/${PKG}.sh
  fi && \
  chmod 755 ${instdir}${bindir}/*.dll                 && \
  cp -r ${srcdir}/doc/rfc    ${instdir}${docdirdevel} && \
  cp -r ${srcdir}/doc/devel  ${instdir}${docdirdevel} && \
  cp -r ${srcdir}/doc/drafts ${instdir}${docdirdevel} && \
  rm -rf ${instdir}${mandir}/man8                     && \
  rm     ${instdir}${mandir}/man5/slapd*              && \
  rm     ${instdir}${sysconfdir}/openldap/*.conf
  )
}
strip() {
  (cd ${instdir} && \
  find . -name "*.dll" | xargs strip > /dev/null 2>&1
  find . -name "*.exe" | xargs strip > /dev/null 2>&1
  true )
}
list() {
  (cd ${instdir} && \
  find . -name "*" ! -type d | sed 's/\.\/\(.*\)/\1/'
  true )
}
pkg() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg} \
    --exclude="${pnoslash}/bin/*.dll" \
    --exclude="${snoslash}/openldap/schema" \
    --exclude="${snoslash}/openldap/slapd.conf.default" \
    --exclude="${vnoslash}" \
    --exclude="${pnoslash}/include" \
    --exclude="${pnoslash}/lib" \
    --exclude="${pnoslash}/sbin" \
    --exclude="${pnoslash}/libexec" \
    --exclude="${pnoslash}/share/openldap" \
    --exclude="${pnoslash}/share/man/man3" \
    --exclude="${pnoslash}/share/doc/${PKG3}*" \
    --exclude="${pnoslash}/share/doc/Cygwin/${PKG3}*" \
    * ;
  tar cvjf ${bin_pkg2} ${pnoslash}/bin/*.dll ;
  tar cvjf ${bin_pkg3} \
    --exclude="${pnoslash}/bin" \
    --exclude="${snoslash}/openldap/schema" \
    --exclude="${snoslash}/openldap/slapd.conf.default" \
    --exclude="${vnoslash}" \
    --exclude="${pnoslash}/sbin" \
    --exclude="${pnoslash}/libexec" \
    ${pnoslash}/include \
    ${pnoslash}/lib \
    ${pnoslash}/share/openldap \
    ${pnoslash}/share/doc/${PKG3}* \
    ${pnoslash}/share/doc/Cygwin/${PKG3}* \
    ${pnoslash}/share/man/man3
)}
mkpatch() {
  (cd ${srcdir} && \
  find . -name "autom4te.cache" | xargs rm -rf > /dev/null
  tar xv${opt_decomp}f ${src_orig_pkg} ;\
  mv ${PKG}-${VER} ../${PKG}-${VER}-orig && \
  cd ${topdir} && \
  diff -urN -x '.build' -x '.inst' -x '.sinst' \
    ${PKG}-${VER}-orig ${PKG}-${VER} > \
    ${srcinstdir}/${src_patch_name} ; \
  rm -rf ${PKG}-${VER}-orig )
}
spkg() {
  (mkpatch && \
  cp ${src_orig_pkg} ${srcinstdir}/${src_orig_pkg_name} && \
  cp $0 ${srcinstdir}/`basename $0` && \
  cd ${srcinstdir} && \
  tar cvjf ${src_pkg} * )
}
finish() {
  rm -rf ${srcdir} 
  rm ${configurefile} > /dev/null 2>&1 
  rm ${makefile} > /dev/null 2>&1 
  rm ${checkfile} > /dev/null 2>&1 
}
case $1 in
  prep)	         prep ; STATUS=$? ;;
  mkdirs)	mkdirs; STATUS=$? ;;
  conf)	         conf ; STATUS=$? ;;
  build)	build ; STATUS=$? ;;
  check)	check ; STATUS=$? ;;
  clean)	clean ; STATUS=$? ;;
  install)    install ; STATUS=$? ;;
  list)	         list ; STATUS=$? ;;
  strip)	strip ; STATUS=$? ;;
  package)	  pkg ; STATUS=$? ;;
  pkg)	          pkg ; STATUS=$? ;;
  mkpatch)    mkpatch ; STATUS=$? ;;
  src-package)	 spkg ; STATUS=$? ;;
  spkg)	         spkg ; STATUS=$? ;;
  finish)      finish ; STATUS=$? ;;
  all) prep && conf && build && install && \
      strip && pkg  && spkg  && finish ; \
	    STATUS=$? ;;
  *) echo "Error: bad arguments" ; exit 1 ;;
esac
exit ${STATUS}
