.\"

.\" Copyright (c) Mark J. Kilgard, 1996.

.\"

.TH glutReportErrors 3GLUT "3.7" "GLUT" "GLUT"

.SH NAME

glutReportErrors - for debugging purposes; prints out OpenGL run-time errors.

.SH SYNTAX

.nf

.LP

void glutReportErrors(void);

.SH DESCRIPTION

This routine prints out any OpenGL run-time errors pending and clears

the errors.  This routine typically should only be used for debugging purposes

since calling it will slow OpenGL programs.  It is provided as a convenience;

all the routine does is call

.I glGetError

until no more errors are reported.  Any errors detected are reported

with a GLUT warning and the corresponding text message generated by

.I gluErrorString.



Calling glutReportErrors repeatedly in your program can help isolate

OpenGL errors to the offending OpenGL command.  Remember that you

can use the

.I -gldebug

option to detect OpenGL errors in any GLUT program.

.SH SEE ALSO

glutInit, glutCreateWindow, glutInitDisplayMode, gluErrorString, glGetError

.SH AUTHOR

Mark J. Kilgard (mjk@nvidia.com)

