#!/bin/sh
# find out where the build script is located
tdir=`echo "$0" | sed 's%[\\/][^\\/][^\\/]*$%%'`
test "x$tdir" = "x$0" && tdir=.
scriptdir=`cd $tdir; pwd`
# find src directory.  
# If scriptdir ends in SPECS, then topdir is $scriptdir/.. 
# If scriptdir ends in CYGWIN-PATCHES, then topdir is $scriptdir/../..
# Otherwise, we assume that topdir = scriptdir
topdir1=`echo ${scriptdir} | sed 's%/SPECS$%%'`
topdir2=`echo ${scriptdir} | sed 's%/CYGWIN-PATCHES$%%'`
if [ "x$topdir1" != "x$scriptdir" ] ; then # SPECS
  topdir=`cd ${scriptdir}/..; pwd`
else
  if [ "x$topdir2" != "x$scriptdir" ] ; then # CYGWIN-PATCHES
    topdir=`cd ${scriptdir}/../..; pwd`
  else
    topdir=`cd ${scriptdir}; pwd`
  fi
fi

tscriptname=`basename $0 .sh`
export PKG=`echo $tscriptname | sed -e 's/\-[^\-]*\-[^\-]*$//'`
export VER=`echo $tscriptname | sed -e 's/^[^\-]*\-//' -e 's/\-[^\-]*$//'`
export REL=`echo $tscriptname | sed -e 's/^[^\-]*\-[^\-]*\-//'`
# Note that ncurses generates THREE different binary packages:
# 1) ncurses -- includes static libs, import libs, executables, 
#               header files, documentation
# 2) libncurses6 -- includes only the DLLs
# 3) terminfo -- not the REAL cygwin terminfo package. For cygwin, the 
#                terminfo database has been forked for easier updating.
export FULLPKG=${PKG}-${VER}-${REL}
export FULLPKG2=lib${PKG}6-${VER}-${REL}
export FULLPKG3=terminfo-temp

export src_orig_pkg_name=${PKG}-${VER}.tar.gz
export src_pkg_name=${FULLPKG}-src.tar.bz2
export src_pkg_name2=${FULLPKG2}-src.tar.bz2
export src_patch_name=${FULLPKG}.patch
export src_patch_name2=${FULLPKG}-dll.patch
export bin_pkg_name=${FULLPKG}.tar.bz2
export bin_pkg_name2=${FULLPKG2}.tar.bz2
export bin_pkg_name3=${FULLPKG3}.tar.bz2

export src_orig_pkg=${topdir}/${src_orig_pkg_name}
export src_pkg=${topdir}/${src_pkg_name}
export src_pkg2=${topdir}/${src_pkg_name2}
export src_patch=${topdir}/${src_patch_name}
export src_patch2=${topdir}/${src_patch_name2}
export bin_pkg=${topdir}/${bin_pkg_name}
export bin_pkg2=${topdir}/${FULLPKG2}.tar.bz2
export bin_pkg3=${topdir}/${FULLPKG3}.tar.bz2
export srcdir=${topdir}/${PKG}-${VER}
export objdir=${srcdir}/.build
export instdir=${srcdir}/.inst
export srcinstdir=${srcdir}/.sinst
export checkfile=${topdir}/${FULLPKG}-stat.check
export checkfile2=${topdir}/${FULLPKG}-dyn.check
# run on 
host=i686-pc-cygwin
# if this package creates binaries, they run on
target=i686-pc-cygwin
prefix=/usr
sysconfdir=/etc
includedir=${prefix}/include/ncurses
terminfodir=${prefix}/share/terminfo
CFLAGS="-O2"
LINKHEADERS="ncurses.h curses.h form.h menu.h panel.h unctrl.h"

mkdirs() {
  (cd ${topdir} && \
  mkdir -p ${objdir} && \
  mkdir -p ${instdir} && \
  mkdir -p ${srcinstdir} )
}

prep() {
  (cd ${topdir} && \
  tar xvzf ${src_orig_pkg} && \
  cd ${topdir} && \
  patch -p0 < ${src_patch} 
  && mkdirs)
}
conf() {
  (cd ${objdir} && \
  ${srcdir}/configure --host=${host} --target=${target}\
  --srcdir=${srcdir} --prefix=${prefix} \
  --exec-prefix=${prefix} --sysconfdir=${sysconfdir} \
  --libdir=${prefix}/lib --includedir=${includedir} \
  --enable-symlinks --enable-sigwinch --enable-colorfgbg \
  --enable-tcap-names --with-manpage-symlinks --without-debug \
  --with-normal --disable-termcap --enable-broken-linker \
  --with-default-terminfo-dir=${terminfodir} \
  --with-install-prefix=${instdir} \
  --enable-echo )
}
prep-dynamic() {
  (cd ${objdir} && \
  patch -p1 < ${src_patch2} && \
  rm -f c++/*.exe progs/*.exe tack/*.exe test/*.exe && \
  rm -f lib/*.a )
}
build-static() {
  (cd ${objdir} && \
  make CFLAGS=${CFLAGS} )
}
build-dynamic() {
  (cd ${objdir} && \
  make CFLAGS=${CFLAGS} )
}
check-static() {
  (cd ${objdir} && \
  make check | tee ${checkfile} 2>&1 )
}
check-dynamic() {
  (cd ${objdir} && \
  make check | tee ${checkfile2} 2>&1 )
}
clean() {
  (cd ${objdir} && \
  make clean && \
  rm -f config.cache )
}
install-statictest() {
  (cd ${objdir} && \
  mkdir -p ${instdir}${prefix}/bin/ncurses-test-stat && \
  install -m 755 -s test/*.exe ${instdir}${prefix}/bin/ncurses-test-stat && \
  install -m 755 -s c++/demo.exe ${instdir}${prefix}/bin/ncurses-test-stat && \
  mkdir -p ${instdir}${prefix}/bin/ncurses-stat && \
  (cd ${instdir}${prefix}/bin ; mv *.exe ncurses-stat/ ) )
}
install-static() {
  (cd ${objdir} && \
  make install.progs INSTALL=install && \
  make install.libs INSTALL=install && \
  install-statictest )
}
install-dynamictest() {
  (cd ${objdir} && \
  mkdir -p ${instdir}${prefix}/bin/ncurses-test-dll && \
  install -m 755 -s test/*.exe ${instdir}${prefix}/bin/ncurses-test-dll && \
  install -m 755 -s c++/demo.exe ${instdir}${prefix}/bin/ncurses-test-dll )
}
install-dynamic() {
  (cd ${objdir} && \
  make install.progs INSTALL=install && \
  make install.libs INSTALL=install && \
  install-dynamictest && \
  cp lib/cygncurses6.dll progs/ )
}
install-extra() {
  (cd ${objdir} && \
  make install.data INSTALL=install && \
  make install.man INSTALL=install && \
  if [ -f ${instdir}${prefix}/info/dir ] ; then \
    rm ${instdir}${prefix}/info/dir ; \
  fi && \
  if [ ! -d ${instdir}${prefix}/doc/${PKG}-${VER} ]; then \
    mkdir -p ${instdir}${prefix}/doc/${PKG}-${VER} ; \
  fi && \
  if [ ! -d ${instdir}${prefix}/doc/Cygwin ]; then \
    mkdir -p ${instdir}${prefix}/doc/Cygwin ; \
  fi && \
  templist=""; \
  for f in ${srcdir}/README ${srcdir}/NEWS ${srcdir}/ANNOUNCE \
  ${srcdir}/COPYING ${srcdir}/TO-DO ${srcdir}/doc/html/index.html \
  ${srcdir}/doc/html/ncurses-intro.html ${srcdir}/doc/html/announce.html \
  ${srcdir}/doc/html/hackguide.html ${srcdir}/doc/html/Ada95.html; do \
    if [ -f $f ] ; then \
      templist="$templist $f"; \
    fi ; \
  done && \
  if [ ! "x$templist" = "x" ]; then \
    /usr/bin/install -m 644 $templist \
	 ${instdir}${prefix}/doc/${PKG}-${VER} ;
  fi && \
  if [ -f ${srcdir}/CYGWIN-PATCHES/${PKG}.README ]; then \
    /usr/bin/install -m 644 ${srcdir}/CYGWIN-PATCHES/${PKG}.README \
      ${instdir}${prefix}/doc/Cygwin/${PKG}-${VER}.README ; \
  else \
    if [ -f ${srcdir}/CYGWIN-PATCHES/README ]; then \
      /usr/bin/install -m 644 ${srcdir}/CYGWIN-PATCHES/README \
	${instdir}${prefix}/doc/Cygwin/${PKG}-${VER}.README ; \
    fi ;\
  fi ;\
  mv ${instdir}${includedir}/termcap.h ${instdir}${includedir}/termcapn.h && \
  for fn in ${LINKHEADERS}; do \
    (cd ${instdir}${includedir}/..; rm ${fn} ; ln -s ncurses/${fn} ${fn} ) \
  done )
}
mkpatch-static() {
  (cd ${srcdir} && \
  tar xvzf ${src_orig_pkg} && \
  mv ${PKG}-${VER} ../${PKG}-${VER}-orig && \
  cd ${topdir} && \
  diff -urN -x '.build' -x '.inst' -x '.sinst' \
    ${PKG}-${VER}-orig ${PKG}-${VER} > \
    ${srcinstdir}/${src_patch_name} ; \
  rm -rf ${PKG}-${VER}-orig )
}
mkpatch-dynamic() {
  cp ${src_patch2} ${srcinstdir}
}
strip() {
  (cd ${instdir} && \
  find . -name "*.exe" | xargs strip && \
  find . -name "*.dll" | xargs strip )
}
pkg() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg} usr/ \
    --exclude='usr/share/terminfo' --exclude='usr/lib/terminfo' \
    --exclude='usr/bin/ncurses-test-stat' --exclude='usr/bin/ncurses-stat' \
    --exclude='usr/share/tabset' --exclude='usr/bin/*.dll' && \
  tar cvjf ${bin_pkg2} usr/bin/*.dll && \
  tar cvjf ${bin_pkg3} \
    usr/share/terminfo usr/lib/terminfo usr/share/tabset )
}
spkg() {
  (mkpatch-static && mkpatch-dynamic && \
  cp ${src_orig_pkg} ${srcinstdir}/${src_orig_pkg_name} && \
  cp $0 ${srcinstdir}/`basename $0` && \
  cd ${srcinstdir} && \
  tar cvjf ${src_pkg} * && \
  cd ${srcdir}/CYGWIN-PATCHES && \
  cp -a libncurses6-src ${FULLPKG2} && \
  tar cvjf ${src_pkg2} ${FULLPKG2} && \
  rm -rf ${FULLPKG2} )
}
finish() {
  rm -rf ${srcdir}
}
case $1 in
  prep)	prep ; STATUS=$? ;;
  prep-dynamic)	prep-dynamic ; STATUS=$? ;;
  conf)	conf ; STATUS=$? ;;
  build-static)	build-static ; STATUS=$? ;;
  build-dynamic)	build-dynamic ; STATUS=$? ;;
  check-static)	check-static ; STATUS=$? ;;
  check-dynamic)	check-dynamic; STATUS=$? ;;
  clean)	clean ; STATUS=$? ;;
  install-static)	install-static ; STATUS=$? ;;
  install-dynamic)	install-dynamic; STATUS=$? ;;
  install-extra)	install-extra; STATUS=$? ;;
  strip)	strip ; STATUS=$? ;;
  mkpatch-static) mkdirs ; mkpatch-static ; STATUS=$? ;;
  mkpatch-dynamic) mkdirs ; mkpatch-dynamic ; STATUS=$? ;;
  package)	pkg ; STATUS=$? ;;
  pkg)	pkg ; STATUS=$? ;;
  src-package)	spkg ; STATUS=$? ;;
  spkg)	spkg ; STATUS=$? ;;
  finish) finish ; STATUS=$? ;;
  all) prep && conf && build-static && install-static && \
       prep-dynamic && build-dynamic && install-dynamic && \
       install-extra && strip && pkg && spkg && finish && STATUS=$? ;;
  *) echo "Error: bad arguments" ; exit 1 ;;
esac
exit ${STATUS}
