/*
 * keys.h: header for keys.c 
 *
 * Written By Michael Sandrof
 *
 * Copyright (c) 1990 Michael Sandrof.
 * Copyright (c) 1991, 1992 Troy Rollo.
 * Copyright (c) 1992-2000 Matthew R. Green.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * NOTE: This file is automatically created!
 *
 * from: @(#) Id: keys.h.proto,v 1.20 2000/04/04 03:10:49 mrg Exp 
 * @(#)$Id: keys.h,v 1.1.1.1 2001/05/18 21:28:05 corinna Exp $
 */

#ifndef __keys_h_
#define __keys_h_

#define BACKSPACE 0
#define BACKWARD_CHARACTER 1
#define BACKWARD_HISTORY 2
#define BACKWARD_WORD 3
#define BEGINNING_OF_LINE 4
#define CLEAR_SCREEN 5
#define COMMAND_COMPLETION 6
#define DELETE_CHARACTER 7
#define DELETE_NEXT_WORD 8
#define DELETE_PREVIOUS_WORD 9
#define END_OF_LINE 10
#define ENTER_DIGRAPH 11
#define	ENTER_MENU 12
#define ERASE_LINE 13
#define ERASE_TO_BEG_OF_LINE 14
#define ERASE_TO_END_OF_LINE 15
#define FORWARD_CHARACTER 16
#define FORWARD_HISTORY 17
#define FORWARD_WORD 18
#define META1_CHARACTER 19
#define META2_CHARACTER 20
#define META3_CHARACTER 21
#define META4_CHARACTER 22
#define META5_CHARACTER 23
#define META6_CHARACTER 24
#define META7_CHARACTER 25
#define META8_CHARACTER 26
#define NEXT_WINDOW 27
#define NOTHING 28
#define PARSE_COMMAND 29
#define PREVIOUS_WINDOW 30
#define QUIT_IRC 31
#define QUOTE_CHARACTER 32
#define REFRESH_INPUTLINE 33
#define REFRESH_SCREEN 34
#define	SCROLL_BACKWARD 35
#define	SCROLL_END 36
#define SCROLL_FORWARD 37
#define SCROLL_START 38
#define SELF_INSERT 39
#define SEND_LINE 40
#define STOP_IRC 41
#define SWAP_LAST_WINDOW 42
#define SWAP_NEXT_WINDOW 43
#define SWAP_PREVIOUS_WINDOW 44
#define SWITCH_CHANNELS 45
#define TOGGLE_INSERT_MODE 46
#define TOGGLE_STOP_SCREEN 47
#define TRANSPOSE_CHARACTERS 48
#define TYPE_TEXT 49
#define UNSTOP_ALL_WINDOWS 50
#define YANK_FROM_CUTBUFFER 51
#define NUMBER_OF_FUNCTIONS 52

/* KeyMap: the structure of the irc keymaps */
typedef struct
{
	int	index;
	u_char	changed;
	int	global;
	u_char	*stuff;
}	KeyMap;

/* KeyMapNames: the structure of the keymap to realname array */
typedef struct
{
	char	*name;
	void	(*func) _((u_int, u_char *));
}	KeyMapNames;

extern	KeyMap	keys[],
		meta1_keys[],
		meta2_keys[],
		meta3_keys[],
		meta4_keys[],
		meta5_keys[],
		meta6_keys[],
		meta7_keys[],
		meta8_keys[];
extern	KeyMapNames key_names[];

	void	(* get_send_line _((void))) _((u_int, u_char *));
	void	save_bindings _((FILE *, int));
	void	change_send_line _((void (*)(u_int, u_char *)));
	void	bindcmd _((u_char *, u_char *, u_char *));
	void	rbindcmd _((u_char *, u_char *, u_char *));
	void	parsekeycmd _((u_char *, u_char *, u_char *));
	void	type _((u_char *, u_char *, u_char *));

#endif /* __keys_h_ */
