#!/bin/bash
#
# iniscripts.sh, the configuration script for initscripts, derived from
# RedHat iu-config for cygwin
#
# This file is part of the Cygwin initscripts package.

# set -x

# Directory where the config files are stored
SYSCONFDIR=/etc

# Check for ${SYSCONFDIR} directory

if [ -e "${SYSCONFDIR}" -a ! -d "${SYSCONFDIR}" ]
then
  echo
  echo "${SYSCONFDIR} is existant but not a directory."
  echo "Cannot create global configuration files."
  echo
  exit 1
fi

# Create it if necessary

if [ ! -e "${SYSCONFDIR}" ]
then
  mkdir "${SYSCONFDIR}"
  if [ ! -e "${SYSCONFDIR}" ]
  then
    echo
    echo "Creating ${SYSCONFDIR} directory failed"
    echo
    exit 1
  fi
fi

# Check if inittab exists. If yes, rename it

outfile="${SYSCONFDIR}/inittab"

if [ -f "${SYSCONFDIR}/inittab" ]
then
  mv "${SYSCONFDIR}/inittab" "${SYSCONFDIR}/inittab.pkgsave"
  if [ -f "${SYSCONFDIR}/inittab" ]
  then
    echo
    echo "Can't rename inittab. ${SYSCONFDIR} is write protected?"
    echo
    outfile="${SYSCONFDIR}/inittab.initscripts"
  fi
fi
cat > ${outfile} << \EOF
#
# inittab       This file describes how the INIT process should set up
#               the system in a certain run-level.
#
# Author:       Miquel van Smoorenburg, <miquels@drinkel.nl.mugnet.org>
#               Modified for RHS Linux by Marc Ewing and Donnie Barnes
#

# Default runlevel. The runlevels used by RHS are:
#   0 - halt (Do NOT set initdefault to this)
#   1 - Single user mode
#   2 - Multiuser, without NFS (The same as 3, if you do not have networking)
#   3 - Full multiuser mode
#   4 - unused
#   5 - X11
#   6 - reboot (Do NOT set initdefault to this)
# 
id:3:initdefault:

# System initialization.
si::sysinit:/etc/rc.d/rc.sysinit

l0:0:wait:/etc/rc.d/rc 0
l1:1:wait:/etc/rc.d/rc 1
l2:2:wait:/etc/rc.d/rc 2
l3:3:wait:/etc/rc.d/rc 3
l4:4:wait:/etc/rc.d/rc 4
l5:5:wait:/etc/rc.d/rc 5
l6:6:wait:/etc/rc.d/rc 6

# Things to run in every runlevel.
#ud::once:/sbin/update

# Trap CTRL-ALT-DELETE (SIGINT on cygwin)
#ca::ctrlaltdel:/sbin/shutdown -t3 -r now

# When our UPS tells us power has failed, assume we have a few minutes
# of power left.  Schedule a shutdown for 2 minutes from now.
# This does, of course, assume you have powerd installed and your
# UPS connected and working correctly.  
#pf::powerfail:/sbin/shutdown -f -h +2 "Power Failure; System Shutting Down"

# If power was restored before the shutdown kicked in, cancel it.
#pr:12345:powerokwait:/sbin/shutdown -c "Power Restored; Shutdown Cancelled"


# Run agettys in standard runlevels
#S0:2345:respawn:/sbin/agetty -L -T vt100 -n ttyS0 9600 ttyS0

# Run xdm in runlevel 5
# xdm is now a separate service
#x:5:respawn:/etc/X11/prefdm -nodaemon
EOF
chmod 644 ${outfile}
echo
echo "Configuration finished. Have fun!"

