/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractCollection
implements Collection {
    protected AbstractCollection() {
    }

    public abstract Iterator iterator();

    public abstract int size();

    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection c) {
        Iterator itr = c.iterator();
        boolean modified = false;
        int pos = c.size();
        while (--pos >= 0) {
            modified |= this.add(itr.next());
        }
        return modified;
    }

    public void clear() {
        Iterator itr = this.iterator();
        int pos = this.size();
        while (--pos >= 0) {
            itr.next();
            itr.remove();
        }
    }

    public boolean contains(Object o) {
        Iterator itr = this.iterator();
        int pos = this.size();
        while (--pos >= 0) {
            if (!AbstractCollection.equals(o, itr.next())) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection c) {
        Iterator itr = c.iterator();
        int pos = c.size();
        while (--pos >= 0) {
            if (this.contains(itr.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean remove(Object o) {
        Iterator itr = this.iterator();
        int pos = this.size();
        while (--pos >= 0) {
            if (!AbstractCollection.equals(o, itr.next())) continue;
            itr.remove();
            return true;
        }
        return false;
    }

    public boolean removeAll(Collection c) {
        return this.removeAllInternal(c);
    }

    boolean removeAllInternal(Collection c) {
        Iterator itr = this.iterator();
        boolean modified = false;
        int pos = this.size();
        while (--pos >= 0) {
            if (!c.contains(itr.next())) continue;
            itr.remove();
            modified = true;
        }
        return modified;
    }

    public boolean retainAll(Collection c) {
        return this.retainAllInternal(c);
    }

    boolean retainAllInternal(Collection c) {
        Iterator itr = this.iterator();
        boolean modified = false;
        int pos = this.size();
        while (--pos >= 0) {
            if (c.contains(itr.next())) continue;
            itr.remove();
            modified = true;
        }
        return modified;
    }

    public Object[] toArray() {
        Iterator itr = this.iterator();
        int size = this.size();
        Object[] a = new Object[size];
        for (int pos = 0; pos < size; ++pos) {
            a[pos] = itr.next();
        }
        return a;
    }

    public Object[] toArray(Object[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        } else if (a.length > size) {
            a[size] = null;
        }
        Iterator itr = this.iterator();
        for (int pos = 0; pos < size; ++pos) {
            a[pos] = itr.next();
        }
        return a;
    }

    public String toString() {
        Iterator itr = this.iterator();
        StringBuffer r = new StringBuffer("[");
        for (int pos = this.size(); pos > 0; --pos) {
            r.append(itr.next());
            if (pos <= 1) continue;
            r.append(", ");
        }
        r.append("]");
        return r.toString();
    }

    static final boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    static final int hashCode(Object o) {
        if (o == null) {
            return 0;
        }
        return o.hashCode();
    }
}

