/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AttributeValue;

public final class JobAttributes
implements Cloneable {
    private int copies;
    private DefaultSelectionType selection;
    private DestinationType destination;
    private DialogType dialog;
    private String filename;
    private int maxPage;
    private int minPage;
    private MultipleDocumentHandlingType multiple;
    private int[][] pageRanges;
    private int fromPage;
    private int toPage;
    private String printer;
    private SidesType sides;

    public JobAttributes() {
        this.copies = 1;
        this.selection = DefaultSelectionType.ALL;
        this.destination = DestinationType.PRINTER;
        this.dialog = DialogType.NATIVE;
        this.maxPage = Integer.MAX_VALUE;
        this.minPage = 1;
        this.multiple = MultipleDocumentHandlingType.SEPARATE_DOCUMENTS_UNCOLLATED_COPIES;
        this.sides = SidesType.ONE_SIDED;
    }

    public JobAttributes(JobAttributes attr) {
        this.set(attr);
    }

    public JobAttributes(int copies, DefaultSelectionType selection, DestinationType destination, DialogType dialog, String filename, int max, int min, MultipleDocumentHandlingType multiple, int[][] pageRanges, String printer, SidesType sides) {
        if (copies <= 0 || selection == null || destination == null || dialog == null || max < min || min <= 0 || multiple == null || sides == null) {
            throw new IllegalArgumentException();
        }
        this.copies = copies;
        this.selection = selection;
        this.destination = destination;
        this.dialog = dialog;
        this.filename = filename;
        this.maxPage = max;
        this.minPage = min;
        this.multiple = multiple;
        this.setPageRanges(pageRanges);
        this.printer = printer;
        this.sides = sides;
    }

    public Object clone() {
        return new JobAttributes(this);
    }

    public void set(JobAttributes attr) {
        this.copies = attr.copies;
        this.selection = attr.selection;
        this.destination = attr.destination;
        this.dialog = attr.dialog;
        this.filename = attr.filename;
        this.maxPage = attr.maxPage;
        this.minPage = attr.minPage;
        this.multiple = attr.multiple;
        this.pageRanges = (int[][])attr.pageRanges.clone();
        this.printer = attr.printer;
        this.sides = attr.sides;
        this.fromPage = attr.fromPage;
        this.toPage = attr.toPage;
    }

    public int getCopies() {
        return this.copies;
    }

    public void setCopies(int copies) {
        if (copies <= 0) {
            throw new IllegalArgumentException();
        }
        this.copies = copies;
    }

    public void setCopiesToDefault() {
        this.copies = 1;
    }

    public DefaultSelectionType getDefaultSelection() {
        return this.selection;
    }

    public void setDefaultSelection(DefaultSelectionType selection) {
        if (selection == null) {
            throw new IllegalArgumentException();
        }
        this.selection = selection;
    }

    public DestinationType getDestination() {
        return this.destination;
    }

    public void setDestination(DestinationType destination) {
        if (destination == null) {
            throw new IllegalArgumentException();
        }
        this.destination = destination;
    }

    public DialogType getDialog() {
        return this.dialog;
    }

    public void setDialog(DialogType dialog) {
        if (dialog == null) {
            throw new IllegalArgumentException();
        }
        this.dialog = dialog;
    }

    public String getFileName() {
        return this.filename;
    }

    public void setFileName(String filename) {
        this.filename = filename;
    }

    public int getFromPage() {
        if (this.fromPage != 0) {
            return this.fromPage;
        }
        if (this.pageRanges != null) {
            return this.pageRanges[0][0];
        }
        if (this.toPage != 0) {
            return this.toPage;
        }
        return this.minPage;
    }

    public void setFromPage(int fromPage) {
        if (fromPage < this.minPage || fromPage > this.toPage && this.toPage != 0 || fromPage > this.maxPage) {
            throw new IllegalArgumentException();
        }
        if (this.pageRanges == null) {
            this.fromPage = fromPage;
        }
    }

    public int getMaxPage() {
        return this.maxPage;
    }

    public void setMaxPage(int maxPage) {
        if (maxPage < this.minPage) {
            throw new IllegalArgumentException();
        }
        this.maxPage = maxPage;
        if (maxPage < this.fromPage) {
            this.fromPage = maxPage;
        }
        if (maxPage < this.toPage) {
            this.toPage = maxPage;
        }
        if (this.pageRanges != null) {
            int i;
            for (i = this.pageRanges.length - 1; i >= 0 && maxPage < this.pageRanges[i][1]; --i) {
            }
            if (maxPage >= this.pageRanges[++i][0]) {
                this.pageRanges[i++][1] = maxPage;
            }
            if (i == 0) {
                this.pageRanges = null;
            } else if (i < this.pageRanges.length) {
                int[][] tmp = new int[i][];
                System.arraycopy(this.pageRanges, 0, tmp, 0, i);
                this.pageRanges = tmp;
            }
        }
    }

    public int getMinPage() {
        return this.minPage;
    }

    public void setMinPage(int minPage) {
        if (minPage <= 0 || minPage > this.maxPage) {
            throw new IllegalArgumentException();
        }
        this.minPage = minPage;
        if (minPage > this.toPage) {
            this.toPage = minPage;
        }
        if (minPage > this.fromPage) {
            this.fromPage = minPage;
        }
        if (this.pageRanges != null) {
            int i;
            int size = this.pageRanges.length;
            for (i = 0; i < size && minPage > this.pageRanges[i][0]; ++i) {
            }
            if (minPage <= this.pageRanges[i - 1][1]) {
                this.pageRanges[--i][0] = minPage;
            }
            if (i == size) {
                this.pageRanges = null;
            } else if (i > 0) {
                int[][] tmp = new int[size - i][];
                System.arraycopy(this.pageRanges, i, tmp, 0, size - i);
                this.pageRanges = tmp;
            }
        }
    }

    public MultipleDocumentHandlingType getMultipleDocumentHandling() {
        return this.multiple;
    }

    public void setMultipleDocumentHandling(MultipleDocumentHandlingType multiple) {
        if (multiple == null) {
            throw new IllegalArgumentException();
        }
        this.multiple = multiple;
    }

    public void setMultipleDocumentHandlingToDefault() {
        this.multiple = MultipleDocumentHandlingType.SEPARATE_DOCUMENTS_UNCOLLATED_COPIES;
    }

    public int[][] getPageRanges() {
        if (this.pageRanges == null) {
            return new int[][]{{this.getFromPage(), this.getToPage()}};
        }
        int i = this.pageRanges.length;
        int[][] result = new int[i][];
        while (--i >= 0) {
            result[i] = (int[])this.pageRanges[i].clone();
        }
        return result;
    }

    public void setPageRanges(int[][] pageRanges) {
        int size;
        int n = size = pageRanges == null ? 0 : pageRanges.length;
        if (size == 0) {
            throw new IllegalArgumentException();
        }
        while (--size >= 0) {
            int[] range = pageRanges[size];
            if (range != null && range.length == 2 && range[0] >= this.minPage && range[1] >= range[0] && range[1] <= this.maxPage && (size == 0 || range[0] > pageRanges[size - 1][1])) continue;
            throw new IllegalArgumentException();
        }
        size = pageRanges.length;
        if (this.fromPage > 0 && pageRanges[0][0] > this.fromPage) {
            this.fromPage = pageRanges[0][0];
        }
        if (this.toPage > 0 && pageRanges[size - 1][1] < this.toPage) {
            this.toPage = pageRanges[size - 1][1];
        }
        this.pageRanges = new int[size][];
        while (--size >= 0) {
            this.pageRanges[size] = (int[])pageRanges[size].clone();
        }
    }

    public String getPrinter() {
        return this.printer;
    }

    public void setPrinter(String printer) {
        this.printer = printer;
    }

    public SidesType getSides() {
        return this.sides;
    }

    public void setSides(SidesType sides) {
        if (sides == null) {
            throw new IllegalArgumentException();
        }
        this.sides = sides;
    }

    public void setSidesToDefault() {
        this.sides = SidesType.ONE_SIDED;
    }

    public int getToPage() {
        if (this.toPage != 0) {
            return this.toPage;
        }
        if (this.pageRanges != null) {
            return this.pageRanges[this.pageRanges.length - 1][1];
        }
        if (this.fromPage != 0) {
            return this.fromPage;
        }
        return this.maxPage;
    }

    public void setToPage(int toPage) {
        if (toPage < this.minPage || this.fromPage > toPage && this.fromPage != 0 || toPage > this.maxPage) {
            throw new IllegalArgumentException();
        }
        if (this.pageRanges == null) {
            this.toPage = toPage;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JobAttributes)) {
            return false;
        }
        JobAttributes ja = (JobAttributes)o;
        if (this.copies != ja.copies || this.selection != ja.selection || this.destination != ja.destination || this.dialog != ja.dialog || !this.filename.equals(ja.filename) || this.maxPage != ja.maxPage || this.minPage != ja.minPage || this.multiple != ja.multiple || this.fromPage != ja.fromPage || this.toPage != ja.toPage || !this.printer.equals(ja.printer) || this.sides != ja.sides || this.pageRanges == null != (ja.pageRanges == null)) {
            return false;
        }
        if (this.pageRanges != ja.pageRanges) {
            int i = this.pageRanges.length;
            while (--i >= 0) {
                if (this.pageRanges[i][0] == ja.pageRanges[i][0] && this.pageRanges[i][1] == ja.pageRanges[i][1]) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hash = this.selection.value << 6 ^ this.destination.value << 5 ^ this.dialog.value << 3 ^ this.multiple.value << 2 ^ this.sides.value ^ (this.filename == null ? 0 : this.filename.hashCode()) ^ (this.printer == null ? 0 : this.printer.hashCode());
        hash ^= this.copies << 27 ^ this.maxPage << 22 ^ this.minPage << 17;
        if (this.pageRanges == null) {
            hash ^= this.getFromPage() << 13 ^ this.getToPage() << 8;
        } else {
            int i = this.pageRanges.length;
            while (--i >= 0) {
                hash ^= this.pageRanges[i][0] << 13 ^ this.pageRanges[i][1] << 8;
            }
        }
        return hash;
    }

    public String toString() {
        StringBuffer s = new StringBuffer("copies=").append(this.copies).append(",defaultSelection=").append(this.selection).append(",destination=").append(this.destination).append(",dialog=").append(this.dialog).append(",fileName=").append(this.filename).append(",fromPage=").append(this.getFromPage()).append(",maxPage=").append(this.maxPage).append(",minPage=").append(this.minPage).append(",multiple-document-handling=").append(this.multiple).append(",page-ranges=[");
        if (this.pageRanges == null) {
            s.append(this.minPage).append(':').append(this.minPage).append(']');
        } else {
            for (int i = 0; i < this.pageRanges.length; ++i) {
                s.append(this.pageRanges[i][0]).append(':').append(this.pageRanges[i][1]).append(',');
            }
        }
        s.setLength(s.length() - 1);
        return s.append("],printer=").append(this.printer).append(",sides=").append(this.sides).append(",toPage=").append(this.getToPage()).toString();
    }

    public static final class SidesType
    extends AttributeValue {
        private static final String[] NAMES = new String[]{"one-sided", "two-sided-long-edge", "two-sided-short-edge"};
        public static final SidesType ONE_SIDED = new SidesType(0);
        public static final SidesType TWO_SIDED_LONG_EDGE = new SidesType(1);
        public static final SidesType TWO_SIDED_SHORT_EDGE = new SidesType(2);

        private SidesType(int value) {
            super(value, NAMES);
        }
    }

    public static final class MultipleDocumentHandlingType
    extends AttributeValue {
        private static final String[] NAMES = new String[]{"separate-documents-collated-copies", "separate-documents-uncollated-copies"};
        public static final MultipleDocumentHandlingType SEPARATE_DOCUMENTS_COLLATED_COPIES = new MultipleDocumentHandlingType(0);
        public static final MultipleDocumentHandlingType SEPARATE_DOCUMENTS_UNCOLLATED_COPIES = new MultipleDocumentHandlingType(1);

        private MultipleDocumentHandlingType(int value) {
            super(value, NAMES);
        }
    }

    public static final class DialogType
    extends AttributeValue {
        private static final String[] NAMES = new String[]{"common", "native", "none"};
        public static final DialogType COMMON = new DialogType(0);
        public static final DialogType NATIVE = new DialogType(1);
        public static final DialogType NONE = new DialogType(2);

        private DialogType(int value) {
            super(value, NAMES);
        }
    }

    public static final class DestinationType
    extends AttributeValue {
        private static final String[] NAMES = new String[]{"file", "printer"};
        public static final DestinationType FILE = new DestinationType(0);
        public static final DestinationType PRINTER = new DestinationType(1);

        private DestinationType(int value) {
            super(value, NAMES);
        }
    }

    public static final class DefaultSelectionType
    extends AttributeValue {
        private static final String[] NAMES = new String[]{"all", "range", "selection"};
        public static final DefaultSelectionType ALL = new DefaultSelectionType(0);
        public static final DefaultSelectionType RANGE = new DefaultSelectionType(1);
        public static final DefaultSelectionType SELECTION = new DefaultSelectionType(2);

        private DefaultSelectionType(int value) {
            super(value, NAMES);
        }
    }
}

