/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

final class UTF_16Decoder
extends CharsetDecoder {
    static final int BIG_ENDIAN = 0;
    static final int LITTLE_ENDIAN = 1;
    static final int UNKNOWN_ENDIAN = 2;
    private static final char BYTE_ORDER_MARK = '\ufeff';
    private static final char REVERSED_BYTE_ORDER_MARK = '\ufffe';
    private final int originalByteOrder;
    private int byteOrder;

    UTF_16Decoder(Charset cs, int byteOrder) {
        super(cs, 0.5f, 1.0f);
        this.originalByteOrder = byteOrder;
        this.byteOrder = byteOrder;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
        CoderResult coderResult;
        int inPos;
        block15: {
            CoderResult coderResult2;
            block14: {
                CoderResult coderResult3;
                block13: {
                    CoderResult coderResult4;
                    block12: {
                        inPos = in.position();
                        try {
                            while (in.remaining() >= 2) {
                                char c;
                                byte b1 = in.get();
                                byte b2 = in.get();
                                if (this.byteOrder == 2) {
                                    c = (char)(b1 << 8 | b2);
                                    if (c == '\ufeff') {
                                        this.byteOrder = 0;
                                        inPos += 2;
                                        continue;
                                    }
                                    if (c == '\ufffe') {
                                        this.byteOrder = 1;
                                        inPos += 2;
                                        continue;
                                    }
                                    this.byteOrder = 0;
                                }
                                char c2 = c = this.byteOrder == 0 ? (char)(b1 << 8 | b2) : (char)(b2 << 8 | b1);
                                if ('\ud800' <= c && c <= '\udfff') {
                                    char d;
                                    if (c > '\udbff') {
                                        CoderResult coderResult5 = CoderResult.malformedForLength(2);
                                        Object var11_15 = null;
                                        in.position(inPos);
                                        return coderResult5;
                                    }
                                    if (in.remaining() < 2) {
                                        coderResult4 = CoderResult.UNDERFLOW;
                                        break block12;
                                    }
                                    byte b3 = in.get();
                                    byte b4 = in.get();
                                    char c3 = d = this.byteOrder == 0 ? (char)(b3 << 8 | b4) : (char)(b4 << 8 | b3);
                                    if (d < '\udc00' || d > '\udfff') {
                                        coderResult3 = CoderResult.malformedForLength(2);
                                        break block13;
                                    } else {
                                        out.put(c);
                                        out.put(d);
                                        inPos += 4;
                                        continue;
                                    }
                                }
                                if (!out.hasRemaining()) {
                                    coderResult2 = CoderResult.UNDERFLOW;
                                    break block14;
                                }
                                out.put(c);
                                inPos += 2;
                            }
                            coderResult = CoderResult.UNDERFLOW;
                            break block15;
                        }
                        catch (Throwable throwable) {
                            Object var11_20 = null;
                            in.position(inPos);
                            throw throwable;
                        }
                    }
                    Object var11_16 = null;
                    in.position(inPos);
                    return coderResult4;
                }
                Object var11_17 = null;
                in.position(inPos);
                return coderResult3;
            }
            Object var11_18 = null;
            in.position(inPos);
            return coderResult2;
        }
        Object var11_19 = null;
        in.position(inPos);
        return coderResult;
    }

    private void put(ByteBuffer out, char c) {
        if (this.byteOrder == 0) {
            out.put((byte)(c >> 8));
            out.put((byte)c);
        } else {
            out.put((byte)c);
            out.put((byte)(c >> 8));
        }
    }

    protected void implReset() {
        this.byteOrder = this.originalByteOrder;
    }
}

