/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.util.Collection;

public class CertificateFactory {
    private CertificateFactorySpi certFacSpi;
    private Provider provider;
    private String type;

    protected CertificateFactory(CertificateFactorySpi certFacSpi, Provider provider, String type) {
        this.certFacSpi = certFacSpi;
        this.provider = provider;
        this.type = type;
    }

    public static final CertificateFactory getInstance(String type) throws CertificateException {
        Provider[] p = Security.getProviders();
        for (int i = 0; i < p.length; ++i) {
            String classname = p[i].getProperty("CertificateFactory." + type);
            if (classname == null) continue;
            return CertificateFactory.getInstance(classname, type, p[i]);
        }
        throw new CertificateException(type);
    }

    public static final CertificateFactory getInstance(String type, String provider) throws CertificateException, NoSuchProviderException {
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException();
        }
        return CertificateFactory.getInstance(p.getProperty("CertificateFactory." + type), type, p);
    }

    private static CertificateFactory getInstance(String classname, String type, Provider provider) throws CertificateException {
        try {
            return new CertificateFactory((CertificateFactorySpi)Class.forName(classname).newInstance(), provider, type);
        }
        catch (ClassNotFoundException cnfe) {
            throw new CertificateException("Class not found");
        }
        catch (InstantiationException ie) {
            throw new CertificateException("Class instantiation failed");
        }
        catch (IllegalAccessException iae) {
            throw new CertificateException("Illegal Access");
        }
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getType() {
        return this.type;
    }

    public final Certificate generateCertificate(InputStream inStream) throws CertificateException {
        return this.certFacSpi.engineGenerateCertificate(inStream);
    }

    public final Collection generateCertificates(InputStream inStream) throws CertificateException {
        return this.certFacSpi.engineGenerateCertificates(inStream);
    }

    public final CRL generateCRL(InputStream inStream) throws CRLException {
        return this.certFacSpi.engineGenerateCRL(inStream);
    }

    public final Collection generateCRLs(InputStream inStream) throws CRLException {
        return this.certFacSpi.engineGenerateCRLs(inStream);
    }

    public final CertPath generateCertPath(InputStream inStream) throws CertificateException {
        throw new CertificateException("not implemented");
    }
}

