/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;

public abstract class Reader {
    protected Object lock;

    protected Reader() {
        this.lock = this;
    }

    protected Reader(Object lock) {
        this.lock = lock;
    }

    public abstract int read(char[] var1, int var2, int var3) throws IOException;

    public int read(char[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read() throws IOException {
        char[] buf = new char[1];
        int count = this.read(buf, 0, 1);
        if (count > 0) {
            return buf[0];
        }
        return -1;
    }

    public abstract void close() throws IOException;

    public boolean markSupported() {
        return false;
    }

    public void mark(int readLimit) throws IOException {
        throw new IOException("mark not supported");
    }

    public void reset() throws IOException {
        throw new IOException("reset not supported");
    }

    public boolean ready() throws IOException {
        return false;
    }

    public long skip(long count) throws IOException {
        long todo;
        if (count <= 0L) {
            return 0L;
        }
        int bsize = count > (long)1024 ? 1024 : (int)count;
        char[] buffer = new char[bsize];
        Object object = this.lock;
        synchronized (object) {
            try {
                int skipped;
                for (todo = count; todo > 0L && (skipped = this.read(buffer, 0, (long)bsize > todo ? (int)todo : bsize)) > 0; todo -= (long)skipped) {
                }
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                throw throwable;
            }
        }
        long l = count - todo;
        return l;
    }
}

