/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.InputStream;

public class ByteArrayInputStream
extends InputStream {
    protected byte[] buf;
    protected int pos;
    protected int mark;
    protected int count;

    public ByteArrayInputStream(byte[] buffer) {
        this(buffer, 0, buffer.length);
    }

    public ByteArrayInputStream(byte[] buffer, int offset, int length) {
        if (offset < 0 || length < 0 || offset > buffer.length) {
            throw new IllegalArgumentException();
        }
        this.buf = buffer;
        this.count = offset + length;
        if (this.count > this.buf.length) {
            this.count = this.buf.length;
        }
        this.mark = this.pos = offset;
    }

    public synchronized int available() {
        return this.count - this.pos;
    }

    public synchronized void mark(int readAheadLimit) {
        this.mark = this.pos;
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized int read() {
        if (this.pos < this.count) {
            return this.buf[this.pos++] & 0xFF;
        }
        return -1;
    }

    public synchronized int read(byte[] b, int off, int len) {
        if (this.pos >= this.count) {
            return -1;
        }
        int numBytes = Math.min(this.count - this.pos, len);
        System.arraycopy(this.buf, this.pos, b, off, numBytes);
        this.pos += numBytes;
        return numBytes;
    }

    public synchronized void reset() {
        this.pos = this.mark;
    }

    public synchronized long skip(long n) {
        long numBytes = Math.min((long)(this.count - this.pos), n < 0L ? 0L : n);
        this.pos += (int)numBytes;
        return numBytes;
    }
}

