/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.provider;

import gnu.java.security.util.Prime;
import java.math.BigInteger;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Random;

public class DSAParameterGenerator
extends AlgorithmParameterGeneratorSpi {
    private int size;
    private SecureRandom random;

    private /* synthetic */ void finit$() {
        this.random = null;
    }

    public DSAParameterGenerator() {
        this.finit$();
        this.size = 1024;
    }

    public void engineInit(int size, SecureRandom random) {
        if (size < 512 || size > 1024 || size % 64 != 0) {
            return;
        }
        this.size = size;
        this.random = random;
    }

    public void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(genParamSpec instanceof DSAParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Must be DSAParameterSpec");
        }
        DSAParameterSpec dsaparameterspec = (DSAParameterSpec)genParamSpec;
        int tmp = dsaparameterspec.getP().bitLength();
        if (tmp < 512 || tmp > 1024 || tmp % 64 != 0) {
            throw new InvalidAlgorithmParameterException("Invalid Size");
        }
        this.random = random;
    }

    public AlgorithmParameters engineGenerateParameters() {
        BigInteger g;
        int L = this.size;
        BigInteger r = Prime.generateRandomPrime(159, 160, BigInteger.valueOf(1L));
        BigInteger p = Prime.generateRandomPrime(r, BigInteger.valueOf(1L), L - 1, L, BigInteger.valueOf(1L));
        BigInteger k = p.subtract(BigInteger.valueOf(1L));
        k = k.divide(r);
        Random rand = new Random();
        BigInteger h = BigInteger.valueOf(1L);
        while ((g = (h = h.add(BigInteger.valueOf(1L))).modPow(k, p)).compareTo(BigInteger.valueOf(1L)) == 1) {
        }
        try {
            DSAParameterSpec dsaparameterspec = new DSAParameterSpec(p, r, g);
            AlgorithmParameters ap = AlgorithmParameters.getInstance("DSA");
            ap.init(dsaparameterspec);
            return ap;
        }
        catch (NoSuchAlgorithmException nsae) {
            return null;
        }
        catch (InvalidParameterSpecException ipse) {
            return null;
        }
    }
}

