/*
 * Decompiled with CFR 0.152.
 */
package gnu.awt.j2d;

import gnu.awt.j2d.AbstractGraphicsState;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;

public class Graphics2DImpl
extends Graphics2D
implements Cloneable {
    GraphicsConfiguration config;
    AbstractGraphicsState state;
    Color fg;
    Color bg;
    Font font;

    public Graphics2DImpl(GraphicsConfiguration config) {
        this.config = config;
    }

    public void setState(AbstractGraphicsState state) {
        this.state = state;
        this.state.setFrontend(this);
    }

    public Object clone() {
        Graphics2DImpl gfxCopy = (Graphics2DImpl)super.clone();
        AbstractGraphicsState stateCopy = (AbstractGraphicsState)this.state.clone();
        gfxCopy.setState(stateCopy);
        return gfxCopy;
    }

    public Graphics create() {
        Graphics2DImpl gfxCopy = (Graphics2DImpl)this.clone();
        return gfxCopy;
    }

    public Color getColor() {
        return this.fg;
    }

    public void setColor(Color color) {
        this.fg = color;
        this.state.setColor(color);
    }

    public void setPaintMode() {
        this.state.setPaintMode();
    }

    public void setXORMode(Color altColor) {
        this.state.setXORMode(altColor);
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
        this.state.setFont(font);
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.state.getFontMetrics(font);
    }

    public Rectangle getClipBounds() {
        return this.state.getClipBounds();
    }

    public void clipRect(int x, int y, int width, int height) {
        Shape clip = this.state.getClip();
        if (clip instanceof Rectangle) {
            Rectangle clipRect = (Rectangle)clip;
            clip = clipRect.intersection(new Rectangle(x, y, width, height));
            this.setClip(clip);
            return;
        }
        String msg = "intersecting current clip shape " + clip + " with new rectangle " + "has not been implemented yet";
        throw new UnsupportedOperationException(msg);
    }

    public void setClip(int x, int y, int width, int height) {
        Rectangle clip = new Rectangle(x, y, width, height);
        this.setClip(clip);
    }

    public Shape getClip() {
        return this.state.getClip();
    }

    public void setClip(Shape clip) {
        this.state.setClip(clip);
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.state.copyArea(x, y, width, height, dx, dy);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.state.drawLine(x1, y1, x2, y2);
    }

    public void fillRect(int x, int y, int width, int height) {
        this.state.fillRect(x, y, width, height);
    }

    public void clearRect(int x, int y, int width, int height) {
        this.state.clearRect(x, y, width, height);
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.state.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.state.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    public void drawOval(int x, int y, int width, int height) {
        this.state.drawOval(x, y, width, height);
    }

    public void fillOval(int x, int y, int width, int height) {
        this.state.fillOval(x, y, width, height);
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.state.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.state.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.state.drawPolyline(xPoints, yPoints, nPoints);
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.state.drawPolygon(xPoints, yPoints, nPoints);
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.state.fillPolygon(xPoints, yPoints, nPoints);
    }

    public boolean drawImage(Image image, int x, int y, ImageObserver observer) {
        return this.state.drawImage(image, x, y, observer);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void dispose() {
        AbstractGraphicsState lState = this.state;
        this.state = null;
        this.config = null;
        this.font = null;
        this.fg = null;
        this.bg = null;
        if (lState != null) {
            lState.dispose();
        }
    }

    public void draw(Shape shape) {
        this.state.draw(shape);
    }

    public boolean drawImage(Image image, AffineTransform xform, ImageObserver obs) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void drawString(String text, int x, int y) {
        this.state.drawString(text, x, y);
    }

    public void drawString(String text, float x, float y) {
        this.state.drawString(text, x, y);
    }

    public void fill(Shape shape) {
        this.state.fill(shape);
    }

    public boolean hit(Rectangle rect, Shape text, boolean onStroke) {
        return this.state.hit(rect, text, onStroke);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.config;
    }

    public void setPaint(Paint paint) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public Object getRenderingHint(RenderingHints.Key hintKey) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public RenderingHints getRenderingHints() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void translate(int x, int y) {
        this.state.translate(x, y);
    }

    public void translate(double tx, double ty) {
        this.state.translate(tx, ty);
    }

    public void rotate(double theta) {
        this.state.rotate(theta);
    }

    public void rotate(double theta, double x, double y) {
        this.state.rotate(theta, x, y);
    }

    public void scale(double scaleX, double scaleY) {
        this.state.scale(scaleX, scaleY);
    }

    public void shear(double shearX, double shearY) {
        this.state.shear(shearX, shearY);
    }

    public void transform(AffineTransform Tx) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void setTransform(AffineTransform Tx) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public AffineTransform getTransform() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public Paint getPaint() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void setBackground(Color color) {
        this.bg = color;
    }

    public Color getBackground() {
        return this.bg;
    }

    public void clip(Shape shape) {
        Shape clip = this.state.getClip();
        if (shape instanceof Rectangle && clip instanceof Rectangle) {
            clip = ((Rectangle)clip).intersection((Rectangle)shape);
            this.state.setClip(clip);
            return;
        }
        String msg = "intersecting current clip shape " + clip + " with new shape " + shape + "has not been implemented yet";
        throw new UnsupportedOperationException(msg);
    }

    public void drawImage(BufferedImage image, BufferedImageOp op, int x, int y) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void drawRenderedImage(RenderedImage image, AffineTransform xform) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void drawRenderableImage(RenderableImage image, AffineTransform xform) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void setComposite(Composite comp) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void setStroke(Stroke stroke) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void setRenderingHints(Map hints) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void addRenderingHints(Map hints) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public Composite getComposite() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public Stroke getStroke() {
        throw new UnsupportedOperationException("not implemented yet");
    }
}

