/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.gcj.convert.UnicodeToBytes;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;

public class PrintStream
extends FilterOutputStream {
    UnicodeToBytes converter;
    char[] work;
    byte[] work_bytes;
    private boolean error;
    private boolean auto_flush;
    private static final char[] line_separator = System.getProperty("line.separator").toCharArray();

    private /* synthetic */ void finit$() {
        this.work = new char[100];
        this.work_bytes = new byte[100];
    }

    public boolean checkError() {
        this.flush();
        return this.error;
    }

    public void close() {
        try {
            this.flush();
            this.out.close();
        }
        catch (InterruptedIOException iioe) {
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            this.setError();
        }
    }

    public void flush() {
        try {
            this.out.flush();
        }
        catch (InterruptedIOException iioe) {
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            this.setError();
        }
    }

    private synchronized void print(String str, boolean println) {
        try {
            this.writeChars(str, 0, str.length());
            if (println) {
                this.writeChars(line_separator, 0, line_separator.length);
            }
            if (this.auto_flush) {
                this.flush();
            }
        }
        catch (InterruptedIOException iioe) {
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            this.setError();
        }
    }

    private synchronized void print(char[] chars, int pos, int len, boolean println) {
        try {
            this.writeChars(chars, pos, len);
            if (println) {
                this.writeChars(line_separator, 0, line_separator.length);
            }
            if (this.auto_flush) {
                this.flush();
            }
        }
        catch (InterruptedIOException iioe) {
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            this.setError();
        }
    }

    private void writeChars(char[] buf, int offset, int count) throws IOException {
        while (count > 0 || this.converter.havePendingBytes()) {
            this.converter.setOutput(this.work_bytes, 0);
            int converted = this.converter.write(buf, offset, count);
            offset += converted;
            count -= converted;
            this.out.write(this.work_bytes, 0, this.converter.count);
        }
    }

    private void writeChars(String str, int offset, int count) throws IOException {
        while (count > 0 || this.converter.havePendingBytes()) {
            this.converter.setOutput(this.work_bytes, 0);
            int converted = this.converter.write(str, offset, count, this.work);
            offset += converted;
            count -= converted;
            this.out.write(this.work_bytes, 0, this.converter.count);
        }
    }

    public void print(boolean bool) {
        this.print(String.valueOf(bool), false);
    }

    public void print(int inum) {
        this.print(String.valueOf(inum), false);
    }

    public void print(long lnum) {
        this.print(String.valueOf(lnum), false);
    }

    public void print(float fnum) {
        this.print(String.valueOf(fnum), false);
    }

    public void print(double dnum) {
        this.print(String.valueOf(dnum), false);
    }

    public void print(Object obj) {
        this.print(obj == null ? "null" : obj.toString(), false);
    }

    public void print(String str) {
        this.print(str == null ? "null" : str, false);
    }

    public synchronized void print(char ch) {
        this.work[0] = ch;
        this.print(this.work, 0, 1, false);
    }

    public void print(char[] charArray) {
        this.print(charArray, 0, charArray.length, false);
    }

    public void println() {
        this.print(line_separator, 0, line_separator.length, false);
    }

    public void println(boolean bool) {
        this.print(String.valueOf(bool), true);
    }

    public void println(int inum) {
        this.print(String.valueOf(inum), true);
    }

    public void println(long lnum) {
        this.print(String.valueOf(lnum), true);
    }

    public void println(float fnum) {
        this.print(String.valueOf(fnum), true);
    }

    public void println(double dnum) {
        this.print(String.valueOf(dnum), true);
    }

    public void println(Object obj) {
        this.print(obj == null ? "null" : obj.toString(), true);
    }

    public void println(String str) {
        this.print(str == null ? "null" : str, true);
    }

    public synchronized void println(char ch) {
        this.work[0] = ch;
        this.print(this.work, 0, 1, true);
    }

    public void println(char[] charArray) {
        this.print(charArray, 0, charArray.length, true);
    }

    public PrintStream(OutputStream out) {
        this(out, false);
    }

    public PrintStream(OutputStream out, boolean af) {
        super(out);
        this.finit$();
        this.converter = UnicodeToBytes.getDefaultEncoder();
        this.error = false;
        this.auto_flush = af;
    }

    protected void setError() {
        this.error = true;
    }

    public void write(int oneByte) {
        try {
            this.out.write(oneByte);
            if (this.auto_flush && oneByte == 10) {
                this.flush();
            }
        }
        catch (InterruptedIOException iioe) {
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            this.setError();
        }
    }

    public void write(byte[] buffer, int offset, int count) {
        try {
            this.out.write(buffer, offset, count);
            if (this.auto_flush) {
                this.flush();
            }
        }
        catch (InterruptedIOException iioe) {
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            this.setError();
        }
    }
}

