#! /bin/bash

# $Id: build.sh,v 1.10 2003/01/07 22:08:16 jt Exp $

# vim: tabstop=4

# parse arguments
version=$1
port=$2

# constants
pkg=fetchmail

# dir variables
Prefix=/usr
TmpDir=/tmp/$pkg.$$
InstallPrefix=$TmpDir$Prefix
BinDir=$InstallPrefix/bin
LibDir=$InstallPrefix/lib
ManDir=$InstallPrefix/man
DocDir=$InstallPrefix/doc/$pkg-$version
CygDocDir=$TmpDir/usr/doc/Cygwin
PatchDir=CYGWIN-PATCHES
SrcDocDir=doc

# configure
configure --prefix=/usr --enable-NTLM --with-ssl --enable-fallback=procmail

# make
make

# make install
make DESTDIR=$TmpDir install

# strip executables
find $InstallPrefix -name '*.exe' | xargs strip

# create man cat dirs
mkdir $ManDir/cat1

# copy Cygwin fetchmail README file
mkdir -p $CygDocDir
cp $PatchDir/README $CygDocDir/$pkg-$version.README

# copy fetchmail COPYRIGHT, README, etc. files
TopFiles=(COPYING FAQ FEATURES INSTALL NEWS NOTES README README.NTLM \
	README.SSL TODO fetchmail-FAQ.html)
mkdir -p $DocDir
cp ${TopFiles[*]} $DocDir

# create package
tar -C $TmpDir -cjf $pkg-$version-$port.tar.bz2 usr

# remove temporary directory
rm -fr $TmpDir
