
#ifndef _PAM_APPL_H
#define _PAM_APPL_H

#include <pwd.h>

enum {PAM_SUCCESS, PAM_USER_UNKNOWN, PAM_AUTH_ERR, PAM_CONV_ERR, PAM_ACCT_EXPIRED, PAM_MAX_ERR };
enum {PAM_SILENT, PAM_PROMPT_ECHO_ON, PAM_PROMPT_ECHO_OFF, PAM_TEXT_INFO, PAM_ERROR_MSG};

/*
  Structures
*/

struct pam_message {
  int msg_style;
};

struct pam_response {
  char * resp;
  int resp_retcode;
};

struct pam_conv {
  int (*conv) (int num_msg, const struct pam_message **msg,
	       struct pam_response **resp, void *appdata_ptr);
  void *appdata_ptr;
};

typedef struct pam_handle {
  int (*conv) (int num_msg, const struct pam_message *msg[],
	       struct pam_response **resp, void *appdata_ptr);
  void *appdata_ptr;
  char name[0];
} pam_handle_t;


/* 
   Declarations
*/

extern int pam_start (const char * dummy, const char *user, const struct pam_conv * conv, 
		      pam_handle_t ** handle);
extern void pam_end (pam_handle_t * handle, int flag);
extern int pam_acct_mgmt (pam_handle_t * handle, int flag);
extern int pam_authenticate (pam_handle_t * handle, int flag);
extern char * pam_strerror (pam_handle_t * pamh, unsigned int pam_error);

#endif /* _PAM_APPL_H */
